# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-875-1 (redhat-cluster-suite)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(66604);
 script_cve_id("CVE-2008-4192", "CVE-2008-4579", "CVE-2008-4580", "CVE-2008-6552", "CVE-2008-6560");
 script_version ("$Revision$");
 script_name("Ubuntu USN-875-1 (redhat-cluster-suite)");

 desc = "The remote host is missing an update to redhat-cluster-suite
announced via advisory USN-875-1.

Details follow:

Multiple insecure temporary file handling vulnerabilities were discovered
in Red Hat Cluster. A local attacker could exploit these to overwrite
arbitrary local files via symlinks. (CVE-2008-4192, CVE-2008-4579,
CVE-2008-4580, CVE-2008-6552)

It was discovered that CMAN did not properly handle malformed configuration
files. An attacker could cause a denial of service (via CPU consumption and
memory corruption) in a node if the attacker were able to modify the
cluster configuration for the node. (CVE-2008-6560)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  ccs                             1.20060222-0ubuntu6.3
  cman                            1.20060222-0ubuntu6.3
  fence                           1.20060222-0ubuntu6.3
  libcman1                        1.20060222-0ubuntu6.3
  rgmanager                       1.20060222-0ubuntu6.3

Ubuntu 8.04 LTS:
  cman                            2.20080227-0ubuntu1.3
  gfs2-tools                      2.20080227-0ubuntu1.3
  rgmanager                       2.20080227-0ubuntu1.3

Ubuntu 8.10:
  cman                            2.20080826-0ubuntu1.3
  gfs2-tools                      2.20080826-0ubuntu1.3
  rgmanager                       2.20080826-0ubuntu1.3

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-875-1

Risk factor : High";

 script_description(desc);

 script_summary("Ubuntu USN-875-1 (redhat-cluster-suite)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Ubuntu Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"redhat-cluster-suite", ver:"1.20060222-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"redhat-cluster-suite-source", ver:"1.20060222-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ccs", ver:"1.20060222-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cman", ver:"1.20060222-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fence-gnbd", ver:"1.20060222-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fence", ver:"1.20060222-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gfs-tools", ver:"1.20060222-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnbd-client", ver:"1.20060222-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnbd-server", ver:"1.20060222-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gulm", ver:"1.20060222-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libccs-dev", ver:"1.20060222-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdlm-dev", ver:"1.20060222-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdlm1", ver:"1.20060222-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgulm-dev", ver:"1.20060222-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgulm1", ver:"1.20060222-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagma1", ver:"1.20060222-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"magma-plugins", ver:"1.20060222-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"magma", ver:"1.20060222-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rgmanager", ver:"1.20060222-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcman-dev", ver:"1.20060222-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcman1", ver:"1.20060222-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libiddev-dev", ver:"1.20060222-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagma-dev", ver:"1.20060222-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"redhat-cluster-suite", ver:"2.20080227-0ubuntu1.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"redhat-cluster-source", ver:"2.20080227-0ubuntu1.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cman", ver:"2.20080227-0ubuntu1.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gfs-tools", ver:"2.20080227-0ubuntu1.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gfs2-tools", ver:"2.20080227-0ubuntu1.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnbd-client", ver:"2.20080227-0ubuntu1.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnbd-server", ver:"2.20080227-0ubuntu1.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcman-dev", ver:"2.20080227-0ubuntu1.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcman2", ver:"2.20080227-0ubuntu1.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdlm-dev", ver:"2.20080227-0ubuntu1.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdlm2", ver:"2.20080227-0ubuntu1.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rgmanager", ver:"2.20080227-0ubuntu1.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"redhat-cluster-suite", ver:"2.20080826-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"redhat-cluster-source", ver:"2.20080826-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cman", ver:"2.20080826-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gfs-tools", ver:"2.20080826-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gfs2-tools", ver:"2.20080826-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnbd-client", ver:"2.20080826-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnbd-server", ver:"2.20080826-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libccs-dev", ver:"2.20080826-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libccs3", ver:"2.20080826-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcman-dev", ver:"2.20080826-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcman3", ver:"2.20080826-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdlm-dev", ver:"2.20080826-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdlm3", ver:"2.20080826-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdlmcontrol-dev", ver:"2.20080826-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdlmcontrol3", ver:"2.20080826-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libfence-dev", ver:"2.20080826-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libfence3", ver:"2.20080826-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rgmanager", ver:"2.20080826-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libccs-perl", ver:"2.20080826-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
