# Carsten Koch-Mauthe <c.koch-mauthe at dn-systems.de>
#
# based on deb_1571_1.nasl by Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
# $Revision: 01 $

if(description)
{
 script_id(90025);
 script_cve_id("CVE-2008-0166");
 script_version ("$Revision: 01 $");
 name = "USN-612-1 through USN-612-11: OpenSSL vulnerability (openssl)";
 script_name(name);

 desc = "The remote host is probably affected by the vulnerabilities described in
USN-612-1,USN-612-2,USN-612-3,USN-612-4: OpenSSL vulnerability

Luciano Bello discovered that the random number generator in Debian's
openssl package is predictable.  This is caused by an incorrect
Debian-specific change to the openssl package (CVE-2008-0166).  As a
result, cryptographic key material may be guessable.

This is a Debian-specific vulnerability which does not affect other
operating systems which are not based on Debian.  However, other systems
can be indirectly affected if weak keys are imported into them.

It is strongly recommended that all cryptographic key material which has
been generated by OpenSSL versions starting with 0.9.8c-1 on Debian
systems is recreated from scratch.  Furthermore, all DSA keys ever used
on affected Debian systems for signing or authentication purposes should
be considered compromised; the Digital Signature Algorithm relies on a
secret random value used during signature generation.

The first vulnerable version, 0.9.8c-1, was uploaded to the unstable
distribution on 2006-09-17, and has since propagated to the testing and
current stable (etch) distributions.  The old stable distribution
(sarge) is not affected.

Affected keys include SSH keys, OpenVPN keys, DNSSEC keys, and key
material for use in X.509 certificates and session keys used in SSL/TLS
connections.  Keys generated with GnuPG or GNUTLS are not affected,
though.

The problem can be corrected by upgrading your system to the actual
packages.

Solution:
http://www.ubuntu.com/usn/usn-612-1
http://www.ubuntu.com/usn/usn-612-2
http://www.ubuntu.com/usn/usn-612-3
http://www.ubuntu.com/usn/usn-612-4
http://www.ubuntu.com/usn/usn-612-5
http://www.ubuntu.com/usn/usn-612-6
http://www.ubuntu.com/usn/usn-612-7
http://www.ubuntu.com/usn/usn-612-8
http://www.ubuntu.com/usn/usn-612-9
http://www.ubuntu.com/usn/usn-612-10
http://www.ubuntu.com/usn/usn-612-11

Risk factor : High";

 script_description(desc);

 summary = "USN-612-1 through USN-612-11: OpenSSL vulnerability (openssl)";
 script_summary(summary);
 script_copyright("Copyright (C) 2008 DN-Systems");

 script_category(ACT_GATHER_INFO);

 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");

   vuln = 0;
   kbrls = get_kb_item("ssh/login/release");
   rls = NULL;
   ver = NULL;
   rel = NULL;
   pkg = NULL;
   rls[0] = "UBUNTU6.06";
   ver[0] = "0.3.3+0.4-0ubuntu0.6.06.2";
   pkg[0] = "openssl-blacklist";
   rls[1] = "UBUNTU6.06";
   ver[1] = "0.3.3+0.4-0ubuntu0.6.06.2";
   pkg[1] = "openssl-blacklist-extra";
   rls[2] = "UBUNTU6.06";
   ver[2] = "1:4.2p1-7ubuntu3.4";
   pkg[2] = "openssh-server";
   rls[3] = "UBUNTU6.06";
   ver[3] = "0.1-0ubuntu0.6.06.1";
   pkg[3] = "openssl-blacklist";
   rls[4] = "UBUNTU7.04";
   ver[4] = "0.1-0ubuntu0.6.06.1";
   pkg[4] = "libssl0.9.8";
   rls[5] = "UBUNTU7.04";
   ver[5] = "1:4.3p2-8ubuntu1.3";
   pkg[5] = "openssh-server";
   rls[6] = "UBUNTU7.04";
   ver[6] = "1.0.13-0ubuntu0.7.04.1";
   pkg[6] = "ssl-cert";
   rls[7] = "UBUNTU7.04";
   ver[7] = "1:4.3p2-8ubuntu1.4";
   pkg[7] = "openssh-client";
   rls[8] = "UBUNTU7.04";
   ver[8] = "1:4.3p2-8ubuntu1.4";
   pkg[8] = "openssh-client-udeb";
   rls[9] = "UBUNTU7.04";
   ver[9] = "2.0.9-5ubuntu0.3";
   pkg[9] = "openvpn";
   rls[10] = "UBUNTU7.04";
   ver[10] = "0.3.3+0.4-0ubuntu0.7.04.2";
   pkg[10] = "openssl-blacklist";
   rls[11] = "UBUNTU7.04";
   ver[11] = "0.3.3+0.4-0ubuntu0.7.04.2";
   pkg[11] = "openssl-blacklist-extra";
   rls[12] = "UBUNTU7.10";
   ver[12] = "0.9.8e-5ubuntu3.2";
   pkg[12] = "libssl0.9.8";
   rls[13] = "UBUNTU7.10";
   ver[13] = "1:4.6p1-5ubuntu0.3";
   pkg[13] = "openssh-server";
   rls[14] = "UBUNTU7.10";
   ver[14] = "1.0.14-0ubuntu0.7.10.1";
   pkg[14] = "ssl-cert";
   rls[15] = "UBUNTU7.10";
   ver[15] = "1:4.6p1-5ubuntu0.5";
   pkg[15] = "openssh-client";
   rls[16] = "UBUNTU7.10";
   ver[16] = "1:4.6p1-5ubuntu0.5";
   pkg[16] = "openssh-client-udeb";
   rls[17] = "UBUNTU7.10";
   ver[17] = "2.0.9-8ubuntu0.3";
   pkg[17] = "openvpn";
   rls[18] = "UBUNTU7.10";
   ver[18] = "0.3.3+0.4-0ubuntu0.7.10.2";
   pkg[18] = "openssl-blacklist";
   rls[19] = "UBUNTU7.10";
   ver[19] = "0.3.3+0.4-0ubuntu0.7.10.2";
   pkg[19] = "openssl-blacklist-extra";
   rls[20] = "UBUNTU8.04";
   ver[20] = "0.9.8g-4ubuntu3.1";
   pkg[20] = "libssl0.9.8";
   rls[21] = "UBUNTU8.04";
   ver[21] = "1:4.7p1-8ubuntu1.1";
   pkg[21] = "openssh-server";
   rls[22] = "UBUNTU8.04";
   ver[22] = "1.0.14-0ubuntu2.1";
   pkg[22] = "ssl-cert";
   rls[23] = "UBUNTU8.04";
   ver[23] = "1:4.7p1-8ubuntu1.2";
   pkg[23] = "openssh-client";
   rls[24] = "UBUNTU8.04";
   ver[24] = "1:4.7p1-8ubuntu1.2";
   pkg[24] = "openssh-client-udeb";
   rls[25] = "UBUNTU8.04";
   ver[25] = "2.1~rc7-1ubuntu3.3";
   pkg[25] = "openvpn";
   rls[26] = "UBUNTU8.04";
   ver[26] = "0.3.3+0.4-0ubuntu0.8.04.3";
   pkg[26] = "openssl-blacklist";
   rls[27] = "UBUNTU8.04";
   ver[27] = "0.3.3+0.4-0ubuntu0.8.04.3";
   pkg[27] = "openssl-blacklist-extra";
   foreach i (keys(rls)) {
     if( kbrls == rls[i] ) {
       if(isdpkgvuln(pkg:pkg[i], ver:ver[i], rls:rls[i])) {
         vuln = 1;
       }
     }
   }

if(vuln) {
    security_hole(0);
}
