#
# Copyright 2001 by Noam Rathaus <noamr@securiteam.com> 
#
# See the Nessus Scripts License for details
#
#

if(description)
{
 script_id(10791);
 script_bugtraq_id(1866, 874);
 script_version ("$Revision: 4340 $");
 script_cve_id("CVE-1999-0996", "CVE-2000-1019");
 
 name = "Ultraseek Web Server Detect";
 script_name(name);
 
 desc = "
Ultraseek Web Server is running on this host. 
Ultraseek has been known to contain security vulnerabilities ranging from 
Buffer Overflows to Cross Site Scripting issues.

Solution: Make sure you are running the latest version of the Ultraseek 
Web Server or disable it if you do not use it.

Additional information:
http://www.securiteam.com/cgi-bin/htsearch?config=htdigSecuriTeamwords=Ultraseek

Risk factor : Low";

 script_description(desc);
 
 summary = "Ultraseek Web Server Detect";
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 family = "General";
 script_family(family);

 script_copyright("This script is Copyright (C) 2001 SecuriTeam");
 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 8765);
 exit(0);
}

# useless message. ultraseek_dos.nasl already do this check
exit(0);

#
# The script code starts here
#
 include("http_func.inc");

 port = get_http_port(default:8765);
 if (!port) exit(0);

 if (get_port_state(port))
 {
   banner = get_http_banner(port:port);
   if(!banner)exit(0);
   if ("Server: Ultraseek" >< banner)
   {
    security_warning(port);
   }
 }
