#################################################################################
#
#
# This script was written by Carsten Koch-Mauthe <c.koch-mauthe at dn-systems.de>
#
# This script is released under the GNU GPLv2
#
# $Revision: 02 $
# Updated by:
# Antu Sanadi <santu@secpod.com> on 16/09/22
#
###############################################################################

if(description)
{
  script_id(90010);
  script_version ("$Revision: 02 $");
  script_cve_id("CVE-2007-0043");
  script_bugtraq_id(24811);
  script_name(".NET JIT Compiler Vulnerability");
  desc = "The remote host is affected by the vulnerabilitys described in
  CVE-2007-0043

  Checking if System.web.dll version is less than 2.0.50727.832

  Impact:
  The Just In Time (JIT) Compiler service in Microsoft .NET Framework 1.0, 1.1,
  and 2.0 for Windows 2000, XP, Server 2003, and Vista allows user-assisted
  remote attackers to execute arbitrary code via unspecified vectors involving
  an unchecked buffer, probably a buffer overflow, aka .NET JIT Compiler
  Vulnerability. Checking if System.web.dll version is less than 2.0.50727.832

  References:
  http://secunia.com/advisories/26003
  http://securitytracker.com/alerts/2007/Jul/1018356.html
  http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-0043
  http://www.microsoft.com/technet/security/Bulletin/ms07-040.mspx

  Solution:
  All Users should upgrade to the latest version.
  http://www.microsoft.com/technet/security/Bulletin/ms07-040.mspx

  Risk factor : High";

  script_description(desc);
  script_summary("Test for .NET JIT Compiler Vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("This script is under GPLv2");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

key  = "SOFTWARE\Microsoft\Windows\CurrentVersion\SharedDlls\";
foreach item (registry_enum_values(key:key))
{
  if("System.Web.dll" >< item)
  {
    path = item;
    break;
  }
}

if(!path){
  exit(0);
}

if("c:" >< path){
  path =  ereg_replace(pattern:"c:", replace:"C:", string:path);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:path);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:path);
dllVer = GetVer(file:file, share:share);

if(!dllVer){
  exit(0);
}

# Check for .Net Framework version 1.0 < 1.0.3705.6060, 1.1 < 1.1.4322.2407
#                                                   and 2.0 < 2.0.50727.832
if(version_in_range(version:dllVer, test_version:"1.0", test_version2:"1.0.3705.6059")||
   version_in_range(version:dllVer, test_version:"1.1", test_version2:"1.1.4322.2406")||
   version_in_range(version:dllVer, test_version:"2.0", test_version2:"2.0.50727.831")){
   security_hole(0);
}
