##################################################################################
# This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
# based on work from
# (C) Tenable Network Security
#
# Ref: Bernardo Quintero of Hispasec <bernardo@hispasec.com>
#
#
# Updated: 03/12/2009 Antu Sanadi <santu@secpod.com>
#
# This script is released under the GNU GPLv2
#
#
################################################################################3
if(description)
{
  script_id(14597);
  script_bugtraq_id(547);
  script_cve_id("CVE-1999-1078");
  script_version("$Revision: 4340 $");
  script_name("WS_FTP client weak stored password");
  desc = "
  The remote host has a version of the WS_FTP client which use a weak
  encryption method to store site password.

  Solution : Upgrade to the newest version of the WS_FTP client
  See also : http://www.ipswitch.com/
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check IPSWITCH WS_FTP version");
  script_category(ACT_GATHER_INFO);
  script_copyright("This script is Copyright (C) 2004 David Maciejak");
  script_family("Windows");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

wsFtpDir = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                               "\App Paths\wsftpgui.exe",item:"path");
if(!wsFtpDir){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:wsFtpDir);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                     string:wsFtpDir + "\wsftpgui.exe");
ftpVer = GetVer(file:file, share:share);

if(!ftpVer){
  exit(0);
}

# Grep Version <= 2007.0.0.2
if(version_is_less_equal(version:ftpVer, test_version:"2007.0.0.2")){
  security_warning(0);
}
