##################################################################################
#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#
#  Ref : Andreas Junestam <andreas.junestam@defcom.com>
# This script is released under the GNU GPLv2
#
# Updated: 03/12/2009 Antu Sanadi <santu@secpod.com>
#
#################################################################################
if(description)
{
  script_id(14585);
  script_bugtraq_id(3507);
  script_version ("$Revision: 4340 $");
  script_name("WS FTP STAT buffer overflow0");
  desc = "
  According to its version number, your remote WS_FTP server is vulnerable
  to a buffer overflow.

  A logged attacker submitting a 'STAT' command along with
  arbitrary characters can potentially execute arbitrary code.

   OpenVAS only checked the version number in the server banner

  Solution : Upgrade to the latest version
  Risk factor : High";

  script_description(desc);
  script_summary("Check WS_FTP server version");

  script_category(ACT_GATHER_INFO);
  script_copyright("This script is Copyright (C) 2004 David Maciejak");
  script_family("FTP");
  script_dependencie("find_service.nes", "secpod_ftp_anonymous.nasl");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include ("ftp_func.inc");

port = 21;
if (! get_port_state(port)){
  exit(0);
}

banner = get_ftp_banner(port);
if(!banner){
  exit(0);
}

# Check for the WS_ FTP Server 2.0.3 and prior.
if(egrep(pattern:"WS_FTP Server (1\.|2\.(0[^0-9]|0\.[0-3][^0-9]))", string: banner)){
  security_hole(port);
}
