###############################################################################
# OpenVAS Vulnerability Test
# $Id: TurboFTP_37726.nasl 7189 2010-03-31 13:58:50Z chandra $
#
# TurboFTP 'DELE' FTP Command Remote Buffer Overflow Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100448);
 script_bugtraq_id(37726);
 script_version ("1.0-$Revision: 7189 $");
 script_tag(name:"risk_factor", value:"High");

 script_name("TurboFTP 'DELE' FTP Command Remote Buffer Overflow Vulnerability");

desc = "Overview:
TurboFTP is prone to a remote buffer-overflow vulnerability.

An attacker can exploit this issue to execute arbitrary code within
the context of the affected application. Failed exploit attempts will
result in a denial-of-service condition.

TurboFTP 1.00.712 is vulnerable; prior versions may also be affected.

Solution:
Updates are available. Please see the references for details.

References:
http://www.securityfocus.com/bid/37726
http://www.corelan.be:8800/index.php/forum/security-advisories/corelan-10-004-turboftp-server-1-00-712-dos/
http://www.turboftp.com/
http://www.tbsoftinc.com/tbserver/turboftp-server-releasenotes.htm

Risk factor : High";

 script_description(desc);
 script_summary("Determine if TurboFTP version is 1.00.712");
 script_category(ACT_GATHER_INFO);
 script_family("FTP");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("find_service.nes","secpod_ftp_anonymous.nasl","ftpserver_detect_type_nd_version.nasl");
 script_require_ports("Services/ftp", 21);
 exit(0);
}

include("ftp_func.inc");
include("version_func.inc");

ftpPort = get_kb_item("Services/ftp");
if(!ftpPort){
  ftpPort = 21;
}

if(get_kb_item('ftp/'+port+'/broken'))exit(0);

if(!get_port_state(ftpPort)){
  exit(0);
}

ftpbanner = get_ftp_banner(port:ftpPort);

if("TurboFTP" >!< ftpbanner)exit(0);

version = eregmatch(pattern: "220 TurboFTP Server ([0-9.]+)", string: ftpbanner);
if(isnull(version[1]))exit(0);

if(version_is_equal(version: version[1], test_version: "1.00.712")) {
 security_hole(port: ftpPort);
 exit(0);
}  

exit(0); 

     
