###############################################################################
# OpenVAS Vulnerability Test
# $Id: awstats_37157.nasl 7196 2010-04-01 09:17:33Z chandra $
#
# AWStats Multiple Unspecified Security Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100380);
 script_bugtraq_id(37157);
 script_version ("1.0-$Revision: 7196 $");
 script_tag(name:"risk_factor", value:"Low");

 script_name("AWStats Multiple Unspecified Security Vulnerabilities");

desc = "Overview:
AWStats is prone to multiple security vulnerabilities.

Very few details are available. We will update this BID as more
information emerges.

The impact of these issues has not been disclosed.

Solution:
Updates are available. Please see the references for details.

References:
http://www.securityfocus.com/bid/37157
http://awstats.sourceforge.net/docs/awstats_changelog.txt
http://awstats.sourceforge.net/

Risk factor : Low";

 script_description(desc);
 script_summary("Determine if AWStats version is < 6.95");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("awstats_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if(!version = get_kb_item(string("www/", port, "/awstats")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less(version: vers, test_version: "6.95")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
