# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-10956 (python-4Suite-XML)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66190);
 script_cve_id("CVE-2009-3720");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("Fedora Core 10 FEDORA-2009-10956 (python-4Suite-XML)");

 desc = "The remote host is missing an update to python-4Suite-XML
announced via advisory FEDORA-2009-10956.

Update Information:

Fixes a denial of service when handling malformed XML (CVE-2009-3720)
ChangeLog:

* Tue Nov  3 2009 Miloslav Trma  - 1.0.2-8
- Fix an expat DoS
Related: #531697

References:

[ 1 ] Bug #531697 - CVE-2009-3720 expat: buffer over-read and crash on XML with malformed UTF-8 sequences
https://bugzilla.redhat.com/show_bug.cgi?id=531697

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update python-4Suite-XML' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-10956

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-10956 (python-4Suite-XML)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"python-4Suite-XML", rpm:"python-4Suite-XML~1.0.2~8.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-4Suite-XML", rpm:"python-4Suite-XML~debuginfo~1.0.2", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
