#
#VID de4d4110-ebce-11dc-ae14-0016179b2dd5
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(60529);
 script_cve_id("CVE-2008-0485", "CVE-2008-0486", "CVE-2008-0629", "CVE-2008-0630");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "mplayer -- multiple vulnerabilities";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   mplayer
   mplayer-esound
   mplayer-gtk
   mplayer-gtk2
   mplayer-gtk-esound
   mplayer-gtk2-esound

CVE-2008-0485
Array index error in libmpdemux/demux_mov.c in MPlayer 1.0 rc2 and
earlier might allow remote attackers to execute arbitrary code via a
QuickTime MOV file with a crafted stsc atom tag.
CVE-2008-0486
Array index vulnerability in libmpdemux/demux_audio.c in MPlayer
1.0rc2 and SVN before r25917, and possibly earlier versions, as used
in Xine-lib 1.1.10, might allow remote attackers to execute arbitrary
code via a crafted FLAC tag, which triggers a buffer overflow.
CVE-2008-0629
Buffer overflow in stream_cddb.c in MPlayer 1.0rc2 and SVN before
r25824 allows remote user-assisted attackers to execute arbitrary code
via a CDDB database entry containing a long album title.
CVE-2008-0630
Buffer overflow in url.c in MPlayer 1.0rc2 and SVN before r25823
allows remote attackers to execute arbitrary code via a crafted URL
that prevents the IPv6 parsing code from setting a pointer to NULL,
which causes the buffer to be reused by the unescape code.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/28779
http://www.vuxml.org/freebsd/de4d4110-ebce-11dc-ae14-0016179b2dd5.html

Risk factor : High";

 script_description(desc);

 summary = "mplayer -- multiple vulnerabilities";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"mplayer");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.11_2")<0) {
    security_note(0, data:"Package mplayer version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mplayer-esound");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.11_2")<0) {
    security_note(0, data:"Package mplayer-esound version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mplayer-gtk");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.11_2")<0) {
    security_note(0, data:"Package mplayer-gtk version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mplayer-gtk2");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.11_2")<0) {
    security_note(0, data:"Package mplayer-gtk2 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mplayer-gtk-esound");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.11_2")<0) {
    security_note(0, data:"Package mplayer-gtk-esound version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mplayer-gtk2-esound");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.11_2")<0) {
    security_note(0, data:"Package mplayer-gtk2-esound version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
