#
#VID 5a5422fd-7e1a-11d9-a9e7-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52187);
 script_bugtraq_id(12446);
 script_cve_id("CVE-2005-0428");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: powerdns";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: powerdns

The installed version of PowerDNS is vulnerable
to a denial of service attack by an attacker
that sends a random stream of data to it.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://ds9a.nl/cgi-bin/cvstrac/pdns/tktview?tn=21
http://doc.powerdns.com/changelog.html#CHANGELOG-2-9-17
http://www.vuxml.org/freebsd/5a5422fd-7e1a-11d9-a9e7-0001020eed82.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: powerdns";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"powerdns");
if(!isnull(bver) && revcomp(a:bver, b:"2.9.17")<0) {
    security_note(0, data:"Package powerdns version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
