###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_clamav_remote_dos_vuln.nasl 0473 2008-11-24 15:09:31Z nov $
#
# ClamAV get_unicode_name() Off-By-One Heap Based BOF Vulnerability
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800067);
  script_version("$Revision: 1.0$");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-5050");
  script_bugtraq_id(32207);
  script_name("ClamAV get_unicode_name() Off-By-One Heap based BOF Vulnerability");
  desc = "

  Overview: This host has ClamAV installed, and is prone to denial of service
  vulnerability.

  Vulnerability Insight:
  The flaw exists due to an off-by-one error in the function get_unicode_name()
  in libclamav/vba_extract.c

  Impact:
  A specially crafted VBA project when opened causes heap buffer overflow
  which can be exploited by attackers to execute arbitrary code on the system
  with clamd privileges or cause the application to crash.

  Impact Level: Application

  Affected Software/OS:
  ClamAV before 0.94.1 on Linux

  Fix: Upgrade to ClamAV 0.94.1
  http://www.clamav.net/

  References:
  http://secunia.com/advisories/32663
  http://xforce.iss.net/xforce/xfdb/46462
  http://www.frsirt.com/english/advisories/2008/3085
  http://sourceforge.net/project/shownotes.php?release_id=637952;group_id=86638

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of ClamAV");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

getPath = find_bin(prog_name:"clamscan", sock:sock);
foreach binaryFile (getPath)
{
  avVer = get_bin_version(full_prog_name:chomp(binaryFile), version_argv:"-V",
                          ver_pattern:"ClamAV ([0-9.]+)", sock:sock);
  if(avVer[1] != NULL)
  {
    if(version_is_less(version:avVer[1], test_version:"0.94.1")){
      security_hole(0);
    }
    ssh_close_connection(); # if version is found and not vulnerable, close and exit
    exit(0);
  }
}
ssh_close_connection();
