###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for xfce4-notes-plugin FEDORA-2007-4368
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861088);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2007-4368");
  script_name( "Fedora Update for xfce4-notes-plugin FEDORA-2007-4368");
  desc = "

  Vulnerability Insight:
  This plugin provides sticky notes for your desktop. You can create a note by
  clicking on the customizable icon with the middle button of your mouse,
  show/hide the notes using the left one, edit the titlebar, change the notes
  background color and much more.


  Affected Software/OS:
  xfce4-notes-plugin on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-December/msg00567.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of xfce4-notes-plugin");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"xfce4-notes-plugin", rpm:"xfce4-notes-plugin~1.6.0~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xfce4-notes-plugin-debuginfo", rpm:"xfce4-notes-plugin-debuginfo~1.6.0~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xfce4-notes-plugin", rpm:"xfce4-notes-plugin~1.6.0~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xfce4-notes-plugin-debuginfo", rpm:"xfce4-notes-plugin-debuginfo~1.6.0~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xfce4-notes-plugin", rpm:"xfce4-notes-plugin~1.6.0~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}