###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_kaspersky_internet_sec_suite_dos_vuln.nasl 661 2008-12-17 17:57:05Z dec $
#
# Kaspersky Internet Security Suite Malformed MIME Message DoS Vulnerability
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800086);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2008-5426");
  script_name("Kaspersky Internet Security Suite Malformed MIME Message DoS Vulnerability");
  desc = "

  Overview: This host has Kaspersky Internet Security Suite installed and is
  prone to denial of service vulnerability.

  Vulnerability Insight:
  Flaw is caused due to improper handling of multipart/mixed e-mail messages
  with many MIME parts and e-mail messages with many Content-type: message/rfc822
  headers.

  Impact:
  Successful exploitation could result in application crash.

  Impact Level: Application

  Affected Software/OS:
  Kaspersky Internet Security Suite 2009 on Windows.

  Fix: Upgrade to latest version of Kaspersky Internet Security Suite
  http://www.kaspersky.com/downloads

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Kaspersky Internet Security Suite");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!(get_kb_item("SMB/WindowsVersion"))){
  exit(0);
}

uninstall = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:uninstall)){
    exit(0);
}

foreach key (registry_enum_keys(key:uninstall))
{
  kisName = registry_get_sz(key:uninstall + key, item:"DisplayName");
  if("Kaspersky Internet Security" >< kisName)
  {
    # Kaspersky Internet Security 2009
    if("Kaspersky Internet Security 2009" >< kisName){
      security_warning(0);
    }
    exit(0);
  }
}
