###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_tor_mem_crptn_vuln_lin.nasl 942 2009-02-05 18:08:29Z feb $
#
# Tor Unspecified Remote Memory Corruption Vulnerability (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800350);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-0414");
  script_bugtraq_id(33399);
  script_name("Tor Unspecified Remote Memory Corruption Vulnerability (Linux)");
  desc = "

  Overview: This host is installed with Tor and is prone to unspecified remote
  Memory Corruption vulnerability.

  Vulnerability Insight:
  Due to unknown impact, remote attachers can trigger heap corruption on
  the application.

  Impact:
  A remote attcker can execute arbitrary code on the target system and
  can cause denial-of-service.

  Impact level: Application

  Affected Software/OS:
  Tor version prior to 0.2.0.33 on Linux.

  Fix: Upgrade to version 0.2.0.33 or later
  https://www.torproject.org/download-unix.html.en

  References:
  http://secunia.com/advisories/33635
  http://secunia.com/advisories/33677
  http://securitytracker.com/alerts/2009/Jan/1021633.html
  http://blog.torproject.org/blog/tor-0.2.0.33-stable-released

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Tor");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("secpod_tor_detect_lin.nasl");
  script_require_keys("Tor/Linux/Ver");
  exit(0);
}


include("version_func.inc");

torVer = get_kb_item("Tor/Linux/Ver");
if(torVer != NULL)
{
  # Grep for version prior to 0.2.0.33
  if(version_is_less(version:torVer, test_version:"0.2.0.33")){
    security_hole(0);
  }
}
