###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for xen-3.0 vulnerability USN-527-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840119);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.9");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "527-1");
  script_cve_id("CVE-2007-4993");
  script_name( "Ubuntu Update for xen-3.0 vulnerability USN-527-1");
  desc = "

  Vulnerability Insight:

  Joris van Rantwijk discovered that the Xen host did not correctly validate
  the contents of a Xen guests's grug.conf file.  Xen guest root users could
  exploit this to run arbitrary commands on the host when the guest system
  was rebooted.

  Affected Software/OS:
  xen-3.0 vulnerability on Ubuntu 7.04

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-October/000604.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of xen-3.0 vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libxen3.0-dev", ver:"3.0.3-0ubuntu10.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxen3.0", ver:"3.0.3-0ubuntu10.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-xen3.0", ver:"3.0.3-0ubuntu10.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xen-hypervisor", ver:"3.0-i386-pae_3.0.3-0ubuntu10.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xen-hypervisor", ver:"3.0-i386_3.0.3-0ubuntu10.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xen-ioemu", ver:"3.0_3.0.3-0ubuntu10.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xen-utils", ver:"3.0_3.0.3-0ubuntu10.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xen-docs", ver:"3.0_3.0.3-0ubuntu10.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}