###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_b2evolution_detect.nasl 2378 2009-06-01 16:50:36Z may $
#
# b2evolution Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900712);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("b2evolution Version Detection");
  desc = "
  Overview: This script finds the installed b2evolution script and saves the
  version in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Set the Version of b2evolution in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80, 8080);
  exit(0);
}


include("http_func.inc");

b2Port = get_http_port(default:80);
if(!b2Port){
  b2Port = 80;
}

if(!get_port_state(b2Port)){
  exit(0);
}

foreach path (make_list("/blogs/htsrv", "/b2evolution/blogs/htsrv", cgi_dirs()))
{
  request  = http_get(item:string(path, "/login.php"), port:b2Port);
  response = http_send_recv(port:b2Port, data:request);
 
  if("b2evolution" >< response)
  {
    b2Ver = eregmatch(pattern:"b2evolution ([0-9.]+)", string:response);
    if(b2Ver[1] != NULL)
    {
      set_kb_item(name:"www/" + b2Port + "/b2evolution",
                  value:b2Ver[1] + " under " + path);
      security_note(data:"b2evolution Version " + b2Ver[1] +
                " running at location " + path +  " was detected on the host");
    }
  }
}
