###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_uebimiau_webmail_info_disc_vuln.nasl 4797 2009-09-18 17:38:29Z sep $
#
# Uebimiau Webmail Information Disclosure Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901024);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-3199");
  script_name("Uebimiau Webmail Information Disclosure Vulnerability");
  desc = "
  Overview: This host is running Uebimiau Webmail and is prone to Information
  Disclosure Vulnerability.

  Vulnerability Insight:
  Error is caused due to improper sanitization of user supplied input in
  the 'system_admin/admin.ucf' file.

  Impact:
  Successful exploitation will let the attacker to gain sensitive information
  in the context of the affected web application.

  Impact Level: Application

  Affected Software/OS:
  Uebimiau Webmail version 3.2.0-2.0

  Fix: No solution or patch is available as on 18th September, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.uebimiau.org/download.php

  References:
  http://www.milw0rm.com/exploits/9493
  http://xforce.iss.net/xforce/xfdb/52724

  CVSS Score:
    CVSS Base Score      : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score  : 4.5
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Uebimiau Webmail");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_uebimiau_webmail_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

uwebPort = get_http_port(default:80);
if(!uwebPort){
  exit(0);
}

uwebVer = get_kb_item("www/" + uwebPort + "/Uebimiau/Webmail");
if(!uwebVer){
  exit(0);
}

uwebVer = eregmatch(pattern:"^(.+) under (/.*)$", string:uwebVer);

if((!safe_checks()) && (uwebVer[2] != NULL))
{
  request = http_get(item:string(uwebVer[2] + "/inc/database/system_admin"+
                                             "/admin.ucf"), port:uwebPort);
  response = http_send_recv(port:uwebPort, data:request);

  if(eregmatch(pattern:":[a-z0-9]{32,32}", string:response) &&
     egrep(pattern:"^HTTP/.* 200 OK", string:response))
  {
    security_warning(uwebPort);
    exit(0);
  }
}

if(uwebVer[1] != NULL)
{
  if(version_is_equal(version:uwebVer[1], test_version:"3.2.0.2.0")){
    security_warning(uwebPort);
  }
}
