###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_xitami_server_detect.nasl 1210 2009-04-28 16:44:19Z apr $
#
# Xitami Server Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900547);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("Xitami Server Version Detection");
  desc = "

  Overview : This script detects the installed version of Xitami Server
  and saves the result in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set KB for the Version of Xitami Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80, "Services/ftp", 21);
  exit(0);
}


include("ftp_func.inc");
include("http_func.inc");

wwwPort = get_http_port(default:80);
if(!wwwPort){
  wwwPort = 80;
}

if(!get_port_state(wwwPort)){
  exit(0);
}

soc = open_sock_tcp(wwwPort);
if(!soc)exit(0);

req = string("GET /\r\n\r\n", "Host: ", get_host_name(), "\r\n");
send(socket:soc, data:req);
rcvRes = http_recv(socket:soc);
close(soc);

if("Xitami" >!< rcvRes){
  exit(0);
}

xitaVer = eregmatch(pattern:"Xitami\/([0-9]\.[0-9.]+)([a-z][0-9]?)?",
                    string:rcvRes);
if(xitaVer == NULL)
{
  ftpPort = get_kb_item("Services/ftp");

  if(!ftpPort){
    ftpPort = 21;
  }

  if(!get_port_state(ftpPort)){
    exit(0);
  }

  # Get the version from banner
  banner = get_ftp_banner(port:ftpPort);
  xitaVer = eregmatch(pattern:"Xitami.*([0-9]\.[0-9.]+)([a-z][0-9]?)?",
                      string: banner);
}

if(xitaVer[1] != NULL)
{
  if(xitaVer[2] != NULL){
    xVer = xitaVer[1] + "." + xitaVer[2];
  }
  else
    xVer = xitaVer[1];
}

if(xVer){
  set_kb_item(name:"Xitami/Ver", value:xVer);
  security_note(data:"Xitami Server version " + xVer +
                     " was detected on the host");
}
