#
# This script was written by Vincent Renardias <vincent@strongholdnet.com>
#
# Licence : GPL v2
#

if(description)
{
 script_id(10698);
 script_bugtraq_id(2513);
 script_version ("$Revision: 8045 $");
 script_tag(name:"risk_factor", value:"High");
 name = "WebLogic Server /%00/ bug";
 
 script_name(name);
 
 desc = "
Requesting a URL with '%00', '%2e', '%2f' or '%5c' appended to it
makes some WebLogic servers dump the listing of the page 
directory, thus showing potentially sensitive files.

An attacker may also use this flaw to view
the source code of JSP files, or other dynamic content.

Reference : http://www.securityfocus.com/bid/2513
Risk factor : High
Solution : upgrade to WebLogic 6.0 with Service Pack 1";

 script_description(desc);
 
 summary = "Make a request like http://www.example.com/%00/";
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright("This script is Copyright (C) 2001 StrongHoldNet");
 family = "Remote file access";
 script_family(family);
 script_dependencie("http_version.nasl","oracle_webLogic_server_detect.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#
include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

function http_getdirlist(itemstr, port) {
 buffer = http_get(item:itemstr, port:port);
 rbuf   = http_keepalive_send_recv(port:port, data:buffer);
 if (! rbuf ) exit(0);
 data = tolower(rbuf);
 debug_print(level: 2, 'Answer to GET ', itemstr, ' on port ', port, ': ', rbuf);
  if(("directory listing of" >< data) || ("index of" >< data))
  {
   log_print('Found directory listing: itemstr=', itemstr, ', port=', port, '\n');
   if(strlen(itemstr) > 1) security_hole(port:port);
   # If itemstr = / we exit the test to avoid FP.
   exit(0);
  }
}

port = get_http_port(default:80);
if(!get_kb_item(string("www/", port, "/WebLogic_Server")))exit(0); # make sure it is a WebLogic Server at this port.

if(get_port_state(port))
{
  http_getdirlist(itemstr:"/", port:port);	# Anti FP
  http_getdirlist(itemstr:"/%2e/", port:port);
  http_getdirlist(itemstr:"/%2f/", port:port);
  http_getdirlist(itemstr:"/%5c/", port:port);
  http_getdirlist(itemstr:"/%00/", port:port);
}
