# OpenVerse Plugin Module
#
# changed
# 
# This module contains all of the plugin related stuff. 
# It will basically register all of your installed plugins.
#
# Module Name		- Plugin Module
# Current Maintainter 	- Cruise <cruise@openverse.org>
# Sourced By		- Main Module
#
# Copyright (C) 1999 David Gale <cruise@openverse.org>
# For more information visit http://OpenVerse.org/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

# RegisterPlugin is used to register your plugin with the 
# various available traps. There are two different types of traps.
# Some functions have both traps. Others have only one type..
# A (pre) trap will process the plugin BEFORE it processes it's own stuff
# or slightly after it begins (some functions need to set variables and
# this will normally be done before a plugin is called) A (post) trap will
# process the plugin AFTER it's done it's regular work.
#
# Functions with plugin support currently include....
# 
# MoveTo		(pre) Trapped when the user clicks on the screen to
#			      move.
# NewPerson		(pre) Trapped when someone enters the room. 
# PersonLeft		(pre) Trapped when someone leaves the room. 
# ChangeAvatar		(post) Trapped when YOU change your avater.
# ChangeUserAvatar	(post) Trapped when someone changes their avater.
#
# You will have access to all of the variables which are passed to the
# parent function. Your function should accomidate ALL of them.
# Your plugin should return 1 or 0. 1 will tell the parent function
# to continue processing. 0 will tell the parent function to exit
# it's normal processing.

proc RegisterPlugin {plugin trap function} {
	global MV

	lappend MV(plugin.traps.$trap) "$plugin"
	set MV(plugin.traps.$trap.$plugin) "$function"
}

#
# Make a list of plugins. and register with
# available services.
#
foreach dir [List_Plugins] {
	if ![file isdirectory "$dir"] {continue}
	lappend MV(plugins) [file tail "$dir"]
	source [file nativename "$dir/PlugInit.tcl"]
	#TODO Report any errors here.
}


#
# These are our internal plugins. (plugin support for clickable things)
#

lappend MV(plugins) MV_DlWindows
RegisterPlugin MV_DlWindows MoveTo.Pre MV_DlWindows

