/*

    Ophcrack is a Lanmanager/NTLM hash cracker based on the faster time-memory
    trade-off using rainbow tables. 
    
    Created with the help of: Maxime Mueller, Luca Wullschleger, Claude
    Hochreutiner, Andreas Huber and Etienne Dysli.

    Copyright 2006 Philippe Oechslin, Cedric Tissieres

    Ophcrack is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Ophcrack is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Ophcrack; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

    This program is released under the GPL with the additional exemption 
    that compiling, linking, and/or using OpenSSL is allowed.
*/

/* LanManager hash functions (libdes version and Jack the ripper MMX version) */

/* 
 * $Log: make_hash.c,v $
 * Revision 2.0  2005/03/24 tissieres
 * Modified for win32
 *
 * Revision 1.0  2004/07/09 12:54:15  oechslin
 * Initial revision
 *
 */

#include "make_hash.h"
#include <openssl/ssl.h> 
#include <openssl/des.h>
#include <openssl/md4.h>
#include <string.h>
#ifndef WIN32
#include <netinet/in.h>
#else /* WIN32 */
#include <winsock.h>
#endif /* WIN32 */


unsigned char magic[] = { 0x4B, 0x47, 0x53, 0x21, 0x40, 0x23, 0x24, 0x25 };

void make_hash(unsigned char *str, unsigned char  *out) {

    static unsigned char key[8];
    des_key_schedule ks;

    key[0]=str[0];
    key[1]=  (str[0] << 7) | (str[1] >> 1);
    key[2] = (str[1] << 6) | (str[2] >> 2);
    key[3] = (str[2] << 5) | (str[3] >> 3);
    key[4] = (str[3] << 4) | (str[4] >> 4);
    key[5] = (str[4] << 3) | (str[5] >> 5);
    key[6] = (str[5] << 2) | (str[6] >> 6);
    key[7] = (str[6] << 1) ;
    des_set_odd_parity(&key);
    des_set_key(&key, ks);
    des_ecb_encrypt((des_cblock *)magic, (des_cblock *)out, ks, DES_ENCRYPT);
}

void make_nthash(char *pw, char *out) {
  size_t unipwlen;
  unsigned short int unipw[128];
  unsigned char *s;
  MD4_CTX ctx;

  /* convert to unicode */
  for (unipwlen = 0, s = (unsigned char *)pw; unipwlen < strlen(pw); s++) {
    unipw[unipwlen++] = htons(*s << 8);
  }

  /* Compute MD4 of Unicode password */
  MD4_Init(&ctx);
  MD4_Update(&ctx, (unsigned char *) unipw, unipwlen * sizeof(*unipw));
  MD4_Final((unsigned char *)out, &ctx);

}
