/*

    Ophcrack is a Lanmanager/NTLM hash cracker based on the faster time-memory
    trade-off using rainbow tables. 
    
    Created with the help of: Maxime Mueller, Luca Wullschleger, Claude
    Hochreutiner, Andreas Huber and Etienne Dysli.

    Copyright 2006 Philippe Oechslin, Cedric Tissieres

    Ophcrack is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Ophcrack is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Ophcrack; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

    This program is released under the GPL with the additional exemption 
    that compiling, linking, and/or using OpenSSL is allowed.
*/

/* LanManager/NTLM password cracker using a Time-Memory Trade-Off */
/* Revision 2.3  2006/07/21 tissieres
 * tables auto-detect, max_hash increased
 * 
 * Revision 2.2  2006/03/20 tissieres
 * Integration for livecd version
 *
 * Revision 2.1  2005/12/06 tissieres
 * Added tables modification feature, readahead
 *
"$Id: ophcrack.h,v 2.0 2005/03/24 tissieres Exp $";
*/


#define MAX_HASH 35000

#ifdef WIN32
struct tms {
  long tms_utime;
  long tms_stime;
  long tms_cutime;
  long tms_cstime;
};

#endif /* WIN32 */

int read_file(char* filename);
int read_line(char* line);
int remove_line(int hash);
int main_cmd();
void clear_passwd_arrays(void);
int find_tables();
#ifdef LIVECD
int init_livecd(char *dir);
#endif
int auto_detect_tables(char *directory);
