/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of Qtopia Environment.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
***********************************************************************
**
** Enhancements by Dan Williams, <williamsdr@acm.org>
**
**********************************************************************/

#include "settings.h"

#include <qpe/config.h>
#include <qpe/qpeapplication.h>
#if defined(Q_WS_QWS) && !defined(QT_NO_COP)
#include <qpe/qcopenvelope_qws.h>
#endif

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qradiobutton.h>
#if QT_VERSION >= 300
#include <qstylefactory.h>
#endif

#include <stdlib.h>

static const char* const image0_data[] = {
"32 32 2 1",
". c None",
"# c #000000",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"..........###...................",
"...........##...................",
"...........##...................",
"...........##...................",
"...........##...................",
"...........##...................",
"..####.##..##.####.....#####....",
".########..########...#######...",
"###...###..###...###.###...##...",
"##.....##..##.....##.##.........",
"##.....##..##.....##.##.........",
"##.....##..##.....##.##.........",
"###...###..###...###.###...##...",
".########..########...#######.##",
"..####.##.###.####.....#####..##",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................"};

static const char* const image1_data[] = { 
"32 32 2 1",
". c None",
"# c #000000",
"....................##..........",
"....................##..........",
"................................",
"..............##...##...........",
".............###...###..........",
".............##.....##..........",
".............##.....##..........",
".............##.....##..........",
".............###...###..........",
"..............#######...........",
"...............#####............",
"................................",
"...............#####............",
"..............#######...........",
".............###...###..........",
".............##.....##..........",
".............##.....##..........",
".............##.....##..........",
"..............##...##...........",
".......###############..........",
".......###############..........",
".......#.............#..........",
"................................",
".............#########..........",
".............#########..........",
"..............##...##...........",
".............##.....##..........",
".............##.....##..........",
".............##.....##..........",
".............###...###..........",
"..............#######...........",
"...............#####............"};

static const char* const image2_data[] = {
"32 32 2 1",
". c None",
"# c #000000",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"##..#####.....####.###.##.####..",
"##.#######...########..########.",
"...##...###.###...###..###...###",
".........##.##.....##..##.....##",
".........##.##.....##..##.....##",
".........##.##.....##..##.....##",
"...##...###.###...###..###...###",
"...#######...########..########.",
"....#####.....####.##..##.####..",
"...................##...........",
"...................##...........",
"...................##...........",
"...................##...........",
"...................##...........",
"...................###..........",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................"};

static const char* const image3_data[] = { 
"32 32 2 1",
". c None",
"# c #000000",
"............#####...............",
"...........#######..............",
"..........###...###.............",
"..........##.....##.............",
"..........##.....##.............",
"..........##.....##.............",
"...........##...##..............",
"..........#########.............",
"..........#########.............",
"................................",
"..........#.............#.......",
"..........###############.......",
"..........###############.......",
"...........##...##..............",
"..........##.....##.............",
"..........##.....##.............",
"..........##.....##.............",
"..........###...###.............",
"...........#######..............",
"............#####...............",
"................................",
"............#####...............",
"...........#######..............",
"..........###...###.............",
"..........##.....##.............",
"..........##.....##.............",
"..........##.....##.............",
"..........###...###.............",
"...........##...##..............",
"................................",
"..........##....................",
"..........##...................."};

RotationSettings::RotationSettings( QWidget* parent,  const char* name, WFlags fl )
    : QDialog( parent, name, TRUE, fl )
{
    QPixmap image0( ( const char** ) image0_data );
    QPixmap image1( ( const char** ) image1_data );
    QPixmap image2( ( const char** ) image2_data );
    QPixmap image3( ( const char** ) image3_data );

    setCaption( tr( "Rotation Settings" ) );

    QGridLayout* RotationSettingsBaseLayout = new QGridLayout( this );
    RotationSettingsBaseLayout->setSpacing( 6 );
    RotationSettingsBaseLayout->setMargin( 11 );

    QButtonGroup* ButtonGroup1_2 = new QButtonGroup( this, "ButtonGroup1_2" );
    ButtonGroup1_2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, ButtonGroup1_2->sizePolicy().hasHeightForWidth() ) );
    ButtonGroup1_2->setMinimumSize( QSize( 63, 0 ) );
    ButtonGroup1_2->setLineWidth( 0 );
    ButtonGroup1_2->setTitle( tr( "" ) );
    ButtonGroup1_2->setColumnLayout(0, Qt::Vertical );
    ButtonGroup1_2->layout()->setSpacing( 0 );
    ButtonGroup1_2->layout()->setMargin( 0 );
    QVBoxLayout* ButtonGroup1_2Layout = new QVBoxLayout( ButtonGroup1_2->layout() );
    ButtonGroup1_2Layout->setAlignment( Qt::AlignTop );
    ButtonGroup1_2Layout->setSpacing( 0 );
    ButtonGroup1_2Layout->setMargin( 0 );

    rot0 = new QRadioButton( ButtonGroup1_2, "rot0" );
    rot0->setPixmap( image0 );
    rot0->setChecked( TRUE );
    ButtonGroup1_2Layout->addWidget( rot0 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    ButtonGroup1_2Layout->addItem( spacer );

    rot90 = new QRadioButton( ButtonGroup1_2, "rot90" );
    rot90->setPixmap( image1 );
    ButtonGroup1_2Layout->addWidget( rot90 );
    QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    ButtonGroup1_2Layout->addItem( spacer_2 );

    rot180 = new QRadioButton( ButtonGroup1_2, "rot180" );
    rot180->setPixmap( image2 );
    ButtonGroup1_2Layout->addWidget( rot180 );
    QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    ButtonGroup1_2Layout->addItem( spacer_3 );

    rot270 = new QRadioButton( ButtonGroup1_2, "rot270" );
    rot270->setPixmap( image3 );
    ButtonGroup1_2Layout->addWidget( rot270 );

    RotationSettingsBaseLayout->addMultiCellWidget( ButtonGroup1_2, 0, 1, 0, 0 );

    rotation_message = new QLabel( this, "rotation_message" );
    rotation_message->setText( tr( "<p>Select orientation from options at left." ) );
//    rotation_message->setAlignment( int( QLabel::AlignCenter ) );

    RotationSettingsBaseLayout->addWidget( rotation_message, 0, 1 );

    restart = new QCheckBox( tr( "Automatically restart Opie?" ), this, "restartCB" );
    restart->setChecked( TRUE );

    RotationSettingsBaseLayout->addWidget( restart, 1, 1 );


    reset();
#ifdef SINGLE_APP
#ifdef QT_DEMO_SINGLE_FLOPPY
    rotation_message->setText(
        tr( "<p>Rotation is not enabled in this demo, however this is a supported feature of Qt/Embedded." ) );
#endif
#endif

    showMaximized();
}

RotationSettings::~RotationSettings()
{
}

void RotationSettings::accept()
{
    applyRotation();
    QDialog::accept();
}

static int initrot=-1;
static int initsetting;

void RotationSettings::applyRotation()
{
    int r = 0;
    if ( rot270->isChecked() )
        r = 270;
    else if ( rot180->isChecked() )
        r = 180;
//        setRotation( 180 );
    else if ( rot90->isChecked() )
        r = 90;
    else if ( rot0->isChecked() )
        r = 0;
    setRotation( r );

    if ( r != initsetting && restart->isChecked() )
    {
        QCopEnvelope e( "QPE/System", "restart()" );
    }
}

void RotationSettings::setRotation(int r)
{
    QPEApplication::setDefaultRotation((r+initrot)%360);
}

void RotationSettings::reject()
{
    reset();
    QDialog::reject();
}

void RotationSettings::reset()
{
    QString d = getenv("QWS_DISPLAY");
    int r=0;
    if ( d.contains("Rot90") ) {
        r = 90;
    } else if ( d.contains("Rot180") ) {
        r = 180;
    } else if ( d.contains("Rot270") ) {
        r = 270;
    }
    if ( initrot == -1 )
        initrot = r;
    r = (r-initrot+360) % 360;
    rot0->setChecked(r==0);
    rot90->setChecked(r==90);
    rot180->setChecked(r==180);
    rot270->setChecked(r==270);
    initsetting = r;
}


void RotationSettings::done ( int r )
{
	QDialog::done ( r );
	close ( );
}
