/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.dom;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.html.HTMLDocument;
import sun.plugin.dom.DOMObject;
import sun.plugin.dom.DOMObjectTypeHelper;
import sun.plugin.dom.css.CSSStyleSheet;
import sun.plugin.dom.exception.PluginNotSupportedException;
import sun.plugin.dom.html.HTMLAnchorElement;
import sun.plugin.dom.html.HTMLAppletElement;
import sun.plugin.dom.html.HTMLAreaElement;
import sun.plugin.dom.html.HTMLBRElement;
import sun.plugin.dom.html.HTMLBaseElement;
import sun.plugin.dom.html.HTMLBodyElement;
import sun.plugin.dom.html.HTMLButtonElement;
import sun.plugin.dom.html.HTMLDListElement;
import sun.plugin.dom.html.HTMLDirectoryElement;
import sun.plugin.dom.html.HTMLDivElement;
import sun.plugin.dom.html.HTMLElement;
import sun.plugin.dom.html.HTMLFieldSetElement;
import sun.plugin.dom.html.HTMLFontElement;
import sun.plugin.dom.html.HTMLFormElement;
import sun.plugin.dom.html.HTMLFrameElement;
import sun.plugin.dom.html.HTMLFrameSetElement;
import sun.plugin.dom.html.HTMLHRElement;
import sun.plugin.dom.html.HTMLHeadElement;
import sun.plugin.dom.html.HTMLHeadingElement;
import sun.plugin.dom.html.HTMLHtmlElement;
import sun.plugin.dom.html.HTMLIFrameElement;
import sun.plugin.dom.html.HTMLImageElement;
import sun.plugin.dom.html.HTMLInputElement;
import sun.plugin.dom.html.HTMLIsIndexElement;
import sun.plugin.dom.html.HTMLLIElement;
import sun.plugin.dom.html.HTMLLabelElement;
import sun.plugin.dom.html.HTMLLegendElement;
import sun.plugin.dom.html.HTMLLinkElement;
import sun.plugin.dom.html.HTMLMapElement;
import sun.plugin.dom.html.HTMLMenuElement;
import sun.plugin.dom.html.HTMLMetaElement;
import sun.plugin.dom.html.HTMLModElement;
import sun.plugin.dom.html.HTMLOListElement;
import sun.plugin.dom.html.HTMLObjectElement;
import sun.plugin.dom.html.HTMLOptGroupElement;
import sun.plugin.dom.html.HTMLOptionElement;
import sun.plugin.dom.html.HTMLParagraphElement;
import sun.plugin.dom.html.HTMLParamElement;
import sun.plugin.dom.html.HTMLPreElement;
import sun.plugin.dom.html.HTMLQuoteElement;
import sun.plugin.dom.html.HTMLScriptElement;
import sun.plugin.dom.html.HTMLSelectElement;
import sun.plugin.dom.html.HTMLStyleElement;
import sun.plugin.dom.html.HTMLTableCaptionElement;
import sun.plugin.dom.html.HTMLTableCellElement;
import sun.plugin.dom.html.HTMLTableColElement;
import sun.plugin.dom.html.HTMLTableElement;
import sun.plugin.dom.html.HTMLTableRowElement;
import sun.plugin.dom.html.HTMLTableSectionElement;
import sun.plugin.dom.html.HTMLTextAreaElement;
import sun.plugin.dom.html.HTMLTitleElement;
import sun.plugin.dom.html.HTMLUListElement;
import sun.plugin.dom.stylesheets.StyleSheet;

public class DOMObjectFactory {
    private static final String HTML_TAGNAME = "tagName";
    private static final String ATTR_TYPE = "type";
    private static HashMap elmTagClassMap = null;
    private static HashMap elmTypeClassMap = null;

    public static org.w3c.dom.html.HTMLElement createHTMLElement(DOMObject dOMObject, HTMLDocument hTMLDocument) {
        Object object = DOMObjectFactory.createHTMLObject(dOMObject, hTMLDocument);
        if (object instanceof org.w3c.dom.html.HTMLElement) {
            return (org.w3c.dom.html.HTMLElement)object;
        }
        return null;
    }

    public static Object createCommonDOMObject(DOMObject dOMObject, Document document) {
        if (dOMObject == null) {
            return null;
        }
        Class clazz = DOMObjectTypeHelper.getHTMLElementClass(dOMObject);
        if (clazz == null) {
            clazz = DOMObjectFactory.getRealClassByTagName(dOMObject);
        }
        if (clazz != null) {
            return DOMObjectFactory.createHTMLObject(clazz, dOMObject, (HTMLDocument)document);
        }
        clazz = DOMObjectTypeHelper.getDOMCoreClass(dOMObject);
        return DOMObjectFactory.createDOMCoreObject(clazz, dOMObject, document);
    }

    private static Object createDOMCoreObject(Class clazz, DOMObject dOMObject, Document document) {
        try {
            Class[] classArray = new Class[]{DOMObject.class, Document.class};
            Constructor constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{dOMObject, document};
            return constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new PluginNotSupportedException("DOMObjectFactory::createDOMCoreObject() cannot wrap " + dOMObject);
        }
    }

    public static Object createHTMLObject(DOMObject dOMObject, HTMLDocument hTMLDocument) {
        if (dOMObject == null) {
            return null;
        }
        Class<HTMLElement> clazz = DOMObjectTypeHelper.getHTMLElementClass(dOMObject);
        if (clazz == null) {
            clazz = HTMLElement.class;
        }
        return DOMObjectFactory.createHTMLObject(clazz, dOMObject, hTMLDocument);
    }

    private static Object createHTMLObject(Class clazz, DOMObject dOMObject, HTMLDocument hTMLDocument) {
        Class clazz2;
        if (clazz != null && (clazz.equals(HTMLElement.class) || clazz.equals(HTMLObjectElement.class) || clazz.equals(HTMLUListElement.class) || clazz.equals(HTMLButtonElement.class) || clazz.equals(HTMLOptionElement.class) || clazz.equals(HTMLInputElement.class) || clazz.equals(HTMLQuoteElement.class)) && (clazz2 = DOMObjectFactory.getRealClassByTagName(dOMObject)) != null) {
            clazz = clazz2;
        }
        try {
            Class[] classArray = new Class[]{DOMObject.class, HTMLDocument.class};
            Constructor constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{dOMObject, hTMLDocument};
            return constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new PluginNotSupportedException("DOMObjectFactory::createHTMLElement() cannot wrap " + dOMObject);
        }
    }

    public static Object createStyleSheetObject(DOMObject dOMObject, Document document, Node node) {
        if (dOMObject == null) {
            return null;
        }
        Class clazz = DOMObjectTypeHelper.getStyleSheetClass(dOMObject);
        if (clazz != null) {
            Class[] classArray;
            if (clazz.equals(StyleSheet.class) && (classArray = DOMObjectFactory.getRealClassByType(dOMObject)) != null) {
                clazz = classArray;
            }
            try {
                classArray = new Class[]{DOMObject.class, Document.class, Node.class};
                Constructor constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{dOMObject, document, node};
                return constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new PluginNotSupportedException("DOMObjectFactory::createStyleSheet() cannot wrap " + dOMObject);
    }

    public static org.w3c.dom.stylesheets.StyleSheet createStyleSheet(DOMObject dOMObject, Document document, Node node) {
        Object object = DOMObjectFactory.createStyleSheetObject(dOMObject, document, node);
        if (object != null && object instanceof org.w3c.dom.stylesheets.StyleSheet) {
            return (org.w3c.dom.stylesheets.StyleSheet)object;
        }
        return null;
    }

    public static Object createCSSObject(DOMObject dOMObject, Document document, Node node, org.w3c.dom.css.CSSStyleSheet cSSStyleSheet, CSSRule cSSRule) {
        if (dOMObject == null) {
            return null;
        }
        Class clazz = DOMObjectTypeHelper.getCSSRuleClass(dOMObject);
        if (clazz != null) {
            if (org.w3c.dom.stylesheets.StyleSheet.class.isAssignableFrom(clazz)) {
                return DOMObjectFactory.createStyleSheet(dOMObject, document, node);
            }
            try {
                Class[] classArray = new Class[]{DOMObject.class, Document.class, Node.class, org.w3c.dom.css.CSSStyleSheet.class, CSSRule.class};
                Constructor constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{dOMObject, document, node, cSSStyleSheet, cSSRule};
                return constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new PluginNotSupportedException("DOMObjectFactory::createCSSRuleObject() cannot wrap " + dOMObject);
    }

    private static Class getRealClassByType(DOMObject dOMObject) {
        try {
            Object object = dOMObject.getMember(ATTR_TYPE);
            if (object != null) {
                return (Class)DOMObjectFactory.getElmTypeClassMap().get(object);
            }
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return null;
    }

    private static Class getRealClassByTagName(DOMObject dOMObject) {
        try {
            Object object = dOMObject.getMember(HTML_TAGNAME);
            if (object != null) {
                return (Class)DOMObjectFactory.getElmTagClassMap().get(object);
            }
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return null;
    }

    private static synchronized HashMap getElmTagClassMap() {
        if (elmTagClassMap == null) {
            elmTagClassMap = new HashMap();
            elmTagClassMap.put("A", HTMLAnchorElement.class);
            elmTagClassMap.put("APPLET", HTMLAppletElement.class);
            elmTagClassMap.put("AREA", HTMLAreaElement.class);
            elmTagClassMap.put("BASE", HTMLBaseElement.class);
            elmTagClassMap.put("BLOCKQUOTE", HTMLQuoteElement.class);
            elmTagClassMap.put("BODY", HTMLBodyElement.class);
            elmTagClassMap.put("BR", HTMLBRElement.class);
            elmTagClassMap.put("CAPTION", HTMLTableCaptionElement.class);
            elmTagClassMap.put("COL", HTMLTableColElement.class);
            elmTagClassMap.put("DEL", HTMLModElement.class);
            elmTagClassMap.put("DIR", HTMLDirectoryElement.class);
            elmTagClassMap.put("DIV", HTMLDivElement.class);
            elmTagClassMap.put("DL", HTMLDListElement.class);
            elmTagClassMap.put("FIELDSET", HTMLFieldSetElement.class);
            elmTagClassMap.put("FONT", HTMLFontElement.class);
            elmTagClassMap.put("FORM", HTMLFormElement.class);
            elmTagClassMap.put("FRAME", HTMLFrameElement.class);
            elmTagClassMap.put("FRAMESET", HTMLFrameSetElement.class);
            elmTagClassMap.put("HEAD", HTMLHeadElement.class);
            elmTagClassMap.put("H1", HTMLHeadingElement.class);
            elmTagClassMap.put("H2", HTMLHeadingElement.class);
            elmTagClassMap.put("H3", HTMLHeadingElement.class);
            elmTagClassMap.put("H4", HTMLHeadingElement.class);
            elmTagClassMap.put("H5", HTMLHeadingElement.class);
            elmTagClassMap.put("H6", HTMLHeadingElement.class);
            elmTagClassMap.put("HR", HTMLHRElement.class);
            elmTagClassMap.put("HTML", HTMLHtmlElement.class);
            elmTagClassMap.put("IFRAME", HTMLIFrameElement.class);
            elmTagClassMap.put("IMAGE", HTMLImageElement.class);
            elmTagClassMap.put("INPUT", HTMLInputElement.class);
            elmTagClassMap.put("INS", HTMLModElement.class);
            elmTagClassMap.put("ISINDEX", HTMLIsIndexElement.class);
            elmTagClassMap.put("LABEL", HTMLLabelElement.class);
            elmTagClassMap.put("LEGEND", HTMLLegendElement.class);
            elmTagClassMap.put("LI", HTMLLIElement.class);
            elmTagClassMap.put("LINK", HTMLLinkElement.class);
            elmTagClassMap.put("MAP", HTMLMapElement.class);
            elmTagClassMap.put("MENU", HTMLMenuElement.class);
            elmTagClassMap.put("META", HTMLMetaElement.class);
            elmTagClassMap.put("MOD", HTMLModElement.class);
            elmTagClassMap.put("OBJECT", HTMLObjectElement.class);
            elmTagClassMap.put("OL", HTMLOListElement.class);
            elmTagClassMap.put("OPTGROUP", HTMLOptGroupElement.class);
            elmTagClassMap.put("OPTION", HTMLOptionElement.class);
            elmTagClassMap.put("P", HTMLParagraphElement.class);
            elmTagClassMap.put("PARAM", HTMLParamElement.class);
            elmTagClassMap.put("PRE", HTMLPreElement.class);
            elmTagClassMap.put("Q", HTMLQuoteElement.class);
            elmTagClassMap.put("SCRIPT", HTMLScriptElement.class);
            elmTagClassMap.put("SELECT", HTMLSelectElement.class);
            elmTagClassMap.put("STYLE", HTMLStyleElement.class);
            elmTagClassMap.put("TABLE", HTMLTableElement.class);
            elmTagClassMap.put("TBODY", HTMLTableSectionElement.class);
            elmTagClassMap.put("TD", HTMLTableCellElement.class);
            elmTagClassMap.put("TFOOT", HTMLTableSectionElement.class);
            elmTagClassMap.put("TH", HTMLTableCellElement.class);
            elmTagClassMap.put("THEAD", HTMLTableSectionElement.class);
            elmTagClassMap.put("TR", HTMLTableRowElement.class);
            elmTagClassMap.put("TEXTARRA", HTMLTextAreaElement.class);
            elmTagClassMap.put("TITLE", HTMLTitleElement.class);
            elmTagClassMap.put("UL", HTMLUListElement.class);
        }
        return elmTagClassMap;
    }

    private static synchronized HashMap getElmTypeClassMap() {
        if (elmTypeClassMap == null) {
            elmTypeClassMap = new HashMap();
            elmTypeClassMap.put("text/css", CSSStyleSheet.class);
        }
        return elmTypeClassMap;
    }
}

