/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.javascript;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.plugin.javascript.JSClassLoader;

public class ReflectUtil {
    public static Method[] getJScriptMethods(Class clazz) {
        boolean bl;
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = new HashMap();
        while (clazz != null && !(bl = ReflectUtil.getPublicMethods(clazz, arrayList, hashMap))) {
            ReflectUtil.getJScriptInterfaceMethods(clazz, arrayList, hashMap);
            clazz = clazz.getSuperclass();
        }
        return arrayList.toArray(new Method[arrayList.size()]);
    }

    private static void getJScriptInterfaceMethods(Class clazz, List list, Map map) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz2 = classArray[i];
            boolean bl = ReflectUtil.getPublicMethods(clazz2, list, map);
            if (bl) continue;
            ReflectUtil.getJScriptInterfaceMethods(clazz2, list, map);
        }
    }

    private static boolean getPublicMethods(Class clazz, List list, Map map) {
        Class<?> clazz2;
        int n;
        Method[] methodArray = null;
        try {
            if (!Modifier.isPublic(clazz.getModifiers())) {
                return false;
            }
            if (!JSClassLoader.isPackageAccessible(clazz)) {
                return false;
            }
            methodArray = clazz.getMethods();
        }
        catch (SecurityException securityException) {
            return false;
        }
        boolean bl = true;
        for (n = 0; n < methodArray.length; ++n) {
            clazz2 = methodArray[n].getDeclaringClass();
            if (Modifier.isPublic(clazz2.getModifiers())) continue;
            bl = false;
            break;
        }
        if (map.isEmpty() && !list.isEmpty()) {
            ReflectUtil.initSignatureMap(list, map);
        }
        if (bl) {
            for (n = 0; n < methodArray.length; ++n) {
                ReflectUtil.addMethod(list, map, methodArray[n]);
            }
        } else {
            for (n = 0; n < methodArray.length; ++n) {
                clazz2 = methodArray[n].getDeclaringClass();
                if (!clazz.equals(clazz2)) continue;
                ReflectUtil.addMethod(list, map, methodArray[n]);
            }
        }
        return bl;
    }

    private static void initSignatureMap(List list, Map map) {
        for (Method method : list) {
            map.put(ReflectUtil.getSignature(method), method);
        }
    }

    private static void addMethod(List list, Map map, Method method) {
        if (map.isEmpty()) {
            list.add(method);
            return;
        }
        String string = ReflectUtil.getSignature(method);
        if (!map.containsKey(string)) {
            list.add(method);
            map.put(string, method);
        }
    }

    private static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(method.getName());
        Class<?>[] classArray = method.getParameterTypes();
        stringBuffer.append('(');
        if (classArray.length > 0) {
            stringBuffer.append(classArray[0].getName());
        }
        for (int i = 1; i < classArray.length; ++i) {
            stringBuffer.append(',');
            stringBuffer.append(classArray[i].getName());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static Field[] getJScriptFields(Class clazz) {
        boolean bl;
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = new HashMap();
        while (clazz != null && !(bl = ReflectUtil.getPublicFields(clazz, arrayList, hashMap))) {
            ReflectUtil.getJScriptInterfaceFields(clazz, arrayList, hashMap);
            clazz = clazz.getSuperclass();
        }
        return arrayList.toArray(new Field[arrayList.size()]);
    }

    private static void getJScriptInterfaceFields(Class clazz, List list, Map map) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz2 = classArray[i];
            boolean bl = ReflectUtil.getPublicFields(clazz2, list, map);
            if (bl) continue;
            ReflectUtil.getJScriptInterfaceFields(clazz2, list, map);
        }
    }

    private static boolean getPublicFields(Class clazz, List list, Map map) {
        Class<?> clazz2;
        int n;
        Field[] fieldArray = null;
        try {
            if (!Modifier.isPublic(clazz.getModifiers())) {
                return false;
            }
            if (!JSClassLoader.isPackageAccessible(clazz)) {
                return false;
            }
            fieldArray = clazz.getFields();
        }
        catch (SecurityException securityException) {
            return false;
        }
        boolean bl = true;
        for (n = 0; n < fieldArray.length; ++n) {
            clazz2 = fieldArray[n].getDeclaringClass();
            if (Modifier.isPublic(clazz2.getModifiers())) continue;
            bl = false;
            break;
        }
        if (bl) {
            for (n = 0; n < fieldArray.length; ++n) {
                ReflectUtil.addField(list, map, fieldArray[n]);
            }
        } else {
            for (n = 0; n < fieldArray.length; ++n) {
                clazz2 = fieldArray[n].getDeclaringClass();
                if (!clazz.equals(clazz2)) continue;
                ReflectUtil.addField(list, map, fieldArray[n]);
            }
        }
        return bl;
    }

    private static void addField(List list, Map map, Field field) {
        String string = field.getName();
        if (!map.containsKey(string)) {
            list.add(field);
            map.put(string, field);
        }
    }
}

