#ifndef CONFIG_H
#define CONFIG_H

/*
 * Copyright (c) Abraham vd Merwe <abz@blio.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *	  notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *	  notice, this list of conditions and the following disclaimer in the
 *	  documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of other contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <inttypes.h>
#include <sys/types.h>

typedef struct
{
   char *hostname;			/* hostname / ip-address								*/
   char *service;			/* service / port number								*/
   char *community;			/* community string										*/
   uint32_t timeout;		/* timeout for snmp requests							*/
   uint16_t retries;		/* number of retries									*/
   int ignore_admin_down;	/* ignore administratevely down interfaces				*/
   char **ignore;			/* list of interfaces to ignore							*/
   size_t n_ignore;			/* number of entries in ignore list						*/
   char **order;			/* preferred display order of interfaces				*/
   size_t n_order;			/* number of entries in order list						*/
   char **alias;			/* override interface aliases							*/
   size_t n_alias;			/* number of aliases in alias list						*/
} config_router_t;

typedef struct
{
   char *database;			/* location of RRD databases							*/
   char *htdocs;			/* where web page is created							*/
   char *documentroot;		/* path relative to htdocs which should be used in urls	*/
   char *pidfile;			/* file where pid of daemon is stored					*/
   size_t n;				/* number of entries in router list						*/
   config_router_t *router;	/* router specific settings								*/
   uid_t uid;				/* UID as which process should be executed				*/
   gid_t gid;				/* GID as which process should be executed				*/
} config_t;

/*
 * free all memory allocated by config_parse() for the specified
 * config structure.
 */
extern void config_destroy (config_t *config);

/*
 * parse configuration file. return 0 if successful, -1 if some
 * error occurred. the function automatically logs all errors.
 */
extern int config_parse (config_t *config,const char *filename);

#endif	/* #ifndef CONFIG_H */
