class apache( $sitename = "default", $listenip = $ipaddress, $listenport = "8080", $clustername = $uniqueid, $modules = "none" )
{
  package{ "apache2": alias => "apache", ensure => installed }

  service {"apache2":
    alias => "apache",
    ensure => running,
    enable => true,
    subscribe => [ File["apache_config"], File["site_config"] ],
    hasstatus => true,
    restart => "/etc/init.d/apache2 reload",
  }

  file{"apache_config":
    name => "/etc/apache2/apache2.conf",
    ensure => present,
    require => Package["apache"],
    notify => Service["apache"],
  }

  file{"site_config":
    name => "/etc/apache2/sites-available/${sitename}",
    ensure => present,
    content => template("/etc/puppet/modules/orchestra-apache/templates/default.erb"),
    require => Package["apache"],
    notify => Service["apache"],
  }

  file{"port_config":
    name => "/etc/apache2/conf.d/${sitename}-port-config",
    ensure => present,
    content => template("/etc/puppet/modules/orchestra-apache/templates/port.erb"),
    require => Package["apache"],
    notify => Service["apache"],
  }

  exec{"disable_default_sites":
    command => "rm -f /etc/apache2/sites-enabled/000-default",
    require => [ File["site_config"], File[port_config] ],
    notify => Service["apache"],
  }

  exec{"enable_site_config":
    command => "/usr/sbin/a2ensite ${sitename}",
    require => Exec["disable_default_sites"],
    notify => Service["apache"],
    #unless => "test -e `ls /etc/apache2/sites-enabled/* | grep ${sitename}`"
  }

  exec{"haproxy_clustername_directory":
    command => "mkdir -p /etc/haproxy/${clustername}",
    require => Exec["enable_site_config"],
    unless => "test -d /etc/haproxy/${clustername}",
  }

  @@file{"/etc/haproxy/${clustername}/${sitename}.${uniqueid}.server":
    ensure => present,
    content => template("/etc/puppet/modules/orchestra-apache/templates/haproxy.erb"),
    tag => "loadbalancer_${clustername}",
  }

  # Enable requested modules ( if any )
   case $modules
   {
     /^[n|N][o|O][n|N][e|E]/: {}
     '': {}
     default: { apache::enable_module{ [split($modules, ',')]: } }
   }

}

define apache::enable_module
{
  case $name
  {
    '': {}
    'php': { package{"libapache2-mod-php5": ensure => installed } }
    'python': { package{"libapache2-mod-python": ensure => installed } }
    'perl': { package{"libapache2-mod-perl2": ensure => installed } }
    /[n|N][o|O][n|N][e|E]/: {}
    default: { package{"libapache2-mod-${name}": ensure => installed } }
  }
}