class haproxy( $clustername = $uniqueid, $listenip = $ipaddress, $listenport = "80", $cookiename = "SERVERID" )
{
  package{"haproxy": ensure => present} -> File <<| tag == "loadbalancer_${clustername}" |>>

  service {"haproxy":
    ensure => running,
    enable => true,
    subscribe => [File["haproxy_default"], File["haproxy_config"]],
    hasstatus => true,
    restart   => "/etc/init.d/haproxy reload",
  }

  file {"haproxy_default":
    name    => "/etc/default/haproxy",
    ensure  => present,
    owner   => "root",
    group   => "root",
    mode    => "644",
    require => Package["haproxy"],
  }

  exec{"haproxy_clustername_directory":
    command => "mkdir -p /etc/haproxy/${clustername}",
    require => Package["haproxy"],
    unless => "test -d /etc/haproxy/${clustername}",
  }

  exec{"serverentries_file":
    command => "echo > /etc/haproxy/${clustername}.servers",
    require => Exec["haproxy_clustername_directory"],
    unless => "test -e /etc/haproxy/${clustername}.servers",
  }

  exec{"update_serverentries_config":
    command => "cat /etc/haproxy/${clustername}/*.server > /etc/haproxy/${clustername}/${clustername}.servers",
    require => Exec["serverentries_file"],
    onlyif => "test `find /etc/haproxy/${clustername}/*.server | wc -l` -gt 0",
  }
 
  file {"haproxy_config":
    name    => "/etc/haproxy/haproxy.cfg",
    ensure  => present,
    owner   => "root",
    group   => "root",
    mode    => "644",
    content => template("/etc/puppet/modules/orchestra-haproxy/templates/haproxy.cfg.erb"),
    require => Exec["update_serverentries_config"],
  }

  exec{"update_haproxy_config":
    command => "cat /etc/haproxy/${clustername}/${clustername}.servers >> /etc/haproxy/haproxy.cfg",
    require => File["haproxy_config"],
    notify => Service["haproxy"],
    onlyif => "test -e /etc/haproxy/${clustername}/${clustername}.servers",
  }

  exec{"enable_haproxy":
    command => "sed -i /etc/default/haproxy -e s/ENABLED\=0/ENABLED\=1/",
    require => Package["haproxy"],
    notify => Service["haproxy"],
  }

}