class mysqlebs_base {
    package { "mysql-server-5.1": ensure => installed }
    package { "mysql-client-5.1": ensure => installed }
    service {"mysql":
        ensure => running,
        enable => true,
        hasstatus => true,
        require => Package["mysql-server-5.1"],
    }
    file { clustercnf:
        path    => "/etc/mysql/conf.d/cluster.cnf",
        owner   => root,
        group   => root,
        mode    => 444,
        content => template("/etc/puppet/modules/orchestra-mysqlEBS/templates/cluster.cnf.erb"),
        notify  => Service["mysql"],
    }
    file { utf8cnf:
        path    => "/etc/mysql/conf.d/utf8.cnf",
        owner   => root,
        group   => root,
        mode    => 444,
        content => template("/etc/puppet/modules/orchestra-mysqlEBS/templates/utf8.cnf.erb"),
        notify  => Service["mysql"],
    }


}
