/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.core;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import org.stathissideris.ascii2image.core.ConversionOptions;
import org.stathissideris.ascii2image.graphics.Diagram;
import org.stathissideris.ascii2image.text.StringUtils;
import org.stathissideris.ascii2image.text.TextGrid;

public class Tester {
    private static final String HTMLReportName = "test_suite";

    public static void main(String[] args) {
        Tester tester = new Tester();
        String dir = "d:\\devel\\java\\ascii2image\\";
        String[] filenames = new String[]{String.valueOf(dir) + "logo.txt", String.valueOf(dir) + "color_codes.txt", String.valueOf(dir) + "art2_5.txt", String.valueOf(dir) + "art3.txt", String.valueOf(dir) + "art3_5.txt", String.valueOf(dir) + "art4.txt", String.valueOf(dir) + "art5.txt", String.valueOf(dir) + "art6.txt", String.valueOf(dir) + "art7.txt", String.valueOf(dir) + "art10.txt", String.valueOf(dir) + "art11.txt", String.valueOf(dir) + "art12.txt", String.valueOf(dir) + "art13.txt", String.valueOf(dir) + "art14.txt", String.valueOf(dir) + "art_text.txt", String.valueOf(dir) + "bug1.txt", String.valueOf(dir) + "bug2.txt", String.valueOf(dir) + "bug3.txt", String.valueOf(dir) + "bug4.txt", String.valueOf(dir) + "bug5.txt", String.valueOf(dir) + "bug6.txt", String.valueOf(dir) + "bug7.txt", String.valueOf(dir) + "bug8.txt", String.valueOf(dir) + "bug9.txt", String.valueOf(dir) + "bug9_5.txt", String.valueOf(dir) + "bug10.txt", String.valueOf(dir) + "bug11.txt", String.valueOf(dir) + "bug12.txt", String.valueOf(dir) + "bug13.txt", String.valueOf(dir) + "bug14.txt", String.valueOf(dir) + "bug15.txt"};
        tester.createHTMLTestSuite(filenames, HTMLReportName);
    }

    public boolean createHTMLTestSuite(String[] textFilenames, String reportName) {
        ConversionOptions options = new ConversionOptions();
        String imageDir = String.valueOf(reportName) + "_images";
        String reportFilename = String.valueOf(reportName) + ".html";
        if (!new File(imageDir).exists()) {
            File dir = new File(imageDir);
            dir.mkdir();
        }
        PrintWriter s = null;
        try {
            s = new PrintWriter(new FileWriter(reportFilename));
        }
        catch (IOException e) {
            System.err.println("Cannot open file " + reportFilename + " for writing:");
            e.printStackTrace();
            return false;
        }
        s.println("<html><body>");
        s.println("<h1>ascii2image test suite<h1>");
        s.println("<h2>generated on: " + Calendar.getInstance().getTime() + "<h2>");
        int i = 0;
        while (i < textFilenames.length) {
            block6: {
                String filename = textFilenames[i];
                TextGrid grid = new TextGrid();
                try {
                    grid.loadFrom(filename);
                    Diagram diagram = new Diagram(grid, options);
                    String toFilename = String.valueOf(StringUtils.getPath(filename)) + "\\" + imageDir + "\\";
                    toFilename = String.valueOf(toFilename) + StringUtils.getBaseFilename(filename);
                    toFilename = String.valueOf(toFilename) + ".png";
                }
                catch (Exception e) {
                    s.println("<b>!!! Failed to render: " + filename + " !!!</b>");
                    s.println("<center><pre>\n" + grid.getDebugString() + "\n</pre></center>");
                    s.println(e.getMessage());
                    s.println("<hr />");
                    s.flush();
                    break block6;
                }
                String imageURL = String.valueOf(imageDir) + "/" + StringUtils.getBaseFilename(filename) + ".png";
                s.println(this.makeReportTable(filename, grid, imageURL));
                s.println("<hr />");
                s.flush();
            }
            ++i;
        }
        s.println("</body></html>");
        s.flush();
        s.close();
        return true;
    }

    private String makeReportTable(String gridURI, TextGrid grid, String imageURI) {
        StringBuffer buffer = new StringBuffer("<center><table border=\"0\">");
        buffer.append("<th colspan=\"2\"><h3>" + gridURI + "</h3></th>");
        buffer.append("<tr><td><pre>\n" + grid.getDebugString() + "\n</pre></td>");
        buffer.append("<td><img border=\"0\" src=\"" + imageURI + "\"</td></tr>");
        buffer.append("</table></center>");
        return buffer.toString();
    }
}

