/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import java.awt.Color;
import java.awt.Font;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.stathissideris.ascii2image.core.ConversionOptions;
import org.stathissideris.ascii2image.graphics.BitmapRenderer;
import org.stathissideris.ascii2image.graphics.CompositeDiagramShape;
import org.stathissideris.ascii2image.graphics.DiagramComponent;
import org.stathissideris.ascii2image.graphics.DiagramShape;
import org.stathissideris.ascii2image.graphics.DiagramText;
import org.stathissideris.ascii2image.graphics.FontMeasurer;
import org.stathissideris.ascii2image.graphics.ShapeEdge;
import org.stathissideris.ascii2image.graphics.ShapePoint;
import org.stathissideris.ascii2image.text.AbstractionGrid;
import org.stathissideris.ascii2image.text.CellSet;
import org.stathissideris.ascii2image.text.TextGrid;

public class Diagram {
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE_DEBUG = false;
    private ArrayList shapes = new ArrayList();
    private ArrayList compositeShapes = new ArrayList();
    private ArrayList textObjects = new ArrayList();
    private int width;
    private int height;
    private int cellWidth;
    private int cellHeight;

    public Diagram(TextGrid grid, ConversionOptions options) {
        DiagramComponent shape;
        CellSet set;
        this.cellWidth = options.renderingOptions.getCellWidth();
        this.cellHeight = options.renderingOptions.getCellHeight();
        this.width = grid.getWidth() * this.cellWidth;
        this.height = grid.getHeight() * this.cellHeight;
        TextGrid workGrid = new TextGrid(grid);
        workGrid.replaceTypeOnLine();
        workGrid.replacePointMarkersOnLine();
        int width = grid.getWidth();
        int height = grid.getHeight();
        AbstractionGrid temp = new AbstractionGrid(workGrid, workGrid.getAllBoundaries());
        ArrayList boundarySetsStep1 = temp.getDistinctShapes();
        ArrayList boundarySetsStep2 = new ArrayList();
        Iterator boundarySetIt = ((AbstractList)boundarySetsStep1).iterator();
        while (boundarySetIt.hasNext()) {
            CellSet set2 = (CellSet)boundarySetIt.next();
            TextGrid fillBuffer = new TextGrid(width * 3, height * 3);
            int yi = 0;
            while (yi < height * 3) {
                int xi = 0;
                while (xi < width * 3) {
                    TextGrid copyGrid;
                    CellSet boundaries;
                    if (fillBuffer.isBlank(xi, yi) && (boundaries = (copyGrid = new AbstractionGrid(workGrid, set2).getCopyOfInternalBuffer()).findBoundariesExpandingFrom(new TextGrid.Cell(copyGrid, xi, yi))).size() != 0) {
                        boundarySetsStep2.add(boundaries.makeScaledOneThirdEquivalent());
                        copyGrid = new AbstractionGrid(workGrid, set2).getCopyOfInternalBuffer();
                        CellSet filled = copyGrid.fillContinuousArea(new TextGrid.Cell(copyGrid, xi, yi), '*');
                        fillBuffer.fillCellsWith(filled, '*');
                        fillBuffer.fillCellsWith(boundaries, '-');
                    }
                    ++xi;
                }
                ++yi;
            }
        }
        boundarySetsStep2 = CellSet.removeDuplicateSets(boundarySetsStep2);
        int originalSize = boundarySetsStep2.size();
        boundarySetsStep2 = CellSet.removeDuplicateSets(boundarySetsStep2);
        boolean removedAnyObsolete = this.removeObsoleteShapes(workGrid, boundarySetsStep2);
        ArrayList<CellSet> open = new ArrayList<CellSet>();
        ArrayList<CellSet> closed = new ArrayList<CellSet>();
        ArrayList<CellSet> mixed = new ArrayList<CellSet>();
        Iterator sets = ((AbstractList)boundarySetsStep2).iterator();
        while (sets.hasNext()) {
            CellSet set3 = (CellSet)sets.next();
            int type = set3.getType(workGrid);
            if (type == 0) {
                closed.add(set3);
                continue;
            }
            if (type == 1) {
                open.add(set3);
                continue;
            }
            if (type != 2) continue;
            mixed.add(set3);
        }
        boolean hadToEliminateMixed = false;
        if (mixed.size() > 0 && closed.size() > 0) {
            hadToEliminateMixed = true;
            sets = ((AbstractList)mixed).iterator();
            while (sets.hasNext()) {
                CellSet set4 = (CellSet)sets.next();
                Iterator closedSets = ((AbstractList)closed).iterator();
                while (closedSets.hasNext()) {
                    CellSet closedSet = (CellSet)closedSets.next();
                    set4.subtractSet(closedSet);
                }
                if (set4.getType(workGrid) != 1) continue;
                ((AbstractCollection)boundarySetsStep2).remove(set4);
                boundarySetsStep2.addAll(set4.breakIntoDistinctBoundaries(workGrid));
            }
        } else if (mixed.size() > 0 && closed.size() == 0) {
            hadToEliminateMixed = true;
            sets = ((AbstractList)mixed).iterator();
            while (sets.hasNext()) {
                CellSet set5 = (CellSet)sets.next();
                ((AbstractCollection)boundarySetsStep2).remove(set5);
                boundarySetsStep2.addAll(set5.breakTrulyMixedBoundaries(workGrid));
            }
        }
        if (hadToEliminateMixed) {
            open = new ArrayList();
            closed = new ArrayList();
            mixed = new ArrayList();
            sets = ((AbstractList)boundarySetsStep2).iterator();
            while (sets.hasNext()) {
                CellSet set6 = (CellSet)sets.next();
                int type = set6.getType(workGrid);
                if (type == 0) {
                    closed.add(set6);
                    continue;
                }
                if (type == 1) {
                    open.add(set6);
                    continue;
                }
                if (type != 2) continue;
                mixed.add(set6);
            }
        }
        boolean allCornersRound = false;
        if (options.processingOptions.areAllCornersRound()) {
            allCornersRound = true;
        }
        ArrayList<DiagramComponent> closedShapes = new ArrayList<DiagramComponent>();
        sets = ((AbstractList)closed).iterator();
        while (sets.hasNext()) {
            set = (CellSet)sets.next();
            shape = DiagramComponent.createClosedFromBoundaryCells(workGrid, set, this.cellWidth, this.cellHeight, allCornersRound);
            if (shape == null) continue;
            if (shape instanceof DiagramShape) {
                this.addToShapes((DiagramShape)shape);
                closedShapes.add(shape);
                continue;
            }
            if (!(shape instanceof CompositeDiagramShape)) continue;
            this.addToCompositeShapes((CompositeDiagramShape)shape);
        }
        if (options.processingOptions.performSeparationOfCommonEdges()) {
            this.separateCommonEdges(closedShapes);
        }
        sets = ((AbstractList)open).iterator();
        while (sets.hasNext()) {
            set = (CellSet)sets.next();
            if (set.size() == 1) {
                DiagramShape shape2;
                TextGrid.Cell cell = (TextGrid.Cell)set.get(0);
                if (grid.cellContainsDashedLineChar(cell) || (shape2 = DiagramShape.createSmallLine(workGrid, cell, this.cellWidth, this.cellHeight)) == null) continue;
                this.addToShapes(shape2);
                shape2.connectEndsToAnchors(workGrid, this);
                continue;
            }
            shape = CompositeDiagramShape.createOpenFromBoundaryCells(workGrid, set, this.cellWidth, this.cellHeight, allCornersRound);
            if (shape == null) continue;
            if (shape instanceof CompositeDiagramShape) {
                this.addToCompositeShapes((CompositeDiagramShape)shape);
                ((CompositeDiagramShape)shape).connectEndsToAnchors(workGrid, this);
                continue;
            }
            if (!(shape instanceof DiagramShape)) continue;
            this.addToShapes((DiagramShape)shape);
            ((DiagramShape)shape).connectEndsToAnchors(workGrid, this);
            ((DiagramShape)shape).moveEndsToCellEdges(grid, this);
        }
        Iterator cellColorPairs = ((AbstractList)grid.findColorCodes()).iterator();
        while (cellColorPairs.hasNext()) {
            TextGrid.CellColorPair pair = (TextGrid.CellColorPair)cellColorPairs.next();
            ShapePoint point = new ShapePoint(this.getCellMidX(pair.cell), this.getCellMidY(pair.cell));
            Iterator shapes = ((AbstractList)this.getShapes()).iterator();
            while (shapes.hasNext()) {
                DiagramShape shape3 = (DiagramShape)shapes.next();
                if (!shape3.contains(point)) continue;
                shape3.setFillColor(pair.color);
            }
        }
        Iterator cellTagPairs = ((AbstractList)grid.findMarkupTags()).iterator();
        while (cellTagPairs.hasNext()) {
            TextGrid.CellTagPair pair = (TextGrid.CellTagPair)cellTagPairs.next();
            ShapePoint point = new ShapePoint(this.getCellMidX(pair.cell), this.getCellMidY(pair.cell));
            Iterator shapes = ((AbstractList)this.getShapes()).iterator();
            while (shapes.hasNext()) {
                DiagramShape shape4 = (DiagramShape)shapes.next();
                if (!shape4.contains(point)) continue;
                if (pair.tag == 0) {
                    shape4.setType(3);
                    continue;
                }
                if (pair.tag == 1) {
                    shape4.setType(4);
                    continue;
                }
                if (pair.tag != 2) continue;
                shape4.setType(5);
            }
        }
        Iterator arrowheadCells = ((AbstractList)workGrid.findArrowheads()).iterator();
        while (arrowheadCells.hasNext()) {
            TextGrid.Cell cell = (TextGrid.Cell)arrowheadCells.next();
            DiagramShape arrowhead = DiagramShape.createArrowhead(workGrid, cell, this.cellWidth, this.cellHeight);
            if (arrowhead != null) {
                this.addToShapes(arrowhead);
                continue;
            }
            System.err.println("Could not create arrowhead shape. Unexpected error.");
        }
        Iterator markersIt = ((AbstractList)grid.getPointMarkersOnLine()).iterator();
        while (markersIt.hasNext()) {
            TextGrid.Cell cell = (TextGrid.Cell)markersIt.next();
            DiagramShape mark = new DiagramShape();
            mark.addToPoints(new ShapePoint(this.getCellMidX(cell), this.getCellMidY(cell)));
            mark.setType(2);
            mark.setFillColor(Color.white);
            this.shapes.add(mark);
        }
        this.removeDuplicateShapes();
        workGrid = new TextGrid(grid);
        workGrid.removeNonText();
        TextGrid textGroupGrid = new TextGrid(workGrid);
        CellSet gaps = textGroupGrid.getAllBlanksBetweenCharacters();
        textGroupGrid.fillCellsWith(gaps, '|');
        CellSet nonBlank = textGroupGrid.getAllNonBlank();
        ArrayList textGroups = nonBlank.breakIntoDistinctBoundaries();
        Font font = FontMeasurer.instance().getFontFor(this.cellHeight);
        Iterator textGroupIt = ((AbstractList)textGroups).iterator();
        while (textGroupIt.hasNext()) {
            CellSet textGroupCellSet = (CellSet)textGroupIt.next();
            TextGrid isolationGrid = new TextGrid(width, height);
            workGrid.copyCellsTo(textGroupCellSet, isolationGrid);
            ArrayList strings = isolationGrid.findStrings();
            Iterator it = ((AbstractList)strings).iterator();
            while (it.hasNext()) {
                DiagramText textObject;
                TextGrid.CellStringPair pair = (TextGrid.CellStringPair)it.next();
                TextGrid.Cell cell = pair.cell;
                String string = pair.string;
                TextGrid.Cell lastCell = new TextGrid.Cell(isolationGrid, cell.x + string.length() - 1, cell.y);
                int minX = this.getCellMinX(cell);
                int y = this.getCellMaxY(cell);
                int maxX = this.getCellMaxX(lastCell);
                if (FontMeasurer.instance().getWidthFor(string, font) > maxX - minX) {
                    Font lessWideFont = FontMeasurer.instance().getFontFor(maxX - minX, string);
                    textObject = new DiagramText(minX, y, string, lessWideFont);
                } else {
                    textObject = new DiagramText(minX, y, string, font);
                }
                textObject.centerVerticallyBetween(this.getCellMinY(cell), this.getCellMaxY(cell));
                int otherStart = isolationGrid.otherStringsStartInTheSameColumn(cell);
                int otherEnd = isolationGrid.otherStringsEndInTheSameColumn(lastCell);
                if (otherStart == 0 && otherEnd == 0) {
                    textObject.centerHorizontallyBetween(minX, maxX);
                } else if (otherEnd > 0 && otherStart == 0) {
                    textObject.alignRightEdgeTo(maxX);
                } else if (otherEnd > 0 && otherStart > 0) {
                    if (otherEnd > otherStart) {
                        textObject.alignRightEdgeTo(maxX);
                    } else if (otherEnd == otherStart) {
                        textObject.centerHorizontallyBetween(minX, maxX);
                    }
                }
                this.addToTextObjects(textObject);
            }
        }
        Iterator shapes = ((AbstractList)this.getAllDiagramShapes()).iterator();
        while (shapes.hasNext()) {
            DiagramShape shape5 = (DiagramShape)shapes.next();
            Color fillColor = shape5.getFillColor();
            if (!shape5.isClosed() || shape5.getType() == 1 || fillColor == null || !BitmapRenderer.isColorDark(fillColor)) continue;
            Iterator textObjects = ((AbstractList)this.getTextObjects()).iterator();
            while (textObjects.hasNext()) {
                DiagramText textObject = (DiagramText)textObjects.next();
                if (!shape5.intersects(textObject.getBounds())) continue;
                textObject.setColor(Color.white);
            }
        }
    }

    public ArrayList getAllDiagramShapes() {
        ArrayList shapes = new ArrayList();
        shapes.addAll(this.getShapes());
        Iterator shapesIt = ((AbstractList)this.getCompositeShapes()).iterator();
        while (shapesIt.hasNext()) {
            CompositeDiagramShape compShape = (CompositeDiagramShape)shapesIt.next();
            shapes.addAll(compShape.getShapes());
        }
        return shapes;
    }

    private boolean removeObsoleteShapes(TextGrid grid, ArrayList sets) {
        boolean removedAny = false;
        ArrayList<CellSet> filledSets = new ArrayList<CellSet>();
        Iterator it = ((AbstractList)sets).iterator();
        while (it.hasNext()) {
            CellSet set = (CellSet)it.next();
            if ((set = set.getFilledEquivalent(grid)) == null) {
                return false;
            }
            filledSets.add(set);
        }
        ArrayList<Integer> toBeRemovedIndices = new ArrayList<Integer>();
        it = ((AbstractList)filledSets).iterator();
        while (it.hasNext()) {
            CellSet set = (CellSet)it.next();
            ArrayList<CellSet> common = new ArrayList<CellSet>();
            common.add(set);
            Iterator it2 = ((AbstractList)filledSets).iterator();
            while (it2.hasNext()) {
                CellSet set2 = (CellSet)it2.next();
                if (set == set2 || !set.hasCommonCells(set2)) continue;
                common.add(set2);
            }
            if (common.size() == 2) continue;
            CellSet largest = set;
            it2 = ((AbstractList)common).iterator();
            while (it2.hasNext()) {
                CellSet set2 = (CellSet)it2.next();
                if (set2.size() <= largest.size()) continue;
                largest = set2;
            }
            ((AbstractCollection)common).remove(largest);
            TextGrid gridOfSmalls = new TextGrid(largest.getMaxX() + 2, largest.getMaxY() + 2);
            CellSet sumOfSmall = new CellSet();
            it2 = ((AbstractList)common).iterator();
            while (it2.hasNext()) {
                CellSet set2 = (CellSet)it2.next();
                gridOfSmalls.fillCellsWith(set2, '*');
            }
            TextGrid gridLargest = new TextGrid(largest.getMaxX() + 2, largest.getMaxY() + 2);
            gridLargest.fillCellsWith(largest, '*');
            int index = filledSets.indexOf(largest);
            if (!gridLargest.equals(gridOfSmalls) || toBeRemovedIndices.contains(new Integer(index))) continue;
            toBeRemovedIndices.add(new Integer(index));
        }
        ArrayList setsToBeRemoved = new ArrayList();
        it = ((AbstractList)toBeRemovedIndices).iterator();
        while (it.hasNext()) {
            int i = (Integer)it.next();
            setsToBeRemoved.add(sets.get(i));
        }
        it = ((AbstractList)setsToBeRemoved).iterator();
        while (it.hasNext()) {
            CellSet set = (CellSet)it.next();
            removedAny = true;
            ((AbstractCollection)sets).remove(set);
        }
        return removedAny;
    }

    public float getMinimumOfCellDimension() {
        return Math.min(this.getCellWidth(), this.getCellHeight());
    }

    private void separateCommonEdges(ArrayList shapes) {
        float offset = this.getMinimumOfCellDimension() / 5.0f;
        ArrayList edges = new ArrayList();
        Iterator it = ((AbstractList)shapes).iterator();
        while (it.hasNext()) {
            DiagramShape shape = (DiagramShape)it.next();
            edges.addAll(shape.getEdges());
        }
        ArrayList listOfGroups = new ArrayList();
        it = ((AbstractList)edges).iterator();
        while (it.hasNext()) {
            ArrayList<ShapeEdge> group;
            ShapeEdge edge = (ShapeEdge)it.next();
            boolean putEdgeIntoExistingGroup = false;
            Iterator it2 = ((AbstractList)listOfGroups).iterator();
            while (it2.hasNext()) {
                group = (ArrayList<ShapeEdge>)it2.next();
                ShapeEdge firstEdge = (ShapeEdge)group.get(0);
                if (!edge.equals(firstEdge)) continue;
                group.add(edge);
                putEdgeIntoExistingGroup = true;
            }
            if (putEdgeIntoExistingGroup) continue;
            group = new ArrayList<ShapeEdge>();
            group.add(edge);
            listOfGroups.add(group);
        }
        it = ((AbstractList)listOfGroups).iterator();
        while (it.hasNext()) {
            ArrayList group = (ArrayList)it.next();
            if (group.size() == 1) continue;
            Iterator it2 = ((AbstractList)group).iterator();
            while (it2.hasNext()) {
                ShapeEdge edge = (ShapeEdge)it2.next();
                edge.moveInwardsBy(offset);
            }
        }
    }

    private void removeDuplicateShapes() {
        ArrayList<DiagramShape> originalShapes = new ArrayList<DiagramShape>();
        Iterator shapesIt = this.getShapesIterator();
        while (shapesIt.hasNext()) {
            DiagramShape shape = (DiagramShape)shapesIt.next();
            boolean isOriginal = true;
            Iterator originals = ((AbstractList)originalShapes).iterator();
            while (originals.hasNext()) {
                DiagramShape originalShape = (DiagramShape)originals.next();
                if (!shape.equals(originalShape)) continue;
                isOriginal = false;
            }
            if (!isOriginal) continue;
            originalShapes.add(shape);
        }
        this.shapes.clear();
        this.shapes.addAll(originalShapes);
    }

    private void addToTextObjects(DiagramText shape) {
        this.textObjects.add(shape);
    }

    private void addToCompositeShapes(CompositeDiagramShape shape) {
        this.compositeShapes.add(shape);
    }

    private void addToShapes(DiagramShape shape) {
        this.shapes.add(shape);
    }

    public Iterator getShapesIterator() {
        return ((AbstractList)this.shapes).iterator();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public ArrayList getCompositeShapes() {
        return this.compositeShapes;
    }

    public ArrayList getShapes() {
        return this.shapes;
    }

    public int getCellMinX(TextGrid.Cell cell) {
        return Diagram.getCellMinX(cell, this.cellWidth);
    }

    public static int getCellMinX(TextGrid.Cell cell, int cellXSize) {
        return cell.x * cellXSize;
    }

    public int getCellMidX(TextGrid.Cell cell) {
        return Diagram.getCellMidX(cell, this.cellWidth);
    }

    public static int getCellMidX(TextGrid.Cell cell, int cellXSize) {
        return cell.x * cellXSize + cellXSize / 2;
    }

    public int getCellMaxX(TextGrid.Cell cell) {
        return Diagram.getCellMaxX(cell, this.cellWidth);
    }

    public static int getCellMaxX(TextGrid.Cell cell, int cellXSize) {
        return cell.x * cellXSize + cellXSize;
    }

    public int getCellMinY(TextGrid.Cell cell) {
        return Diagram.getCellMinY(cell, this.cellHeight);
    }

    public static int getCellMinY(TextGrid.Cell cell, int cellYSize) {
        return cell.y * cellYSize;
    }

    public int getCellMidY(TextGrid.Cell cell) {
        return Diagram.getCellMidY(cell, this.cellHeight);
    }

    public static int getCellMidY(TextGrid.Cell cell, int cellYSize) {
        return cell.y * cellYSize + cellYSize / 2;
    }

    public int getCellMaxY(TextGrid.Cell cell) {
        return Diagram.getCellMaxY(cell, this.cellHeight);
    }

    public static int getCellMaxY(TextGrid.Cell cell, int cellYSize) {
        return cell.y * cellYSize + cellYSize;
    }

    public TextGrid.Cell getCellFor(ShapePoint point) {
        if (point == null) {
            throw new IllegalArgumentException("ShapePoint cannot be null");
        }
        TextGrid g = new TextGrid();
        return new TextGrid.Cell(g, (int)point.x / this.cellWidth, (int)point.y / this.cellHeight);
    }

    public ArrayList getTextObjects() {
        return this.textObjects;
    }
}

