"""Solves a Qubo program using the CP-SAT solver."""


import time

from ortools.sat.python import cp_model

RAW_DATA = [[
    0, 0, 49.774821, -59.5968886, -46.0773896, 0, -65.166109, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 47.0957778, 15.259961, -98.7983264, 0, 0, 0, -20.7757184, 0,
    87.2645672, 0, -22.7888772, 0, 0, 0, -40.4980904, -19.7307486, -23.222078,
    0, -77.5263128, 0, 0, 56.6204008, 0, 0, 0, 0, 0, 0, 0, 31.378421, 0,
    97.3441448, 35.1309806, 0, 0, -40.5727886, -50.7308566, 0, 0, -69.9304568,
    0, 38.5385914, 0, -22.1243232, 0, 0, 0, 0, -62.5102538, 8.0801276,
    46.7998066, -2.3292106, 0, 0, 0, 8.774031, 0, 0, -65.6505736
], [
    -67.2935466, -64.4354852, -96.6712204, 0, 0, -60.7812272, 0, 0, 0, 0, 0,
    -7.9966864, 0, 0, 0, 0, 0, 0, 0, 89.7672338, 0, 0, 0, 0, 98.9607046, 0,
    28.6714432, 0, 0, 0, -26.2738856, 0, 0, 68.363956, 0, 0, 0, 0, 54.7406868,
    0, 0, 0, 0, 94.2320734, 0, 0, 0, 0, 0, 0, 0, 0, -2.9647794, 39.7161716,
    -54.7931288, 0, 0, 0, 0, -47.2284892, 0, 0, 0, -8.6421808, -35.399612, 0, 0,
    62.1912668, 0, -6.8930716, 0, 0, -17.0801284, 0, 0, 68.6533416
], [
    0, 0, 0, 81.165396, 83.773254, 0, -25.1603, 0, 0, 50.225725, 0, -3.8242274,
    0, 0, 36.2078566, 0, 0, 0, 0, 0, 0, 0, 0, 15.551432, 0, 0, -33.6446236, 0,
    0, 0, 36.6171324, 0, 0, 0, 0, 67.9591934, 0, 22.1428016, 0, -27.2961928, 0,
    0, 0, -97.4961564, 90.4062526, 0, 0, 0, -90.0532814, 0, 98.8332924, 0, 0,
    -13.8994926, 0, 17.1962884, 0, 0, 0, -55.1654678, 0, 0, 0, 85.829554, 0,
    -37.971164, 64.233136, -17.9943296, 0, 0, 0, 0, -67.7509796, 0, 0,
    10.0750712
], [
    0, 37.2783148, 0, 0, 0, 36.4959506, 0, 0, 0, 0, 0, 0, 61.201323, 0,
    14.4328522, 48.4078064, 0, 0, 0, 0, 0, 0, 0, -47.0969056, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 26.720439, 0, 0, 62.1987576, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, -65.2085246, 0, 0, 0, 0, 0, 0, 73.3019432, -14.3431238, 0, 0, 0, 0, 0, 0,
    0, 0, 2.1565846, 0, 0, 0.7733644, 0, 5.9090456, 0, -39.7724192
], [
    0, 0, 0, 0, -24.4555532, 0, 0, -5.5484574, 0, 25.4685054, 0.7906104,
    4.273133, 0, 52.12973, 0, -12.8040828, 0, 0, 81.888381, 64.0713498, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 62.9088768, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20.869713,
    0, 0, -71.5835872, 0, 0, 80.7237808, 0, 0, 0, 0, -60.1883708, 0, 0, 0, 0, 0,
    0, 0, 0, 85.0393326, 23.6045316, -18.8849834, 0, 0, 0, -90.8065188,
    -9.5037982, 14.3196654, 0, -28.9290306, 0, 0, -41.5575766
], [
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -8.9478934, 0,
    -83.6040618, 0, 0, 0, 0, -14.3874822, 77.2528714, 0, 0, 99.2966066, 0,
    21.7889114, -37.7629282, 0, -11.6026582, 0, 0, 0, 0, 74.422603, 0, 0,
    -79.239245, -31.9686324, 0, 0, 0, 0, 0, 0, -29.8797178, 0, 0, 85.2723062, 0,
    0, -8.8031188, 0, 0, -20.043565, 0, 0, -70.733454, 0, -94.7231762,
    -85.4584516, 0, 0, 0, 0, -27.6068624, 0, -79.787783, 0, 0, -55.1894266
], [
    1.9374354, 0, 1.4807184, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    61.298952, 0, 0, 0, -90.5702054, 0, 67.381115, 0, -68.684637, 0, 0, 0, 0, 0,
    0, 0, 0, 93.7807934, 0, 8.8213302, -15.9020466, 0, 0, 0, 0, 23.8157662, 0,
    0, 0, 0, 0, 0, 0, 67.3461972, 0, 0, 0, 0, 0, 43.3263744, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 87.7149706, 0, 0, 0, -18.5133574, -30.0338992
], [
    6.3937798, 78.7697644, 28.4485838, 0, 0, 0.1352466, 0, 0, 74.5767122,
    -13.8340168, 0, 0, 0, 77.2929426, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17.9243834,
    0, 0, 82.2239878, 0, 0, 0, 0, 64.3440016, 90.109577, 46.8926522, -2.4494366,
    0, 84.7413412, 0, 0, -4.216108, 0, 0, -79.8684776, 0, 0, 74.8706758,
    -64.4518992, 0, 0, 0, 0, -34.4895004, 0, 0, 0, -74.1158858, -37.7803516, 0,
    0, 0, 0, 0, 80.0054296, 0, 0, 0, 0, 0, 0, 0, 0, -84.5832026, 0, 0,
    71.2540694
], [
    0, 0, 0, 0, -74.9257454, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    14.9675444, 0, 0, 0, 0, 0, -27.5236912, 0, 0, -80.4993438, 0, -81.8494538,
    0, 0, 0, 0, 0, -18.6802002, 0, 0, 0, 0, 0, 0, 0, 61.4131076, 0, 0,
    -55.1421034, 0, 0, -18.576761, 72.3500914, 0, 0, 0, 0, 0, 0, -23.6460116,
    43.1258024, 0, 93.701872, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86.5772554
], [
    0, 0, 93.0762916, 0, 0, 0, 0, 0, 0, 0, -37.2663938, 86.8303764, 0, 0, 0,
    -51.9596226, 0, 35.6722618, -91.438259, 0, 0, -70.6277108, 0, -82.9146992,
    58.0327648, 0, 0, 0, 0, 0, 0, 0, 0, 13.3727302, 0, 0, 0, 23.5719942, 0,
    -21.5445476, 74.1541634, 60.6365036, 97.4447708, 0, 0, 0, 0, 82.5869498, 0,
    85.1132108, 0, 0, 0, 0, 0, 0, 97.4012534, 0, 0, 0, 0, -45.1504048,
    1.0619934, 59.7140264, 0, 0, 0, 0, 0, 4.177461, 0, 0, 0, -75.7039276, 0,
    0.0421338
], [
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -71.171869, 0, 0, 8.685266, 0, 0, 0, 0,
    33.9089574, 0, -31.6154498, 0, 0, 0, 0, 0, 5.3182746, 0, 0, 0, 0, 0, 0,
    3.0361166, -10.364305, 0, 0, 0, 0, 0, 0, 0, 0, -83.9738444, 0, 0,
    -7.9170212, 0, 0, 0, -28.7575682, 0, 0, 0, -29.9216686, 0, 0, 83.4050918,
    -39.5247364, -6.7028846, 0, 0, 0, -23.6080482, 0, 0, 0, 0, 0, 0, -18.380154,
    46.9252306, 0, 0, 26.1618372, 99.6235254
], [
    0, 0, 0, 0, 0, 0, 0, 52.008307, 0, 0, 0, 0, 0, 92.4974102, -76.3015714, 0,
    0, 0, 0, 0, 0, 0, -56.4879132, 0, 0, 0, 50.1473938, 0, 0, 0, 0, 0, 0, 0, 0,
    40.2219566, 0, 0, 0, 84.5162074, 0, 0, 0, -73.3030606, 0, -10.9258316, 0, 0,
    0, 0, 97.5496436, -70.5026182, 0, 62.3611696, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 96.4362226, 0, 0, 0, 0, 0, 0, 0, -6.0104764, 15.7466756
], [
    -38.7678174, 0, 0, 0, 0, 10.5238486, 0, 0, 0, 31.6876676, 79.6111978, 0, 0,
    0, 0, 45.7314046, 0, 0, 0, -10.0125122, 0, 93.3170242, -96.4566224,
    -5.853298, 0, -82.2848728, 0, 0, 0, 0, 0, 0, 0, 43.3427638, 24.6186934, 0,
    44.859548, 0, -63.8196424, 0, 32.6630616, 41.48423, 0, -42.9613722, 0, 0,
    -68.8954844, 0, 0, 0, 0, 0, 0, 0, 0, 27.7424034, -33.4867534, -49.1827758,
    0, 18.7014116, 0, 0, 59.049662, 0, 0, 0, 0, 0, 0, -29.6305028, 0, 0, 0, 0,
    0, 98.2266078
], [
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -14.6583468, 0, -74.4490466, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -94.9604028, 0, 0, -48.28403, -41.3534342, 0, 0, 0, 62.9532972, 0,
    0, 4.030284, 0, -60.478996, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, -46.5887848, 39.4565458, 0, 0, 0, 0, 0, 0, 0, -48.5071236, 0, 0, 0,
    41.8640204, 0, 0, 0, 74.271524, 0, 15.5769242, 0, -61.4793904, 52.4500934
], [
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50.8387116, 0, 46.490051, 0, -54.9751352, 0,
    43.0696416, 0, 0, 0, 0, 80.5337704, 0, 0, -16.0325234, 0, 0, 0, 0, 0, 0, 0,
    0, 63.186351, 0, 0, 0, 0, 0, 75.2218604, -27.3783446, 0, 0, 0, 0,
    -85.021934, 60.9043202, 55.7344594, 0, 41.1687556, 0, 5.574124, 0, 0,
    -5.0028254, -40.2614834, 0, 0, 0, 0, 0, 0, 22.207679, 0, 0, 0, 0, 0,
    65.0504204, 0, -61.4580018, -90.137276, 19.2277196, 0, 0, -73.8615034
], [
    0, 0, 0, 0, 0, -21.3303052, -75.4586018, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 84.6730538, -3.4478344, 0, -76.083503, 19.9372656,
    -38.9938322, 0, 0, 36.0135034, 0, -56.8457144, 0, 0, 63.4198336, 0, 0, 0, 0,
    0, -63.4419798, 28.5629988, 0, 0, 0, 0, 38.8001126, 0, 0, 47.2148438, 0,
    -19.256673, -24.8778354, -47.8193252, 0, 0, -38.7279908, 0, 0, 0,
    -34.5546658, 0, -96.7675822, 0, 0, 0, 0, 0, 0, 0, 0, 27.9437518
], [
    0, -17.8703906, 0, 0, -47.2114204, 0, -73.3595682, 66.668341, 0, 0, 0, 0,
    30.250278, 0, -40.452007, 0, 0, 0, 0, 0, -37.5013244, 34.3045856, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12.898457, -15.2838318, 0, 0,
    0, 0, 0, 16.333021, 0, 72.0452526, 0, 2.285458, 0, 0, 0, 0, -17.8073046, 0,
    0, 0, 81.7271146, 0, 0, -17.7174538, 0, -62.6694996, 8.7298318, 0, 0, 0, 0,
    0, 0, -27.1131974, 0, -68.0964272
], [
    0, 0, 0, 0, -22.1791216, 16.588597, -19.4545486, 0, -74.8318248,
    -74.4252462, 0, 0, 0, -46.1656546, 0, 0, -21.1620788, 0, -25.6883764, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 34.5550634, 0, 0, 0, 0, 93.8894398, 0, -30.961635, 0,
    0, 0, 0, 0, 78.594791, 0, 0, -63.3427616, 52.6543374, 0, 0, 38.4578962, 0,
    0, -56.5589394, 0, 0, 0.6873802, 0, -83.496155, 0, 0, 0, 13.0737006, 0,
    -41.7343216, 71.8170636, 69.0276666, 0, 0, 57.722026, 0, 0, -93.1746526, 0,
    0, 0, 0, -49.9838934
], [
    0, 4.2310134, -77.9001854, -57.1049418, 0, 53.3411444, 0, 0, 62.3456148, 0,
    0, 68.2636062, 0, 0, -97.5234598, 0, 87.5610236, 0, 0, 0, 0, -77.3855948, 0,
    0, -90.724008, 28.2231562, 0, 53.026918, 0, 0, 0, -76.15995, 0, 0, 0,
    15.413813, 0, 0, 0, 0, 0, 0, 0, 0, 13.0272308, 0, 0, -23.9738128,
    38.7553414, 0, 30.9290494, -35.5982432, 0, 0, 0, -45.1103148, 0, 0, 0,
    70.158022, 0, 0, 0, 0, 0, 54.120183, 0, 0, 0, -41.9285314, 0, 0, 0, 0,
    14.1035676, 33.7857218
], [
    0, 0, 0, 0, 0, 0, 0, 0, 63.3716696, 0, 0, 0, 0, 0, 24.0919054, 0, 0, 0, 0,
    0, 0, 0, 0, 11.3748388, 0, 0, 95.3405052, 93.4694228, 0, 0, -45.255791, 0,
    0, 0, 0, 0, 0, 0, 0, -1.0475536, 60.84603, 0, 0, -10.47761, 0, 26.1100158,
    -51.9159084, 0, 0, 0, 0, 0, 0, -65.6123578, 0, -91.0146766, 0, 0, 0, 0, 0,
    0, 0, -21.2845524, 0, 35.7297864, 0, 0, 0, 0, 0, 0, 15.911098, 0, 0,
    -12.9287238
], [
    0, 0, 4.6786386, 0, 0, 1.6495644, 0, 0, 0, 26.96434, 0, 0, 0, 58.7515752, 0,
    0, 0, -47.6494254, 0, -54.2669514, 72.894442, 0, 0, 95.889445, 0,
    68.8888298, -66.11831, 0, -23.7891422, 79.7630012, 0, 0, 0, -63.9280642, 0,
    0, 0, 0, -32.1729936, 0, 0, -44.1408756, 0, 0, 0, 0, -43.6440432, 0, 0, 0,
    0, 0, 0, 0, 0, 9.0521906, 0, 0, -26.1975436, 0, 45.9278082, 0, 0, 29.678958,
    0, 0, 0, 0, 0, 5.9131246, -82.314248, 0, -56.8775976, -43.6011182, 0,
    -28.0599468
], [
    44.0699428, 0, -0.2569744, 0, 0, 0, 10.53932, 0, -89.8739242, 0, 0, 0, 0,
    -39.5334882, -60.036911, 96.86551, 0, -59.6306248, 0, 76.9520134, 0, 0, 0,
    0, 0, 55.2369732, 0, 0, 0, 0, -41.8466046, 0, 0, -5.291202, 0, -18.5051634,
    0, 0, 0, 0, 0, 47.1813778, 92.5194464, 90.690835, 56.7657076, 0, 0, 0,
    -42.1944794, 0, 0, 0, -69.1124266, 0, 0, 0, 0, 0, 0, 0, -14.4018142,
    -36.9699736, 0, 0, 0, 0, 0, 0, 41.4981516, -1.5870996, 0, -73.7309526,
    -68.2179518, 0, 5.1895272, -29.7117264
], [
    90.3158852, 54.7711894, 0, 0, 0, 0, 0, 0, 0, -92.2564004, -20.8178774, 0,
    17.3192726, 0, 2.5685474, 0, 0, 0, 0, -21.96248, 0, -83.8507778, 0, 0, 0, 0,
    -81.769375, 0, 0, 0, -73.8973162, 0, 0, 0, 0, 0, 0, -96.8790628, 0,
    -29.2883476, 0, 0, -73.2399312, 0, 0, 0, 56.465223, 0, -10.1549238, 0, 0,
    44.7135732, 0, 0, 0, 0, -37.8912668, 61.0703958, 0, 0, 0, 94.563183,
    2.1777518, 0, 0, 0, 0, 0, 0, 69.8987148, 0, 0, 0, 58.5987754, 0, -73.701682
], [
    0, 25.7383596, 0, 43.2784374, 0, 0, 0, 0, 0, 0, 0, 65.3498334, 0,
    -51.6680898, 0, 0, 0, -32.4960916, 0, -61.8512302, 0, 0, 0, 0, 66.0087116,
    0, 0, 0, 0, 0, -69.5971312, -68.5339006, 0, -87.9115714, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 13.6412636, 0, -33.3575526, 0, -34.6876284, 0, 0, 0, 0,
    0, -5.195929, 0, 0, 0, 0, 0, 0, -62.551799, 0, 0, 0, 0, 0, 0, 0, 0,
    -85.6796076, 0, -69.9796424
], [
    0, -67.7487338, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -89.686036, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35.3396338, -51.2668318, 0, 0,
    -9.4925338, 0, 0, 0, 0, 0, 0, 0, 0, -74.049299, 0, 0, 0, 6.669526, 0, 0, 0,
    0, 82.3839076, 0, 0, 0, -63.2986138, 0, 0, 0, 29.4639612, 0, 0, -75.2754458,
    0, 0, 10.6058324, 83.9439366, 48.4539264, 0, 0, 0, 0, 8.6922024, 17.82273
], [
    -12.5659444, 0, 0, 0, 0, 0, -16.0039068, 0, 0, 0, 0, -64.5579896, 0,
    25.3425712, 0, 0, 0, 0, -73.3525686, 0, 0, 0, 41.4534476, 0, 0, 35.6355928,
    82.0438356, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16.5500598, 0, 17.4573382,
    -30.4230828, 68.6250598, 0, 0, -70.7101786, 0, 0, 0, 0, 0, 19.070679, 0, 0,
    0, 0, 0, 0, 0, -69.0034118, 0, -32.8881618, 0, 99.6116696, -41.8557658,
    -36.91302, 0, 0, 0, 0, 0, 25.1313946, 0, 0, 0, 0, 0, 66.1785624
], [
    -28.5551034, -60.2641954, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11.4765054, 0, 0, 0, 0,
    0, 0, 78.1818898, 0, 0, 0, 0, 34.0574966, 0, 0, 0, 3.3327304, 0, 0, 0, 0, 0,
    0, 0, -25.4031686, -6.4345882, 0, 0, 0, 0, 0, 70.724926, 0, 0, 0, 0, 0, 0,
    -34.578727, 0, 0, 0, 0, 73.4821434, 0, 0, 0, 0, -78.7097278, 0, 0, 0,
    -56.0390914, -77.1810362, 95.2972308, 0, -88.304829, 0, -11.4076234, 0, 0,
    0, 0, 0, -53.8368524
], [
    0, 0, 53.7291982, 0, 0, 0, 0, 0, 0, 0, 0, 90.7870612, -66.2974882, 0,
    -92.2201462, -15.7252186, 0, 0, 0, 0, 0, -25.4072904, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 32.8926792, 36.9923848, 0, 0, 0, 0, 33.293754, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 5.689557, 0, 0, 89.5416534, 40.4300196, 0, 0, 2.8394972,
    90.7550328, 0, 0, 71.835872, 30.8157976, -96.7796296, 0, 44.1461388, 0, 0,
    -32.5545222, 0, 75.597677, 0, 0, 0, 0, 33.146892
], [
    0, -36.157067, 0, 0, -0.4087578, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13.1871604, 0,
    60.6086354, 84.4235272, 0, 0, 89.0383032, 0, 0, 0, -43.0195992, 0,
    -99.31608, 0, -64.2154682, 0, 0, 0, 76.5304532, 0, 0, 0, 0, 0, 82.052369, 0,
    -72.450166, 0, 0, 0, 23.4129134, 0, 0, 0, 0, 0, 0, 0, 0, 53.3291088, 0, 0,
    0, 73.435697, 87.3597806, 0, -94.1974698, 0, 0, 0, 0, 59.0496292, 0, 0, 0,
    -13.8506028, 0, 0, -42.6003178, 0, 0, 55.1715212
], [
    0, 0, 0, -67.8709314, 0, 0, 0, 0, 0, 0, 0, -9.678326, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -28.014314, 0, 0, 0, 0,
    0, 0, 0, 0, -36.8865788, 0, 0, -98.739389, 0, 0, 0, 0, 0, 0, -86.2168946, 0,
    44.1228816, 0, 0, 0, 0, 0, 0, -36.6609072, 0, 0, 0, 0, 18.3461886,
    98.9990466, 30.4109678, 0, 0, 0, -39.2683046
], [
    -49.3558704, 0, 0, -31.3665258, 0, 0, 0, 0, 0, 0, 1.7897898, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -15.7715374, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -50.0629034, 0, 0, 0, 0, 0, 0, 0, 35.8856254, 0, -51.062155, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 78.136688, 0, 0, 0, 0, -41.5917514, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 73.1472674, 0, -77.9015418
], [
    0, -6.5048614, -28.611729, 0, 0, -97.9680564, 33.7007078, -70.5347856, 0,
    17.197908, 0, 19.8776858, -24.4246618, 0, 0, 53.363481, 0, 0, 0,
    -44.7872848, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -74.0599438, -81.2162694,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -68.6473592, 0,
    39.894997, 0, 0, -38.5305628, 0, -5.244101, 0, 0, 46.6040974, 2.4384956, 0,
    0, -26.8264528, 0, 0, -98.5537452, 2.6463192, 0, 0, 0, 0.4769732
], [
    0, 0, 0, 0, -52.7430298, 1.8510158, -39.691072, 0, 0, 0, 0, 0, 95.6497418,
    0, 0, -48.04896, 0, -26.6728378, 0, 0, 0, 0, 0, -12.3921976, -65.5861706, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -57.9815088, 0, 77.6808808, 0, 0, 0, 94.6506526, 0, 0, 0, 55.8427672, 0, 0,
    -0.6995066, 0, -78.3071326, 0, 0, 0, 0, 0, 0, 0, 0, 0, -67.9654476
], [
    0, -23.0019946, 0, 0, 95.4877116, 0, 0, 0, 0, 0, -36.573767, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 90.1862622, -36.4728966, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 86.6126918, 0, 0, 0, 0, 0, 0, 0,
    -80.1067184, 0, 31.8472788, 27.496628, -66.6206162, 0, 0, 9.1957296, 0,
    37.2257526, 0, 0, 0, 0, 0, 0, 0, -39.1637322, 0, 0, 74.4924622
], [
    0, 0, -25.4147588, 6.2424662, 0, 0, 0, 0, 0, 0, 92.5623938, -92.810452, 0,
    0, 0, 0, 0, 0, 0, 0, 0, -45.0048688, 0, 0, -32.1678062, 0, 0, 0, 9.8719598,
    -33.7145476, -16.3449354, 0, 70.462643, 0, 0, 14.5356206, 0, 0, 0, 0,
    -95.1218374, 0, 0, 0, 0, -0.8077516, 0, 0, 0, 0, 0, 53.7434994, 0, 0, 0, 0,
    0, 5.376533, 0, 0, 0, 0, 0, 0, -1.125953, 75.3929928, 0, 0, 0, 0, 0,
    -17.8555478, 0, 0, 87.130332, -46.977091
], [
    -57.0064908, 0, -61.469472, 0, 0, 94.2906142, 0, 10.1214686, 0, 0, 0, 0, 0,
    0, 0, 0, 90.8859632, 0, -31.3550928, 25.4391198, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, -30.6974596, 0, 16.8162692, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -40.946388,
    -23.914437, -39.0760436, 0, 0, 12.4664916, 0, 0, 0, 59.3854694, 0, 0,
    -79.029102, 0, 48.0444832, 0, 0, 0, 0, 0, 0, 0, -34.447419, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -42.8371356
], [
    -46.3742298, 0, 0, 0, 0, 6.4096268, 0, 0, 0, 0, 0, 0, 0, 0, 53.7055136,
    41.0589284, 0, 0, 0, 0, 0, 0, -59.494163, 78.2644798, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 3.5467882, 0, 0, 0, 0, 0, -33.8146284, 0, 81.1209896, 0, 0,
    0, 0, 0, 0, -59.120982, 0, 0, 0, 0, 20.5082176, 0, 0, -32.2137818,
    41.6679682, 98.4426286, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18.7911844
], [
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    22.5196126, -44.92426, 0, 0, 0, 0, -78.1154748, 95.3654376, 0, 0, 0,
    -42.4266782, 73.3850132, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 94.1878774,
    90.3854666, 0, 0, 0, 0, 0, -15.9053536, -74.9423846, 47.214, 0, 0, 7.477562,
    0, 46.2206928, 19.1508454, 41.6978146, 39.03286, 0, 0, 0, 0, 0, -14.259302,
    0, 54.0542232, 0, 0, 44.5438142
], [
    95.3632006, 43.6928354, 75.8291588, -81.2577418, 0, 0, -91.248437, 0, 0,
    22.476879, -77.967431, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3.0308978, -22.0727056, 0,
    0, 0, 0, 0, 0, 0, 17.126454, 0, -45.7583606, 0, 0, 32.9187018, 0, 0, 0, 0,
    0, -58.6847152, 0, 0, 39.113676, 0, 0, 0, 0, 0, 0, -80.1176538, 0,
    -86.9570556, 0, 0, 0, -9.3462492, 0, 49.3616864, 0, 60.4773586, 0, 0,
    48.9766746, 17.5735282, 75.126033, 0, -50.8306992, 0, 0, 61.3438194, 0, 0,
    -95.9051914, 0, 25.6497354
], [
    -89.5581772, 0, 0, 0, 0, -37.7576814, 0, 0, 0, -50.475431, 0, 0, 0, 0,
    -75.575654, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6.7066106, 0, 0, 0, 68.702018, 0, 0,
    44.2841378, 0, 0, 0, 0, 0, 0, 0, 42.4183476, 80.6872178, 72.028214, 0, 0, 0,
    -50.6912368, 0, 0, 0, 53.1913708, 0, 0, 0, 0, -50.0798868, 0, 0, 0, 0, 0, 0,
    -99.54189, 0, 0, 0, 0, 87.8828622, 7.144766, 0, 0, 0, 71.8161494,
    91.0414654, 0, 0, -7.240427
], [
    0, -73.397517, 0, 0, 0, 0, -42.4633614, 0, 0, 0, 0, -2.3988294, -60.1970288,
    -31.1370786, -16.4428054, 0, -86.5694254, 0, 0, 0, 0, 0, 0, 0, 0,
    -33.759363, 0, 88.9440556, 0, 0, 0, 48.8687358, 0, 0, 60.1841648, 0, 0,
    81.5798018, 0, 0, 0, 0, 22.265044, 0, 0, 0, 0, -98.612946, 0, 0, 0,
    -49.44052, 0, 46.9606012, 0, 0, 0, -23.7990468, 0, 0, 0, 0, -72.1702852, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 26.2623134, 0, -17.3386012
], [
    0, 16.4596174, 0, 0, 0, 0, -85.6599392, 0, 0, 0, 0, 0, 0, 93.708794, 0,
    -37.5698758, 0, 0, 0, 0, 0, 0, -82.8927936, 0, 82.4183808, 0, 0, 0, 0, 0, 0,
    55.028266, 0, 0, 11.3484192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -60.7651522, -4.822581, 0, 29.0627604, 0, 0, 61.7042716, 41.5363722,
    73.9967868, 0, 0, 0, 0, 50.2308124, 0, 33.8231702, 0, 0, 0, 0, 0,
    -14.7226996, 14.5401778, 0, -72.8145596, 19.9220286, -76.4609286
], [
    11.1687196, 0, 0, 0, 0, 0, 0, 0, -37.365205, 0, 0, 0, 52.0314298, 0,
    -58.0558462, 0, 0, 18.6738906, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    59.6046802, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -26.5944948, 0, 0, 0,
    77.0271992, 46.521059, 61.8258634, 0, 0, 36.079546, 0, -14.3080494, 0,
    -50.1618478, 0, 0, 95.9445656, 0, 0, 0, 0, 0, 0, 0, 0, 0, -53.478982,
    -90.3623976, 0, 0, -37.1575466
], [
    0, 0, 0, 0, 0, 0, 0, 78.882051, 0, 0, 57.8056512, 7.2056626, 0, 2.822132,
    40.311822, 0, 0, 0, 83.8935006, 0, 0, 91.2774482, 3.160849, 91.7410132, 0,
    0, 0, 0, 0, 2.7544652, 0, 0, 0, 0, 0, 16.8419108, 0, 0, 84.1171174, 0,
    21.3119752, -69.869284, 0, 0, 0, 0, 0, 92.1087118, 0, 0, 0, 0, 34.3473744,
    21.9890278, 0, -36.3139526, 0, 0, 0, 0, 0, 25.613497, -2.989159, 0, 0, 0, 0,
    -49.2456622, 0, 0, 27.3140788, 0, 49.210258, 0, 0, -90.6896972
], [
    0, 0, 0, 0, 0, 0, -56.1947046, 0, 0, 52.6617176, 61.6283016, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -34.0759312, 0, 92.0200254, 0, 0, -9.7999914, 0, 0, 34.0572616,
    0, 0, 0, 0, 0, 59.7637334, 0, 0, 0, 0, 0, 43.5437732, 29.9690024, 0, 0,
    93.9438036, 0, 0, 0, 52.3867986, 0, 0, 0, 38.0567542, 0, -63.9851954, 0,
    73.1679634, 0, 0, -28.6636244, 0, 0, 0, 0, 0, 39.2894916, 0, -28.4364668, 0,
    0, 0, 0, 0, 0, 0, -32.2899456
], [
    15.3399588, 0, 0, 0, 0, 0, 0, -66.2540916, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 14.7613734, 0, 0, 0, -32.9550622, 0, 0, -17.2710502, 0, 0, 0,
    -66.7611862, 76.5708962, 93.3868072, 12.036471, 0, 0, 0, -74.2189184, 0, 0,
    0, 0, 58.0343866, 0, 71.0145124, 0, 0, 0, 0, 0, 0, 0, 80.7131208, 0,
    -49.5191686, 40.2489602, 0, 0, 39.9664558, 0, 0, 0, 0, 0, 0, 51.704979, 0,
    20.9209752, 0, 0, -63.5800814
], [
    0, 0, 35.1676872, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8.326191, 0, 0, 0,
    -42.1405488, 0, 0, 0, 0, -64.9203894, 0, 0, 0, 86.5653072, 0, 17.1250418, 0,
    15.224998, -32.788739, 0, 0, 0, 13.1550612, 0, 0, 0, 93.3049176, 65.5504482,
    0, 35.8126186, -16.2474202, 0, -76.7788518, -51.9001008, 0, -89.725966,
    53.4895596, 0, 0, 0, 0, 0, 0, 0, 0, 0, -82.6077236, 0, 0, 0, -57.075872,
    -52.5166376, 99.9479554, 0, 0, -89.7491862, 0, 18.6163306, 0, 29.1454254
], [
    -18.8864514, 0, 0, 0, 0, 0, -46.6968628, -83.8123266, 0, 0, 0, 0, 0, 0,
    -91.631792, 0, 0, 0, 0, -57.3455082, 66.459894, 0, 0, 0, -73.9341878, 0, 0,
    0, 81.8859882, 0, 0, 0, 0, 0, 28.0747908, 0, 0, 99.7796988, 0, 87.0296656,
    0, 0, 43.7722526, -60.65313, 98.6287198, 0, 20.8634118, 0, 0, 25.6519386,
    0.4939554, 0, 0, 0, 0, 0, 0, 0, 0, -74.9266526, 0, 0, -25.4234142, 0,
    -91.054582, 0, -42.534282, 0, 0, 0, 0, 0, 0, 0, 0, 12.1491094
], [
    0, -90.5331764, 0, 0, 0, 0, 0, -8.1166918, 0, 0, 0, 0, 0, -34.0013692,
    21.9272646, 0, 0, 0, 0, 0, 93.2245032, 0, 21.8275426, 0, 0, 0, 38.5279608,
    -6.0022692, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39.644863, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -93.7962256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11.5363598,
    70.354452, 0, 0, 0, 32.2282298, 0, 36.659058, 0, 0, 53.992344
], [
    -74.4430478, 0, 0, -93.4496218, 14.6437598, 0, 0, 0, -33.8297902, 0, 0, 0,
    0, 0, 0, -35.949213, 0, 0, -93.1678628, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -22.8806328, 0, 0, 0, 0, 0, 0, 0, 45.1466816, 88.4821604, 0, 0, -49.7769388,
    0, 0, 0, 0, 0, 0, 53.6290382, -40.4388272
], [
    71.2065308, 94.4966808, 0, 0, 0, 0, -84.2404402, 0, 0, 0, 0, 0, 61.7641462,
    0, 0, 0, -0.608018, -94.7698384, 0, 0, 0, 0, -3.4562834, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, -26.0708126, -73.3657794, 26.6482556, 0, 0, 0, 0,
    0, 0, -66.9699546, -98.6726948, 0, 0, -25.4137958, 0, -88.7254432,
    -81.2735544, 0, -23.3081526, 0, -51.8917252, 0, 0, 0, 0, 0, 0, 0, 0,
    -52.3004828, 0, 0, 0, 0, 67.8542398, 0, -67.7489638, 32.2212522
], [
    0, 77.0252092, 0, 0, 0, 0, 0, -85.3271924, 0, 0, 0, -2.9308596, 0,
    83.448547, 0, 4.7835886, 0, 0, 0, 0, 76.590577, 0, 0, 0, 0, 0, 86.0180794,
    0, 0, -88.4030016, 0, 0, 0, -13.770426, 57.6068646, 0, 0, 0, 0, 0,
    12.6896788, 0, 0, 0, -78.1078136, -92.3074796, 0, 0, 0, 0, -94.3200626, 0,
    0, -7.987837, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 52.7655986, 0, -78.2727176,
    0, 74.4309632, 48.3867546, -85.4142468, 0, 91.3888914, -6.0372808,
    51.1643348
], [
    -77.4193002, 0, 0, 0, 0, 0, 0, 0, 41.0846988, -78.3265056, 0, 0, 0, 0, 0, 0,
    0, -20.408123, 10.7055032, 0, -19.5848354, 0, -32.624054, 0, 47.333306, 0,
    -41.6545398, 0, 0, 0, 0, 0, 46.8131656, 0, 52.5387768, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -75.3511542, 0, 0, 0, 0, -27.6140242, 0, 0, -63.3032372, 0, 0, 0, 0,
    0, 0, 0, 0, -93.1854838, 0, 0, 0, 0, 32.3353436, -75.8659438, 89.852816, 0,
    9.7044216, 0, 94.9239572, 0, -57.0391726, 25.4894998
], [
    0, 0, 0, -27.2226392, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -89.0780816, 0, 0,
    0, 0, 6.6342408, 0, 0, 92.3634346, -41.5559582, 0, 0, 0, 0, 0, 0,
    -4.3499792, 18.9554522, 0, 29.992962, 0, 0, 0, 0, 0, 0, 0, 0, -51.9952794,
    -40.3571344, 0, -61.0098328, 0, 0, 0, 0, 71.8571838, 97.3056784, 0, 0,
    27.798026, 0, 0, 20.3198544, 0, 0, 0, -82.1043534, 0, 0, 0, 0, 0,
    55.2807134, 0, 0, 0, 0, -90.8562594, -43.2271604
], [
    0, 0, 0, 0, 0, 15.2015056, 18.3740448, -11.2614058, 0, 0, 0, 0, 0,
    53.0086248, 0, -91.038908, 0, 0, 88.2707986, 3.2580272, 0, 0, 0, 0, 0, 0, 0,
    0, 88.8189254, 0, 0, 0, 0, -3.742353, 0, 0, 0, -41.4198488, 90.0966416, 0,
    -22.474875, 0, -25.610863, -79.5943706, 0, 0, 0, 0, 0, 0, 0, -3.5616438, 0,
    0, 0, 88.5984932, 0, 0, 0, 0, 0, 0, 0, 22.4398688, 0, 0, 0, 0, 0, 0, 0,
    -63.7422676, 0, 0, 0, -82.7150752
], [
    0, 0, 75.634243, -60.420708, 0, 0, 0, 0.8383984, 0, 0, -72.2791914, 0, 0, 0,
    17.1476022, 0, 0, -14.5930276, 9.4352026, 0, -30.1475326, 0, -53.7249052, 0,
    19.3293368, 0, 0, 0, -80.867335, 0, -3.344608, 71.3546388, -91.098817, 0, 0,
    0, -26.83234, 0, 3.7009, 0, 0, 0, 0, 0, 28.4006138, 0, 0, 57.1433046,
    14.4086186, 0, 0, 0, 49.5828354, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17.0012008, 0,
    30.5581294, -98.7868224, 0, 0, 0, 70.0467486, -9.4444084, 0, 19.9250998, 0,
    0, -79.4970662
], [
    0, 54.0067274, 0, 0, 0, 37.9936634, 0, -20.1071476, -58.981429, 0, 0,
    -83.9927614, 0, 0, 0, 0, 0, 0, -70.8571636, 0, 0, 68.4686496, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -8.1687508, 0, 0, 16.6835288, -10.1286606, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 86.4747972, 0, -34.6316042, 0.9788672, 0, 0, -41.4513542,
    0, 0, 0, 0, 0, 0, 0, 0, -28.4021576, -74.9076708, 0, -5.0425708, 0, 0, 0,
    78.9139852, -50.7082204, 0, 34.0684852, 28.2502302
], [
    0, 0, 0, 0, 0, 0, 0, 57.544994, 0, 0, -22.4411072, 0, -94.2568866,
    -80.7849138, 0, 0, -10.0010618, 33.3160792, 0, 0, 0, 0, 0, 0, -82.6811248,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -11.0390072, 0, 0, 32.0523166, 0, -80.6937396,
    0, -94.2671164, 0, 0, -16.2170198, 0, 0, 0, -5.7387768, 0, 0, 0, 0,
    -83.6048238, 0, 0, 0, 0, 0, 0, 33.6877392, 0, -41.9784856, 0, 0, 0,
    -50.6512854, 0, 78.737702, 0, 0, 0, 0, 0, 9.0618996
], [
    0, 0, 0, 0, 0, -94.8072128, 0, 21.9767716, 0, 0, 0, 57.7817378, 35.3840102,
    0, 0, 0, 60.4679182, -94.9978498, 0, -18.9377882, -42.3270372, 0, 0, 0, 0,
    -3.9058912, 0, 0, 44.440235, 0, 0.41471, 0, 0, -88.0148602, 53.9755254, 0,
    0, 74.7772774, -19.633854, -66.6129164, -25.4637816, -13.1642082, 0, 0, 0,
    0, 57.6068044, 0, 0, -75.9060014, 24.0447026, 0, 0, 29.9750648, 0, 0, 0,
    -54.938857, -4.4090126, 0, 0, 0, 0, 0, 0, -57.1202194, 0, -11.130658, 0, 0,
    95.6177756, -78.5403868, 0, 0, 30.4589622, -93.6950296
], [
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -50.308444, 0, 0, 0, 0, 0, 0, 0, -20.3462364,
    0, 0, 25.6081088, 0, 0, 0, 0, 0, 0, 90.9877902, 0, -56.0922542, 99.2456868,
    0, 45.4316172, 0, 70.1339288, -54.576692, 0, 0, 0, -73.6910292, 0, 0, 0, 0,
    0, 0, 38.6032202, 0, 0, 0, 60.7387286, 0, 0, 0, 0, 0, 0, 0, 0, 95.207832, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 58.4721284
], [
    0.3163476, 0, 0, 13.0918568, 5.13089, 0, 40.7266308, 0, 0, 0, 0, 0,
    -98.7077428, 0, 81.000503, 0, 0, 76.3945372, 0, 0, 0, 0, 0, 0, -10.2289084,
    -70.592702, 0, 0, 0, 0, 0, 0, 69.59571, 0, 0, 0, 0, 0, -61.4746908,
    53.4041094, 0, 90.4397278, -33.1874988, 0, 0, 71.5512744, 5.846105, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56.7568638, 0, 0, 66.7588344, 0, 0, 0,
    99.284785, 0, 0, 0, 0, 0, 0, -99.2850048, -85.4466004
], [
    0, 0, -34.544278, 0, 0, -36.135124, -33.4259354, 0, 0, -60.4256326, 0,
    44.7734168, 0, 0, 0, 0, -88.6744704, 0, 0, 0, 0, 0, 0, 0, 0, -95.3752508,
    4.596855, 85.2924422, 70.9081648, 22.0390844, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1.6872456, 0, 0, 0, 0, 0, 0, 0, -37.4782422, 0, 0, 0, 0, 0, 0, 0, 0,
    4.7642096, 0, 0, -33.6313218, 0, 0, 72.977526, 0, 0, 0, 0, 0, 0, 2.5063252,
    0, 0, 0, 0, 0, -64.8677902
], [
    0, 0, 0, 3.718989, 0, 0, 49.3814782, 77.868826, 0, 0, 0, 0, 0, 0, 0, 0,
    -49.7008846, 0, 4.696494, 0, 0, 0, 0, 0, 0, 0, -59.4928602, 0, 0, 0, 0, 0,
    82.6840644, -0.996624, -15.8014198, -93.098215, 0, 0, 41.2709314, 0,
    -90.9633198, -56.911012, 0, 0, 0, 0, 0, 0, 0, 0, 0, -26.02585, 0, 0, 0, 0,
    0, 0, 61.2353938, 0, 0, 0, 0, 21.376448, 0, 0, 0, 0, 0, 0, 0, 97.0578858, 0,
    0, 0, 5.1265226
], [
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -19.5643656, 0, 0,
    -92.0307416, 0, 0, 0, 0, 55.003856, 0, 0, -20.4708104, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 54.4588824, 0, 0, 0, 0, 0, 0, 0, 0,
    -57.0182252, 0, 0, -48.3222128, 0, 0, 0, -41.1121382, 0, 0, 0, 0, 0, 0,
    -12.2773602, 0, -28.6924808, 50.0415338
], [
    0, 0, 0, -73.9719246, 0, 0, 0, 0, 0, 0, 0, 39.4110332, 0, 0, -21.6757132, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74.8739354, 0, 0,
    -52.9210426, 0, 46.7750368, 63.6311858, 0, 0, 0, 0, 25.5310902, 0,
    -3.0369126, 0, 32.5437816, 0, 0, 78.9107496, 32.0416448, 0, 0, 15.9408846,
    0, 0, 0, 0, -67.7582854, -52.6103086, 0, 0, 0, 0, 0, 0, 11.8676176, 0, 0,
    -41.8820812, 43.608357, 0, 0, -64.3752572
], [
    0, -15.1648222, -57.5273074, -94.2919124, -3.0777222, -77.345826,
    91.2777856, 0, 0, 0, 0, 13.5044774, 0, 0, 0, 0, 0, 0, 0, 0, 33.5509618, 0,
    0, -33.291092, -60.3050638, 0, 0, 0, 94.610171, 0, 0, 0, 0, 0, 0,
    -47.270154, -81.403122, 0, 0, 47.829269, 0, 0, 0, 0, -47.4699122, 0, 0,
    -31.0161918, 0, 0, -54.993563, -9.6544012, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -17.0644648, 0, 0, 0, 0, 0, 0, 49.0555938, -82.4686508, 0, 0, 97.7299292, 0,
    0, -93.1718028
], [
    0, 0, 0, 45.5639954, 0, 0, 0, 0, 0, 92.3127826, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -5.8746296, 22.9079182, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    25.2727812, 0, 0, 0, 0, 0, 0, 65.0012614, 0, 67.4376806, 0, 0, 14.0298002,
    0, 0, 0, 0, 0, 33.432514, 43.000429, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20.2757068,
    4.0567932, 0, 0, -15.8737758, 0, 0, 0, 0, 29.8957398, 50.0218946, 17.0262346
], [
    46.1658228, 19.630724, 0, 0, 0, 0, 0, 80.6073204, 24.5091878, 0, 0, 0,
    73.9258848, 0, 0, 0, -98.2044476, 0, 0, 0, 0, -59.2213968, 0, -70.1450004,
    0, 0, 0, 42.4721292, 0, -73.0346074, 0, 67.9829686, 0, 0, 0, 0, 6.6597886,
    39.7215082, 0, 0, 0, 52.505292, 95.9204336, 0, 0, 5.8797776, 0, 0, 0,
    36.0738246, 0, -15.2667614, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50.963131, 0, 0, 0,
    49.3354032, 13.7868492, 0, 77.3708062, 26.0888548, 0, 0, 0, 0, -60.0881692,
    24.2459968
], [
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56.562023, 0, 0, 24.9145996, 0, 0, 0, 0,
    32.8196724, -75.8879774, -12.4005106, 0, 0, 0, 0, -18.824482, -45.0330046,
    0, 0, -47.5493022, 0, 0, 0, 8.1879572, 0, 0, 4.5700222, -28.6731266, 0, 0,
    0, 0, -83.2735948, 5.4624948, 0, 0, 0, 0, 0, 0, 0, 83.664375, -52.8630198,
    58.5805764, 0, 0, 0, 45.5781336, 0, 0, -1.9768322, 0, 0, 0, 0, 91.1151128,
    0, 0, 0, 0, 0, 0, -65.5158586, 0, -22.12762
], [
    0, 0, 0, 0, 0, -50.8301006, 0, -57.183698, -24.666489, 43.0557936, 0, 0, 0,
    -44.0812116, 0, 0, 0, 97.1670056, 0, 0, 0, 0, 83.4511366, 0, -96.8912356,
    -6.1095452, 87.6643268, 0, 0, 0, -32.5223614, 0, 0, 0, 0, -18.5596964, 0,
    56.1790224, 0, 25.6035684, 0, 0, 0, 0, -46.8740154, 0, 0, 0, 0, 0, 0, 0,
    -44.4329434, -34.719678, 85.6384822, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    48.9669952, 0, 0, 0, 0, 0, 0, 0, 0, 0, -28.2571694
], [
    0, 0, 0, 0, 42.1192158, 18.3800218, 0, 0, 33.4475094, 0, -39.4713432, 0,
    54.9744572, 0, -6.6305664, 79.0252374, 77.6908818, -61.5099746, 0, 0,
    38.4501814, 0, 0, -96.4250704, -27.809694, -34.9250884, 63.2997728, 0,
    -98.8800042, 0, -7.682428, 0, 0, 0, 0, 0, 0, 7.7256608, 0, 48.5546152, 0, 0,
    0, 0, 0, 0, -58.963373, 0, 0, 0, 0, 0, 86.5062664, 7.0006556, 0, 0, 0, 0, 0,
    0, 3.1958572, 0, -46.2861844, 0, 0, 0, 0, 30.0710902, 46.6948898, 0,
    68.4681908, 0, 0, 0, 0, -51.3930766
], [
    7.1969236, 0, -79.6160432, -39.947334, -15.2636342, 0, 10.0645898,
    -57.8968238, -31.9945476, 0, 91.5839662, -52.777566, 0, 0, 0, 0,
    -40.9252974, 0, 0, 0, -45.5113982, 70.585349, 0, 0, 0, 0, 0, 0, 0, 0,
    -66.2523308, 0, 0, 0, 0, 0, 0, 0, 0, 85.7454324, -7.1148372, 0, 93.6584844,
    0, 0, 0, 0, 0, 0, -8.0414788, 0, 0, 0, 0, 51.3263388, 0, 0, 79.892422, 0, 0,
    -64.6934098, 0, 0, -45.9577622, 0, 0, 0, -46.8290526, 0, 48.2417506, 0, 0,
    0, 0, -2.4115812, -50.7156922
], [
    62.9870494, -81.5584552, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53.7333104, 0,
    50.6438202, -57.7938262, 0, 0, 0, 0, -78.1108892, 0, 0, 0, 0, 0, 0, 0,
    87.6584692, 0, 58.2960112, -17.5355398, 12.0497204, -60.5414862, 0, 0, 0, 0,
    0, 0, 0, 0, 38.586472, -19.7940052, 94.423359, -89.557933, 0, 0,
    -77.0715722, 0, -87.707166, 70.8585278, 0, 9.0616914, 91.333051, 0, 0, 0,
    5.8166112, 0, 24.7793442, -51.000038, 0, 0, 0, 0, 0, 0, 79.9657776,
    97.4969126, 0, 0, 0, 0, -73.8994394
], [
    10.133741, 0, 0, 0, 95.6910336, 0, 0, 0, 0, -22.6696236, 0, 0, 0, 0,
    15.137996, 35.7088464, 0, -16.1971956, 0, -29.4834358, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -89.868739, 24.0040126, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    40.7292396, 35.7709458, 0, 34.690347, 22.3083532, 0, 0, 0, 0, 0,
    -48.4224164, 0, 0, 0, 0, 91.7670744, 0, 0, 69.4045014, 0, 60.5937114,
    -38.9993134, 0, 0, 0, 0, 0, 55.4599018, 0, 86.689944
], [
    0, 0, -24.842169, -52.997003, 0, 0, 0, 0, 0, 0, 0, 5.9075842, 0, 0,
    -91.1447252, -5.3147106, 0, 0, 0, 4.4670454, 34.97343, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -5.3957052, 0, 0, 0, 0, -19.2118838, 0, 0, 0, 0, 0, 0, 0, 0,
    64.9559324, 0, 0, -10.0586402, 0, -74.8523334, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    84.8495464, 0, 0, 0, 0, 0, 0, 33.0825986, 46.995148, 0, 0, 0, -4.243203, 0,
    0, -24.0124188
]]

def solve_qubo():
    """Solve the Qubo problem."""

    # Constraint programming engine
    model = cp_model.CpModel()

    num_vars = len(RAW_DATA)
    all_vars = range(num_vars)
    variables = [model.NewBoolVar('x_%i' % i) for i in all_vars]

    obj_vars = []
    obj_coeffs = []

    for i in range(num_vars - 1):
        x_i = variables[i]
        for j in range(i + 1, num_vars):
            coeff = int((RAW_DATA[i][j] + RAW_DATA[j][i]) * 1000.0)
            if coeff == 0.0:
                continue
            x_j = variables[j]
            var = model.NewBoolVar('')
            model.AddBoolOr([x_i.Not(), x_j.Not(), var])
            model.AddImplication(var, x_i)
            model.AddImplication(var, x_j)
            obj_vars.append(var)
            obj_coeffs.append(coeff)

    for i in all_vars:
        self_coeff = int((RAW_DATA[i][i] + RAW_DATA[i][-1]) * 1000.0)
        if self_coeff != 0.0:
            obj_vars.append(variables[i])
            obj_coeffs.append(self_coeff)


    model.Minimize(
        sum(obj_vars[i] * obj_coeffs[i] for i in range(len(obj_vars))))
    # Patch the scaling factor of the objective.
    model.Proto().objective.scaling_factor = 1.0 / 1000.0
    print(model.ModelStats())

    ### Solve model.
    solver = cp_model.CpSolver()
    solver.parameters.num_search_workers = 8
    solver.parameters.log_search_progress = True
    solver.Solve(model)
    print(solver.ResponseStats())


if __name__ == '__main__':
    solve_qubo()
