/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.demos;

import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Channel;
import org.javagroups.JChannel;
import org.javagroups.MembershipListener;
import org.javagroups.View;
import org.javagroups.blocks.RpcDispatcher;
import org.javagroups.util.Rsp;
import org.javagroups.util.RspList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class QuoteClient
extends Frame
implements WindowListener,
ActionListener,
MembershipListener {
    final String channel_name = "Quotes";
    RpcDispatcher disp;
    Channel channel;
    Button get;
    Button set;
    Button quit;
    Button get_all;
    Label stock;
    Label value;
    Label err_msg;
    TextField stock_field;
    TextField value_field;
    List listbox;
    final Font default_font;
    String props;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Float;

    private final void showMsg(String msg) {
        this.err_msg.setText(msg);
        this.err_msg.setVisible(true);
    }

    private final void clearMsg() {
        this.err_msg.setVisible(false);
    }

    public void start() {
        this.setLayout(null);
        this.setSize(400, 300);
        this.setFont(this.default_font);
        this.stock.setBounds(new Rectangle(10, 30, 60, 30));
        this.value.setBounds(new Rectangle(10, 60, 60, 30));
        this.stock_field.setBounds(new Rectangle(100, 30, 100, 30));
        this.value_field.setBounds(new Rectangle(100, 60, 100, 30));
        this.listbox.setBounds(210, 30, 150, 160);
        this.err_msg.setBounds(new Rectangle(10, 200, 350, 30));
        this.err_msg.setFont(new Font("Helvetica", 2, 12));
        this.err_msg.setForeground(Color.red);
        this.err_msg.setVisible(false);
        this.get.setBounds(new Rectangle(10, 250, 80, 30));
        this.set.setBounds(new Rectangle(100, 250, 80, 30));
        this.quit.setBounds(new Rectangle(190, 250, 80, 30));
        this.get_all.setBounds(new Rectangle(280, 250, 80, 30));
        this.get.addActionListener(this);
        this.set.addActionListener(this);
        this.quit.addActionListener(this);
        this.get_all.addActionListener(this);
        this.add(this.stock);
        this.add(this.value);
        this.add(this.stock_field);
        this.add(this.value_field);
        this.add(this.err_msg);
        this.add(this.get);
        this.add(this.set);
        this.add(this.quit);
        this.add(this.get_all);
        this.add(this.listbox);
        this.setVisible(true);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        try {
            if (command == "Get") {
                Float val;
                String stock_name = this.stock_field.getText();
                if (stock_name == null || stock_name.length() == 0) {
                    this.showMsg("Stock name is empty !");
                    return;
                }
                this.showMsg("Looking up value for " + stock_name + ':');
                Object[] objectArray = new Object[]{stock_name};
                String[] stringArray = new String[1];
                Class clazz = class$java$lang$String;
                if (clazz == null) {
                    clazz = class$java$lang$String = QuoteClient.class$("[Ljava.lang.String;", false);
                }
                stringArray[0] = clazz.getName();
                RspList rsp_list = this.disp.callRemoteMethods((Vector)null, "getQuote", objectArray, stringArray, 1, 10000L);
                Rsp first_rsp = (Rsp)rsp_list.elementAt(0);
                Float f = val = first_rsp != null ? (Float)first_rsp.getValue() : null;
                if (val != null) {
                    this.value_field.setText(val.toString());
                    this.clearMsg();
                } else {
                    this.value_field.setText("");
                    this.showMsg("Value for " + stock_name + " not found");
                }
            } else if (command == "Set") {
                Class clazz;
                String stock_name = this.stock_field.getText();
                String stock_val = this.value_field.getText();
                if (stock_name == null || stock_val == null || stock_name.length() == 0 || stock_val.length() == 0) {
                    this.showMsg("Stock name and value have to be present to enter a new value");
                    return;
                }
                Float val = new Float(stock_val);
                Object[] objectArray = new Object[]{stock_name, val};
                Class[] classArray = new Class[2];
                Class clazz2 = class$java$lang$String;
                if (clazz2 == null) {
                    clazz2 = classArray[0] = (class$java$lang$String = QuoteClient.class$("[Ljava.lang.String;", false));
                }
                if ((clazz = class$java$lang$Float) == null) {
                    clazz = class$java$lang$Float = QuoteClient.class$("[Ljava.lang.Float;", false);
                }
                classArray[1] = clazz;
                this.disp.callRemoteMethods((Vector)null, "setQuote", objectArray, classArray, 1, 0L);
                this.showMsg("Stock " + stock_name + " set to " + val);
            } else if (command == "All") {
                this.listbox.removeAll();
                this.showMsg("Getting all stocks:");
                RspList rsp_list = this.disp.callRemoteMethods((Vector)null, "printAllStocks", (Object[])null, (Class[])null, 6, 0L);
                System.out.println("rsp_list is " + rsp_list);
                Hashtable all_stocks = (Hashtable)rsp_list.getFirst();
                if (all_stocks == null) {
                    this.showMsg("No stocks found");
                    return;
                }
                this.clearMsg();
                this.listbox.removeAll();
                Enumeration en = all_stocks.keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    Float val = (Float)all_stocks.get(key);
                    if (val == null) continue;
                    this.listbox.add(key + ": " + val.toString());
                }
            } else if (command == "Quit") {
                this.setVisible(false);
                this.channel.close();
                System.exit(0);
            } else {
                System.out.println("Unknown action");
            }
        }
        catch (Exception ex) {
            this.value_field.setText("");
            ex.printStackTrace();
            this.showMsg(ex.toString());
        }
    }

    public void viewAccepted(View new_view) {
        this.setTitle("Members in Quotes: " + (new_view.size() - 1));
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    public static void main(String[] args) {
        QuoteClient client = new QuoteClient();
        client.start();
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.channel_name = "Quotes";
        this.get = new Button("Get");
        this.set = new Button("Set");
        this.quit = new Button("Quit");
        this.get_all = new Button("All");
        this.stock = new Label("Stock");
        this.value = new Label("Value");
        this.err_msg = new Label("Error");
        this.stock_field = new TextField();
        this.value_field = new TextField();
        this.listbox = new List();
        this.default_font = new Font("Helvetica", 0, 12);
        this.props = "UDP:PING(num_initial_members=2;timeout=3000):FD:pbcast.PBCAST(gossip_interval=5000;gc_lag=50):UNICAST:FRAG:pbcast.GMS:pbcast.STATE_TRANSFER";
    }

    public QuoteClient() {
        this.this();
        try {
            this.channel = new JChannel(this.props);
            this.channel.setOpt(3, new Boolean(false));
            this.disp = new RpcDispatcher(this.channel, null, (MembershipListener)this, (Object)this);
            this.channel.connect("Quotes");
        }
        catch (Exception e) {
            System.err.println("QuoteClient(): " + e);
        }
        this.addWindowListener(this);
    }
}

