/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.stack.AckSenderWindow;
import org.javagroups.stack.IpAddress;
import org.javagroups.stack.Protocol;
import org.javagroups.util.RWLock;
import org.javagroups.util.TimeScheduler;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TOTAL
extends Protocol {
    private static final String PROT_NAME = "TOTAL";
    private static final String TRACE_PROP = "trace";
    private static final long NULL_ID = -1L;
    private static final int NULL_STATE = -1;
    private static final int RUN = 0;
    private static final int FLUSH = 1;
    private static final int BLOCK = 2;
    private long MIN_RETRANSMIT_INTERVAL;
    private long[] AVG_RETRANSMIT_INTERVAL;
    private RWLock stateLock;
    private int state;
    private Address addr;
    private Address sequencerAddr;
    private long sequencerSeqID;
    private long localSeqID;
    private long seqID;
    private SortedMap reqTbl;
    private SortedMap upTbl;
    private AckSenderWindow retransmitter;

    private final String _addrToString(Object addr) {
        return addr == null ? "<null>" : (addr instanceof IpAddress ? ((IpAddress)addr).getIpAddress().getHostAddress() + ':' + ((IpAddress)addr).getPort() : addr.toString());
    }

    private final String _getName() {
        return PROT_NAME;
    }

    private final boolean _setProperties(Properties properties) {
        String value = properties.getProperty(TRACE_PROP);
        if (value != null) {
            properties.remove(TRACE_PROP);
        }
        if (properties.size() > 0) {
            Trace.error("TOTAL.setProperties()", "The following properties are not recognized: " + properties.toString());
            return false;
        }
        return true;
    }

    Vector _requiredDownServices() {
        Vector services = new Vector();
        return services;
    }

    Vector _requiredUpServices() {
        Vector services = new Vector();
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void _deliverBcast() {
        SortedMap sortedMap = this.upTbl;
        synchronized (sortedMap) {
            Message msg;
            while ((msg = (Message)this.upTbl.remove(new Long(this.seqID + 1L))) != null) {
                Header header = (Header)msg.removeHeader(this.getName());
                if (header.localSeqID != (long)-1) {
                    this.passUp(new Event(1, msg));
                }
                ++this.seqID;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void _replayBcast() {
        SortedMap sortedMap = this.upTbl;
        synchronized (sortedMap) {
            if (this.upTbl.size() > 0) {
                Trace.info(PROT_NAME, "Replaying undelivered bcasts");
            }
            Iterator it = this.upTbl.entrySet().iterator();
            while (it.hasNext()) {
                Message msg = (Message)it.next().getValue();
                it.remove();
                if (!msg.getSrc().equals(this.addr)) {
                    Trace.info(PROT_NAME, "During replay: discarding BCAST[" + ((Header)msg.getHeader((String)this.getName())).seqID + "] from " + this._addrToString(msg.getSrc()));
                    continue;
                }
                Header header = (Header)msg.removeHeader(this.getName());
                if (header.localSeqID == (long)-1) continue;
                this._sendBcastRequest(msg, header.localSeqID);
            }
            return;
        }
    }

    private final Message _sendUcast(Message msg) {
        msg.putHeader(this.getName(), new Header(2, -1, -1));
        return msg;
    }

    private final void _sendBcastRequest(Message msg) {
        this._sendBcastRequest(msg, ++this.localSeqID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void _sendBcastRequest(Message msg, long id) {
        SortedMap sortedMap = this.reqTbl;
        synchronized (sortedMap) {
            this.reqTbl.put(new Long(id), msg);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var5_3
            this._transmitBcastRequest(id);
            this.retransmitter.add(id, null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void _transmitBcastRequest(long seqID) {
        Message reqMsg;
        if (this.state == -1) {
            Trace.info(PROT_NAME, "Transmit BCAST_REQ[" + seqID + "] in NULL_STATE");
            return;
        }
        if (this.state == 2) {
            return;
        }
        SortedMap sortedMap = this.reqTbl;
        synchronized (sortedMap) {
            if (!this.reqTbl.containsKey(new Long(seqID))) {
                this.retransmitter.ack(seqID);
                return;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl14 : MonitorExitStatement: MONITOREXIT : var4_2
            reqMsg = new Message(this.sequencerAddr, this.addr, new byte[0]);
            reqMsg.putHeader(this.getName(), new Header(0, seqID, -1));
        }
        this.passDown(new Event(1, reqMsg));
    }

    private final void _recvUcast(Message msg) {
        msg.removeHeader(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void _recvBcast(Message msg) {
        Header header = (Header)msg.getHeader(this.getName());
        SortedMap sortedMap = this.upTbl;
        synchronized (sortedMap) {
            if (header.seqID <= this.seqID) {
                return;
            }
            this.upTbl.put(new Long(header.seqID), msg);
        }
        this._deliverBcast();
    }

    private final void _recvBcastRequest(Message msg) {
        if (!this.addr.equals(this.sequencerAddr)) {
            Trace.error(PROT_NAME, "Received bcast request but not a sequencer");
            return;
        }
        if (this.state == 2) {
            Trace.info(PROT_NAME, "Blocked, discard bcast req");
            return;
        }
        Header header = (Header)msg.getHeader(this.getName());
        ++this.sequencerSeqID;
        Message repMsg = new Message(msg.getSrc(), this.addr, new byte[0]);
        repMsg.putHeader(this.getName(), new Header(1, header.localSeqID, this.sequencerSeqID));
        this.passDown(new Event(1, repMsg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void _recvBcastReply(Header header) {
        long id;
        Message msg;
        block5: {
            block4: {
                if (this.state == 2) {
                    Trace.info(PROT_NAME, "Blocked, discard bcast rep");
                    return;
                }
                SortedMap sortedMap = this.reqTbl;
                synchronized (sortedMap) {
                    msg = (Message)this.reqTbl.remove(new Long(header.localSeqID));
                    // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var5_2
                    if (msg == null) break block4;
                    this.retransmitter.ack(header.localSeqID);
                    id = header.localSeqID;
                    break block5;
                }
            }
            Trace.info(PROT_NAME, "Bcast reply to non-existent BCAST_REQ[" + header.localSeqID + "], Sending NULL bcast");
            id = -1;
            msg = new Message(null, this.addr, new byte[0]);
        }
        msg.putHeader(this.getName(), new Header(3, id, header.seqID));
        this.passDown(new Event(1, msg));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void _retransmitBcastRequest(long seqID) {
        try {
            this.stateLock.readLock();
            try {
                Trace.info(PROT_NAME, "Retransmit BCAST_REQ[" + seqID + ']');
                this._transmitBcastRequest(seqID);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.stateLock.readUnlock();
                throw throwable;
            }
            {
                Object var4_5 = null;
                this.stateLock.readUnlock();
                return;
            }
        }
        catch (RWLock.IntException ex) {
            Trace.error(PROT_NAME, ex.getMessage());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean _upBlock(Event event) {
        try {
            this.stateLock.writeLock();
            try {
                this.state = 1;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.stateLock.writeUnlock();
                throw throwable;
            }
            {
                Object var3_5 = null;
                this.stateLock.writeUnlock();
                return true;
            }
        }
        catch (RWLock.IntException ex) {
            Trace.error(PROT_NAME, ex.getMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean _upMsg(Event event) {
        try {
            boolean bl;
            block17: {
                boolean bl2;
                block16: {
                    boolean bl3;
                    block15: {
                        boolean bl4;
                        block14: {
                            boolean bl5;
                            block13: {
                                boolean bl6;
                                block12: {
                                    this.stateLock.readLock();
                                    try {
                                        if (this.state == -1) {
                                            Trace.error(PROT_NAME, "Up msg in NULL_STATE");
                                            boolean bl7 = false;
                                            Object var6_9 = null;
                                            this.stateLock.readUnlock();
                                            return bl7;
                                        }
                                        Message msg = (Message)event.getArg();
                                        org.javagroups.Header obj = msg.getHeader(this.getName());
                                        if (!(obj instanceof Header)) {
                                            Trace.error(PROT_NAME, "No TOTAL.Header found");
                                            bl6 = false;
                                            break block12;
                                        }
                                        Header header = (Header)obj;
                                        switch (header.type) {
                                            case 2: {
                                                this._recvUcast(msg);
                                                bl5 = true;
                                                break block13;
                                            }
                                            case 3: {
                                                this._recvBcast(msg);
                                                bl4 = false;
                                                break block14;
                                            }
                                            case 0: {
                                                this._recvBcastRequest(msg);
                                                bl3 = false;
                                                break block15;
                                            }
                                            case 1: {
                                                this._recvBcastReply(header);
                                                bl2 = false;
                                                break block16;
                                            }
                                            default: {
                                                Trace.error(PROT_NAME, "Unknown header type");
                                                bl = false;
                                                break;
                                            }
                                        }
                                        break block17;
                                    }
                                    catch (Throwable throwable) {
                                        Object var6_16 = null;
                                        this.stateLock.readUnlock();
                                        throw throwable;
                                    }
                                }
                                Object var6_10 = null;
                                this.stateLock.readUnlock();
                                return bl6;
                            }
                            Object var6_11 = null;
                            this.stateLock.readUnlock();
                            return bl5;
                        }
                        Object var6_12 = null;
                        this.stateLock.readUnlock();
                        return bl4;
                    }
                    Object var6_13 = null;
                    this.stateLock.readUnlock();
                    return bl3;
                }
                Object var6_14 = null;
                this.stateLock.readUnlock();
                return bl2;
            }
            Object var6_15 = null;
            this.stateLock.readUnlock();
            return bl;
        }
        catch (RWLock.IntException ex) {
            Trace.error(PROT_NAME, ex.getMessage());
            return true;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean _upSetLocalAddress(Event event) {
        try {
            this.stateLock.writeLock();
            try {
                this.addr = (Address)event.getArg();
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.stateLock.writeUnlock();
                throw throwable;
            }
            {
                Object var3_5 = null;
                this.stateLock.writeUnlock();
                return true;
            }
        }
        catch (RWLock.IntException ex) {
            Trace.error(PROT_NAME, ex.getMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean _upViewChange(Event event) {
        try {
            this.stateLock.writeLock();
            try {
                this.state = 0;
                Address oldSequencerAddr = this.sequencerAddr;
                this.sequencerAddr = (Address)((View)event.getArg()).getMembers().elementAt(0);
                if (this.addr.equals(this.sequencerAddr)) {
                    this.sequencerSeqID = -1;
                    if (oldSequencerAddr == null || !this.addr.equals(oldSequencerAddr)) {
                        Trace.info(PROT_NAME, "I'm the new sequencer");
                    }
                }
                this.seqID = -1;
                this._replayBcast();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.stateLock.writeUnlock();
                throw throwable;
            }
            {
                Object var4_6 = null;
                this.stateLock.writeUnlock();
                return true;
            }
        }
        catch (RWLock.IntException ex) {
            Trace.error(PROT_NAME, ex.getMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean _downBlockOk(Event event) {
        try {
            this.stateLock.writeLock();
            try {
                this.state = 2;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.stateLock.writeUnlock();
                throw throwable;
            }
            {
                Object var3_5 = null;
                this.stateLock.writeUnlock();
                return true;
            }
        }
        catch (RWLock.IntException ex) {
            Trace.error(PROT_NAME, ex.getMessage());
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean _downMsg(Event event) {
        try {
            block10: {
                boolean bl;
                block9: {
                    boolean bl2;
                    block8: {
                        this.stateLock.readLock();
                        try {
                            if (this.state == -1) {
                                Trace.error(PROT_NAME, "Discard msg in NULL_STATE");
                                boolean bl3 = false;
                                Object var4_5 = null;
                                this.stateLock.readUnlock();
                                return bl3;
                            }
                            if (this.state == 2) {
                                Trace.error(PROT_NAME, "Blocked, discard msg");
                                bl2 = false;
                                break block8;
                            }
                            Message msg = (Message)event.getArg();
                            if (msg.getDest() == null) {
                                this._sendBcastRequest(msg);
                                bl = false;
                                break block9;
                            }
                            msg = this._sendUcast(msg);
                            event.setArg(msg);
                            break block10;
                        }
                        catch (Throwable throwable) {
                            Object var4_8 = null;
                            this.stateLock.readUnlock();
                            throw throwable;
                        }
                    }
                    Object var4_6 = null;
                    this.stateLock.readUnlock();
                    return bl2;
                }
                Object var4_7 = null;
                this.stateLock.readUnlock();
                return bl;
            }
            Object var4_9 = null;
            this.stateLock.readUnlock();
            return true;
        }
        catch (RWLock.IntException ex) {
            Trace.error(PROT_NAME, ex.getMessage());
        }
        return true;
    }

    public void start() throws Exception {
        TimeScheduler timer;
        TimeScheduler timeScheduler = timer = this.stack != null ? this.stack.timer : null;
        if (timer == null) {
            throw new Exception("TOTAL.start(): timer is null");
        }
        this.reqTbl = new TreeMap();
        this.upTbl = new TreeMap();
        this.retransmitter = new AckSenderWindow(new Command(), this.AVG_RETRANSMIT_INTERVAL);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        try {
            this.stateLock.writeLock();
            try {
                this.state = -1;
                this.retransmitter.reset();
                this.reqTbl.clear();
                this.upTbl.clear();
                this.addr = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.stateLock.writeUnlock();
                throw throwable;
            }
            {
                Object var2_4 = null;
                this.stateLock.writeUnlock();
                return;
            }
        }
        catch (RWLock.IntException ex) {
            Trace.error("TOTAL.stop()", ex.getMessage());
        }
    }

    private final void _up(Event event) {
        switch (event.getType()) {
            case 10: {
                if (this._upBlock(event)) break;
                return;
            }
            case 1: {
                if (this._upMsg(event)) break;
                return;
            }
            case 8: {
                if (this._upSetLocalAddress(event)) break;
                return;
            }
            case 6: {
                if (this._upViewChange(event)) break;
                return;
            }
        }
        this.passUp(event);
    }

    private final void _down(Event event) {
        switch (event.getType()) {
            case 11: {
                if (this._downBlockOk(event)) break;
                return;
            }
            case 1: {
                if (this._downMsg(event)) break;
                return;
            }
        }
        this.passDown(event);
    }

    public String getName() {
        return this._getName();
    }

    public boolean setProperties(Properties properties) {
        return this._setProperties(properties);
    }

    public Vector requiredDownServices() {
        return this._requiredDownServices();
    }

    public Vector requiredUpServices() {
        return this._requiredUpServices();
    }

    public void up(Event event) {
        this._up(event);
    }

    public void down(Event event) {
        this._down(event);
    }

    private final /* synthetic */ void this() {
        this.MIN_RETRANSMIT_INTERVAL = 500L;
        this.AVG_RETRANSMIT_INTERVAL = new long[]{1000L, 2000L, 3000L, 4000L};
        this.stateLock = new RWLock();
        this.state = -1;
        this.addr = null;
        this.sequencerAddr = null;
        this.sequencerSeqID = -1;
        this.localSeqID = -1;
        this.seqID = -1;
    }

    public TOTAL() {
        this.this();
    }

    public static class Header
    extends org.javagroups.Header {
        public static final int NULL_TYPE = -1;
        public static final int REQ = 0;
        public static final int REP = 1;
        public static final int UCAST = 2;
        public static final int BCAST = 3;
        public int type;
        public long localSeqID;
        public long seqID;

        public String toString() {
            String typeName;
            StringBuffer buffer = new StringBuffer();
            buffer.append("[TOTAL.Header");
            switch (this.type) {
                case 0: {
                    typeName = "REQ";
                    break;
                }
                case 1: {
                    typeName = "REP";
                    break;
                }
                case 2: {
                    typeName = "UCAST";
                    break;
                }
                case 3: {
                    typeName = "BCAST";
                    break;
                }
                case -1: {
                    typeName = "NULL_TYPE";
                    break;
                }
                default: {
                    typeName = "";
                    break;
                }
            }
            buffer.append(", type=" + typeName);
            buffer.append(", localID=" + this.localSeqID);
            buffer.append(", seqID=" + this.seqID);
            buffer.append("]");
            return buffer.toString();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            out.writeLong(this.localSeqID);
            out.writeLong(this.seqID);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.localSeqID = in.readLong();
            this.seqID = in.readLong();
        }

        public Header() {
        }

        public Header(int type, long localSeqID, long seqID) {
            switch (type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.type = type;
                    break;
                }
                default: {
                    this.type = -1;
                    throw new IllegalArgumentException("type");
                }
            }
            this.localSeqID = localSeqID;
            this.seqID = seqID;
        }
    }

    private class Command
    implements AckSenderWindow.RetransmitCommand {
        public void retransmit(long seqNo, Message msg) {
            TOTAL.this._retransmitBcastRequest(seqNo);
        }
    }
}

