/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.service.lease;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.javagroups.JChannel;
import org.javagroups.log.Trace;
import org.javagroups.service.lease.Lease;
import org.javagroups.service.lease.LeaseDeniedException;
import org.javagroups.service.lease.LeaseFactoryClient;
import org.javagroups.service.lease.LeaseFactoryService;

public class LeaseFactoryClientTest
extends TestCase {
    public static final String SERVER_PROTOCOL_STACK = "UDP(mcast_addr=224.0.0.35;mcast_port=12345;ip_ttl=1;mcast_send_buf_size=150000;mcast_recv_buf_size=80000;down_thread=false):PING(timeout=500;num_initial_members=1;down_thread=false;up_thread=false):FD(down_thread=false;up_thread=false):VERIFY_SUSPECT(timeout=1500;down_thread=false;up_thread=false):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800;down_thread=false):FRAG(frag_size=4096;down_thread=false):UNICAST(timeout=5000):pbcast.STABLE(desired_avg_gossip=200;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=1000;shun=false;print_local_addr=false;down_thread=true;up_thread=true):pbcast.STATE_TRANSFER(down_thread=false)";
    public static final String CLIENT_PROTOCOL_STACK = "UDP(mcast_addr=224.0.0.36;mcast_port=56789;ip_ttl=1;mcast_send_buf_size=150000;mcast_recv_buf_size=80000;down_thread=false):FRAG(frag_size=4096;down_thread=false;up_thread=false):UNICAST(timeout=5000;use_gms=false)";
    protected JChannel svcServerChannel;
    protected JChannel svcClientChannel;
    protected JChannel clientChannel;
    protected LeaseFactoryService leaseFactory;
    protected LeaseFactoryClient leaseClient;
    static /* synthetic */ Class class$org$javagroups$service$lease$LeaseFactoryClientTest;

    protected void setUp() throws Exception {
        Trace.init();
        this.svcServerChannel = new JChannel(SERVER_PROTOCOL_STACK);
        this.svcServerChannel.setOpt(4, new Boolean(true));
        this.svcServerChannel.connect("server");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.svcClientChannel = new JChannel(CLIENT_PROTOCOL_STACK);
        this.svcClientChannel.connect("client");
        this.clientChannel = new JChannel(CLIENT_PROTOCOL_STACK);
        this.clientChannel.connect("client");
        this.leaseFactory = new LeaseFactoryService(this.svcServerChannel, this.svcClientChannel);
        this.leaseClient = new LeaseFactoryClient(this.clientChannel);
    }

    protected void tearDown() throws Exception {
        this.clientChannel.close();
        this.svcClientChannel.close();
        this.svcServerChannel.close();
    }

    public void test() throws Exception {
        System.out.println("testing obtaining lease...");
        Lease lease = this.leaseClient.newLease("1", "foo", 10000L, false);
        boolean bl = false;
        if (lease != null) {
            bl = true;
        }
        LeaseFactoryClientTest.assertTrue((String)"lease should be granted", (boolean)bl);
        System.out.println("lease was granted.");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException failure) {
            // empty catch block
        }
        try {
            Lease failure = this.leaseClient.newLease("1", "bar", 1000L, false);
            LeaseFactoryClientTest.assertTrue((String)"Lease should not be granted.", (boolean)false);
        }
        catch (LeaseDeniedException ex) {
            // empty catch block
        }
        System.out.println("trying to cancel lease...");
        this.leaseClient.cancelLease(lease);
        System.out.println("lease was canceled.");
        lease = this.leaseClient.newLease("1", "bar", 1000L, false);
        boolean bl2 = false;
        if (lease != null) {
            bl2 = true;
        }
        LeaseFactoryClientTest.assertTrue((String)"new lease should have been granted.", (boolean)bl2);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        System.out.println("renewing lease...");
        lease = this.leaseClient.renewLease(lease, 1000L, false);
        boolean bl3 = false;
        if (lease != null) {
            bl3 = true;
        }
        LeaseFactoryClientTest.assertTrue((String)"lease should have been renewed", (boolean)bl3);
        System.out.println("lease renewed.");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        try {
            lease = this.leaseClient.renewLease(lease, 1000L, false);
            LeaseFactoryClientTest.assertTrue((String)"lease should be expired", (boolean)false);
        }
        catch (LeaseDeniedException leaseDeniedException) {
            // empty catch block
        }
        lease = this.leaseClient.newLease("1", "bar", 1000L, false);
        this.leaseClient.cancelLease(lease);
    }

    public static void main(String[] args) {
        String[] stringArray = new String[1];
        Class clazz = class$org$javagroups$service$lease$LeaseFactoryClientTest;
        if (clazz == null) {
            clazz = class$org$javagroups$service$lease$LeaseFactoryClientTest = LeaseFactoryClientTest.class$("[Lorg.javagroups.service.lease.LeaseFactoryClientTest;", false);
        }
        stringArray[0] = clazz.getName();
        String[] testCaseName = stringArray;
        TestRunner.main((String[])testCaseName);
        System.out.println("press key to return");
        try {
            System.in.read();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public LeaseFactoryClientTest(String testName) {
        super(testName);
    }
}

