/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.stack;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.log.Trace;
import org.javagroups.stack.Interval;
import org.javagroups.stack.IpAddress;
import org.javagroups.util.TimeScheduler;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Retransmitter {
    private static final long SEC = 1000L;
    private static long[] RETRANSMIT_TIMEOUTS = new long[]{2000L, 3000L, 5000L, 8000L};
    private static final long SUSPEND_TIMEOUT = 2000L;
    private Address sender;
    private Vector msgs;
    private RetransmitCommand cmd;
    private boolean retransmitter_owned;
    private TimeScheduler retransmitter;

    public void setRetransmitTimeouts(long[] timeouts) {
        if (timeouts != null) {
            RETRANSMIT_TIMEOUTS = timeouts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(long first_seqno, long last_seqno) {
        if (first_seqno > last_seqno) {
            long tmp = first_seqno;
            first_seqno = last_seqno;
            last_seqno = tmp;
        }
        Vector vector = this.msgs;
        synchronized (vector) {
            Entry e = new Entry(first_seqno, last_seqno, RETRANSMIT_TIMEOUTS);
            this.msgs.addElement(e);
            this.retransmitter.add(e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(long seqno) {
        Vector vector = this.msgs;
        synchronized (vector) {
            int i = 0;
            while (i < this.msgs.size()) {
                Entry e = (Entry)this.msgs.elementAt(i);
                Entry entry = e;
                synchronized (entry) {
                    if (seqno < e.low || seqno > e.high) {
                        // MONITOREXIT @DISABLED, blocks:[1, 2, 3, 6, 8] lbl15 : MonitorExitStatement: MONITOREXIT : var7_5
                        ++i;
                        continue;
                    }
                    e.remove(seqno);
                    if (e.low > e.high) {
                        e.cancel();
                        this.msgs.removeElementAt(i);
                    }
                    break;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset() {
        Vector vector = this.msgs;
        synchronized (vector) {
            int i = 0;
            while (true) {
                if (i >= this.msgs.size()) {
                    this.msgs.clear();
                    return;
                }
                Entry entry = (Entry)this.msgs.get(i);
                entry.cancel();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        Vector vector = this.msgs;
        synchronized (vector) {
            block7: {
                block6: {
                    if (!this.retransmitter_owned) break block6;
                    try {
                        this.retransmitter.stop();
                    }
                    catch (InterruptedException ex) {
                        Trace.error("Retransmiter.stop()", Util.printStackTrace(ex));
                    }
                    break block7;
                }
                int i = 0;
                while (i < this.msgs.size()) {
                    Entry entry = (Entry)this.msgs.get(i);
                    entry.cancel();
                    ++i;
                }
            }
            this.msgs.clear();
            return;
        }
    }

    public String toString() {
        return this.msgs.size() + " messages to retransmit: (" + this.msgs.toString() + ')';
    }

    private final void init(Address sender, RetransmitCommand cmd, TimeScheduler sched, boolean sched_owned) {
        this.sender = sender;
        this.cmd = cmd;
        this.retransmitter_owned = sched_owned;
        this.retransmitter = sched;
    }

    public static void main(String[] args) {
        try {
            IpAddress sender = new IpAddress("localhost", 5555);
            Retransmitter xmitter = new Retransmitter(sender, new MyXmitter());
            xmitter.setRetransmitTimeouts(new long[]{1000L, 2000L, 4000L, 8000L});
            xmitter.add(1L, 10L);
            xmitter.remove(1L);
            xmitter.remove(2);
            xmitter.remove(4);
            Util.sleep(3000L);
            xmitter.remove(3);
            Util.sleep(1000L);
            xmitter.remove(10L);
            xmitter.remove(8L);
            xmitter.remove(6L);
            xmitter.remove(7L);
            xmitter.remove(9L);
            xmitter.remove(5);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static void sleep(long timeout) {
        Util.sleep(timeout);
    }

    private final /* synthetic */ void this() {
        this.sender = null;
        this.msgs = new Vector();
        this.cmd = null;
        this.retransmitter = null;
    }

    public Retransmitter(Address sender, RetransmitCommand cmd, TimeScheduler sched) {
        this.this();
        this.init(sender, cmd, sched, false);
    }

    public Retransmitter(Address sender, RetransmitCommand cmd) {
        this.this();
        this.init(sender, cmd, new TimeScheduler(2000L), true);
    }

    private static abstract class Task
    implements TimeScheduler.Task {
        private Interval intervals;
        private boolean cancelled;

        public long nextInterval() {
            return this.intervals.next();
        }

        public boolean cancelled() {
            return this.cancelled;
        }

        public void cancel() {
            this.cancelled = true;
        }

        protected Task(long[] intervals) {
            this.intervals = new Interval(intervals);
            this.cancelled = false;
        }
    }

    private class Entry
    extends Task {
        public long low;
        public long high;
        public List list;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void remove(long seqno) {
            long[] bounds = null;
            Entry entry = this;
            synchronized (entry) {
                int i = 0;
                while (i < this.list.size() && (seqno < (bounds = (long[])this.list.get(i))[0] || seqno > bounds[1])) {
                    ++i;
                }
                if (i == this.list.size()) {
                    return;
                }
                if (seqno == bounds[0]) {
                    if (bounds[0] == bounds[1]) {
                        this.list.remove(i);
                    } else {
                        bounds[0] = bounds[0] + 1L;
                    }
                    if (i == 0) {
                        this.low = this.list.size() == 0 ? this.high + 1L : ((long[])this.list.get(i))[0];
                    }
                } else if (seqno == bounds[1]) {
                    bounds[1] = bounds[1] - 1L;
                    if (i == this.list.size() - 1) {
                        this.high = ((long[])this.list.get(i))[1];
                    }
                } else {
                    long[] newBounds = new long[]{seqno + 1L, bounds[1]};
                    bounds[1] = seqno - 1L;
                    this.list.add(i + 1, newBounds);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Entry entry = this;
            synchronized (entry) {
                int i = 0;
                while (i < this.list.size()) {
                    long[] bounds = (long[])this.list.get(i);
                    Retransmitter.this.cmd.retransmit(bounds[0], bounds[1], Retransmitter.this.sender);
                    ++i;
                }
                return;
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.low == this.high) {
                sb.append(this.low);
            } else {
                sb.append(this.low).append(':').append(this.high);
            }
            return sb.toString();
        }

        public Entry(long low, long high, long[] intervals) {
            super(intervals);
            this.low = low;
            this.high = high;
            this.list = new ArrayList();
            this.list.add(new long[]{low, high});
        }
    }

    static class MyXmitter
    implements RetransmitCommand {
        public void retransmit(long first_seqno, long last_seqno, Address sender) {
            System.out.println("-- " + new Date() + ": retransmit(" + first_seqno + ", " + last_seqno + ", " + sender + ')');
        }

        MyXmitter() {
        }
    }

    public static interface RetransmitCommand {
        public void retransmit(long var1, long var3, Address var5);
    }
}

