/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import org.javagroups.Address;
import org.javagroups.Message;
import org.javagroups.stack.IpAddress;
import org.javagroups.stack.NakReceiverWindow;
import org.javagroups.stack.Retransmitter;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NakReceiverWindowStressTest
implements Retransmitter.RetransmitCommand {
    NakReceiverWindow win;
    Address sender;
    int num_msgs;
    int prev_value;
    double discard_prob;
    long start;
    long stop;
    boolean trace;
    boolean debug;

    public void retransmit(long first_seqno, long last_seqno, Address sender) {
        long i = first_seqno;
        while (i <= last_seqno) {
            if (this.debug) {
                this.out("-- xmit: " + i);
            }
            this.win.add(i, new Message(null, sender, new Long(i)));
            ++i;
        }
    }

    public void start() {
        System.out.println("num_msgs=" + this.num_msgs + "\ndiscard_prob=" + this.discard_prob);
        this.sender = new IpAddress("localhost", 5555);
        this.win = new NakReceiverWindow(this.sender, this, 1L);
        this.start = System.currentTimeMillis();
        this.sendMessages(this.num_msgs);
    }

    void sendMessages(int num_msgs) {
        Message msg;
        long i = 1L;
        while (i <= (long)num_msgs) {
            if (Util.tossWeightedCoin(this.discard_prob) && i <= (long)num_msgs) {
                if (this.debug) {
                    this.out("-- discarding " + i);
                }
            } else {
                if (this.debug) {
                    this.out("-- adding " + i);
                }
                this.win.add(i, new Message(null, null, new Long(i)));
                if (this.trace && i % 100L == 0L) {
                    System.out.println("-- added " + i);
                }
                while ((msg = this.win.remove()) != null) {
                    this.processMessage(msg);
                }
            }
            ++i;
        }
        while (true) {
            if ((msg = this.win.remove()) != null) {
                this.processMessage(msg);
                continue;
            }
            Util.sleep(50L);
        }
    }

    void processMessage(Message msg) {
        long i = (Long)msg.getObject();
        if ((long)(this.prev_value + 1) != i) {
            System.err.println("** processMessage(): removed seqno (" + i + ") is not 1 greater than previous value (" + this.prev_value + ')');
            System.exit(0);
        }
        ++this.prev_value;
        if (this.trace && i % 100L == 0L) {
            System.out.println("Removed " + i);
        }
        if (i == (long)this.num_msgs) {
            this.stop = System.currentTimeMillis();
            System.out.println("Inserting and removing " + this.num_msgs + " messages into NakReceiverWindow took " + (this.stop - this.start) + "ms");
            System.out.println("<enter> to terminate");
            try {
                System.in.read();
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
            System.exit(0);
        }
    }

    void out(String msg) {
        System.out.println(msg);
    }

    public static void main(String[] args) {
        int num_msgs = 1000;
        double discard_prob = 0.1;
        boolean trace = false;
        boolean debug = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-help")) {
                NakReceiverWindowStressTest.help();
                return;
            }
            if (args[i].equals("-num_msgs")) {
                num_msgs = new Integer(args[++i]);
            } else if (args[i].equals("-discard")) {
                discard_prob = new Double(args[++i]);
            } else if (args[i].equals("-trace")) {
                trace = true;
            } else if (args[i].equals("-debug")) {
                debug = true;
            }
            ++i;
        }
        NakReceiverWindowStressTest test = new NakReceiverWindowStressTest(num_msgs, discard_prob, trace, debug);
        test.start();
    }

    static void help() {
        System.out.println("NakReceiverWindowStressTest [-help] [-num_msgs <number>] [-discard <probability>] [-trace]");
    }

    private final /* synthetic */ void this() {
        this.win = null;
        this.sender = null;
        this.num_msgs = 1000;
        this.prev_value = 0;
        this.discard_prob = 0.1;
        this.trace = false;
        this.debug = false;
    }

    public NakReceiverWindowStressTest(int num_msgs, double discard_prob, boolean trace, boolean debug) {
        this.this();
        this.num_msgs = num_msgs;
        this.discard_prob = discard_prob;
        this.trace = trace;
    }
}

