/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.util;

import org.javagroups.log.Trace;
import org.javagroups.util.Queue;
import org.javagroups.util.QueueClosedException;
import org.javagroups.util.ReusableThread;
import org.javagroups.util.SchedulerListener;
import org.javagroups.util.ThreadPool;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Scheduler
implements Runnable {
    Queue queue;
    Thread sched_thread;
    Task current_task;
    ThreadPool pool;
    int NUM_THREADS;
    final int WAIT_FOR_THREAD_AVAILABILITY = 3000;
    final int THREAD_JOIN_TIMEOUT = 1000;
    SchedulerListener listener;
    boolean trace;

    public void setListener(SchedulerListener l) {
        this.listener = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (this.sched_thread != null) {
            if (this.queue.closed()) break;
            try {
                block21: {
                    block20: {
                        this.current_task = (Task)this.queue.peek();
                        if (this.current_task == null) {
                            Trace.error("Scheduler.run()", "current task is null, queue.size()=" + this.queue.size() + ", queue.closed()=" + this.queue.closed() + ", continuing");
                            continue;
                        }
                        if (!this.current_task.suspended) break block20;
                        this.current_task.suspended = false;
                        this.current_task.thread.resume();
                        if (this.listener != null) {
                            this.listener.resumed(this.current_task.target);
                        }
                        ** GOTO lbl28
                    }
                    if (this.current_task.thread != null) ** GOTO lbl25
                    this.current_task.thread = this.pool.getThread();
                    if (this.current_task.thread == null) {
                        Util.sleep(3000L);
                        continue;
                    }
                    if (this.listener != null) {
                        this.listener.started(this.current_task.target);
                    }
                    if (!this.current_task.thread.assignTask(this.current_task.target)) continue;
                    break block21;
lbl25:
                    // 1 sources

                    if (this.listener != null) {
                        this.listener.started(this.current_task.target);
                    }
                    if (!this.current_task.thread.assignTask(this.current_task.target)) continue;
                }
                if (this.sched_thread.isInterrupted()) {
                    this.sched_thread.interrupt();
                }
                var1_1 = this.current_task.thread;
                synchronized (var1_1) {
                    while (true) {
                        if (this.current_task.thread.done() || this.current_task.thread.suspended) {
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 8, 9, 13] lbl39 : MonitorExitStatement: MONITOREXIT : var1_1
                            if (this.listener == null) break;
                            this.listener.stopped(this.current_task.target);
                            break;
                        }
                        this.current_task.thread.wait();
                    }
                }
                this.queue.removeElement(this.current_task);
            }
            catch (InterruptedException interrupted) {
                if (this.sched_thread == null || this.queue.closed()) break;
                if (this.current_task.thread != null) {
                    this.current_task.thread.suspend();
                    if (this.listener != null) {
                        this.listener.suspended(this.current_task.target);
                    }
                    this.current_task.suspended = true;
                }
                v1 = this;
                v1.sched_thread.interrupted();
            }
            catch (QueueClosedException ex) {
                return;
            }
            catch (Throwable ex) {
                Trace.error("Scheduler.run()", "exception=" + Util.print(ex));
            }
        }
        if (Trace.trace) {
            Trace.info("Scheduler.run()", "scheduler thread treminated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addPrio(Runnable task) {
        Task new_task = new Task(task);
        boolean do_interrupt = false;
        try {
            block6: {
                Queue queue = this.queue;
                synchronized (queue) {
                    block5: {
                        if (this.queue.size() != 0) break block5;
                        this.queue.add(new_task);
                        break block6;
                    }
                    this.queue.addAtHead(new_task);
                    do_interrupt = true;
                }
            }
            if (!do_interrupt) return;
            this.sched_thread.interrupt();
            return;
        }
        catch (Throwable e) {
            Trace.error("Scheduler.addPrio()", "exception=" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(Runnable task) {
        Task new_task = new Task(task);
        try {
            Queue queue = this.queue;
            synchronized (queue) {
                this.queue.add(new_task);
                return;
            }
        }
        catch (Exception e) {
            Trace.error("Scheduler.add()", "exception=" + e);
        }
    }

    public void start() {
        if (this.queue.closed()) {
            this.queue.reset();
        }
        if (this.sched_thread == null) {
            this.pool = new ThreadPool(this.NUM_THREADS);
            this.sched_thread = new Thread((Runnable)this, "Scheduler main thread");
            this.sched_thread.setDaemon(true);
            this.sched_thread.start();
        }
    }

    public void stop() {
        Thread tmp = null;
        this.queue.close(false);
        if (this.sched_thread != null && this.sched_thread.isAlive()) {
            tmp = this.sched_thread;
            this.sched_thread = null;
            tmp.interrupt();
            try {
                tmp.join(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tmp.isAlive()) {
                Trace.error("Scheduler.stop()", "scheduler thread is still not dead  !!!");
            }
        }
        this.sched_thread = null;
        if (this.pool != null) {
            this.pool.destroy();
            this.pool = null;
        }
    }

    private final /* synthetic */ void this() {
        this.queue = new Queue();
        this.sched_thread = null;
        this.current_task = null;
        this.pool = null;
        this.NUM_THREADS = 128;
        this.WAIT_FOR_THREAD_AVAILABILITY = 3000;
        this.THREAD_JOIN_TIMEOUT = 1000;
        this.listener = null;
        this.trace = false;
    }

    public Scheduler() {
        this.this();
    }

    public Scheduler(int num_threads) {
        this.this();
        this.NUM_THREADS = num_threads;
    }

    public Scheduler(int num_threads, boolean trace) {
        this(num_threads);
        this.trace = trace;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Task {
        ReusableThread thread;
        Runnable target;
        boolean suspended;

        public String toString() {
            return "[thread=" + this.thread + ", target=" + this.target + ", suspended=" + this.suspended + ']';
        }

        private final /* synthetic */ void this() {
            this.thread = null;
            this.target = null;
            this.suspended = false;
        }

        Task(Runnable target) {
            this.this();
            this.target = target;
        }
    }
}

