/* (C) 2004-2006 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Igor Kravtchenko <igor@tsarevitch.org>
 *
 */

#include <UnitTest++.h>

#include <osgCal/TextureLayersFlatten>

#include <osg/BlendFunc>

#ifdef WIN32
#undef main
#endif

int main(int argc, char *argv[])
{
	return UnitTest::RunAllTests();
}

class SetupAlphaPartPassFixture : public osgCal::TextureLayersFlatten {
};

TEST_FIXTURE(SetupAlphaPartPassFixture, SetupAlphaPartPass)
{
	int i;
	osg::Geometry *geom;
	osg::StateSet *ss;
	osg::ColorMask *cmask;
	osg::BlendFunc *bf;
	osg::TexEnvCombine *combiner;

	osg::ref_ptr<osg::Group> on = new osg::Group();

	osg::ref_ptr<osg::Image> imgToPutAlphaOn = new osg::Image();
	unsigned char *imgToPutAlphaOnData = (unsigned char*) malloc(512*512*3);
	for (i = 0; i < 512*512*3; i += 3) {
		imgToPutAlphaOnData[i] = 128;
		imgToPutAlphaOnData[i+1] = 128;
		imgToPutAlphaOnData[i+2] = 128;
	}
	imgToPutAlphaOn->setImage(512, 512, 1, GL_RGB, GL_RGB, GL_UNSIGNED_BYTE, imgToPutAlphaOnData, osg::Image::USE_MALLOC_FREE);
	osg::ref_ptr<osg::Texture2D> textureToPutAlphaOn = new osg::Texture2D(imgToPutAlphaOn.get());

	osg::ref_ptr<osg::Image> alphaImg = new osg::Image();
	unsigned char *alphaImgData = (unsigned char*) malloc(512*512);
	for (i = 0; i < 512*512; i++)
		alphaImgData[i] = 128;
	alphaImg->setImage(512, 512, 1, GL_ALPHA, GL_ALPHA, GL_UNSIGNED_BYTE, alphaImgData, osg::Image::USE_MALLOC_FREE);
	this->alphaPart_ = new osg::Texture2D(alphaImg.get());

	this->setupAlphaPartPass(on.get(), textureToPutAlphaOn.get());

	// pass 1
	CHECK( geom = dynamic_cast<osg::Geometry*>(this->quads_[2]->getGeode()->getDrawable(0)) );
	CHECK( ss = geom->getStateSet() );

	CHECK( bf = dynamic_cast<osg::BlendFunc*>(ss->getAttribute(osg::StateAttribute::BLENDFUNC)) );
	CHECK_EQUAL(GL_ONE, bf->getSource());
	CHECK_EQUAL(GL_ZERO, bf->getDestination());

	// pass 2
	CHECK( geom = dynamic_cast<osg::Geometry*>(this->quads_[3]->getGeode()->getDrawable(0)) );
	CHECK( ss = geom->getStateSet() );

	CHECK( bf = dynamic_cast<osg::BlendFunc*>(ss->getAttribute(osg::StateAttribute::BLENDFUNC)) );
	CHECK_EQUAL(GL_ONE, bf->getSource());
	CHECK_EQUAL(GL_ZERO, bf->getDestination());

	CHECK( cmask = dynamic_cast<osg::ColorMask*>(ss->getAttribute(osg::StateAttribute::COLORMASK)) );
	CHECK_EQUAL(false, cmask->getRedMask());
	CHECK_EQUAL(false, cmask->getGreenMask());
	CHECK_EQUAL(false, cmask->getBlueMask());
	CHECK_EQUAL(true, cmask->getAlphaMask());

	CHECK( combiner = dynamic_cast<osg::TexEnvCombine*>(ss->getTextureAttribute(0, osg::StateAttribute::TEXENV)) );
}
