
/******************************************************************************
**
**  Copyright (C) 2005 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/******************************************************************************
**
**    File:      filter_sticky.c
**    Author:    Brian Wotring
**
**    Date:      March 14, 2002.
**    Project:   osiris
**
******************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>

#include <sys/stat.h>

#include "utilities.h"
#include "scan_record.h"
#include "filter.h"

#ifdef WIN32

osi_bool filter_sticky( const char *file_path, FILTER_CONTEXT *context )
{
    return FALSE;
}

#else

osi_bool filter_sticky( const char *file_path, FILTER_CONTEXT *context )
{
    if( ( context != NULL ) && ( context->file_stats != NULL ) )
    {
        if( context->file_stats->st_mode & S_ISVTX )
        {
            return TRUE;
        }
    }

    return FALSE;
}

#endif

