
/******************************************************************************
**
**  Copyright (C) 2005 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/******************************************************************************
**
**    File:      list.h
**    Author:    Brian Wotring
**
**    Date:      June 22, 2001.
**    Project:   osiris
**
******************************************************************************/

#ifndef LIST_H
#define LIST_H


/* basic linked list structure.  there is always a dummy header */

typedef struct node
{
   void *data;
   struct node *next;

} node;

typedef node * osi_list;

osi_list list_new();

void list_destroy( osi_list head );
void list_destroy_with_function( osi_list head, void (*data_destroy)(void *) );

osi_bool list_add( osi_list head, void *new_data );
osi_bool list_remove_index( osi_list head, int index );

void * list_get_index( osi_list head, int index );
int list_get_size( osi_list head );

osi_list list_get_first_node( osi_list head );
osi_list list_get_next_node( osi_list head );

void list_dump( osi_list head );


#endif


