
/******************************************************************************
**
**  Copyright (C) 2005 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

#ifndef HAVE_STRCASESTR


char *strcasestr( const char *s1, const char *s2 )
{
    char *cp = (char*) s1;
    char *s, *t;
    char l, r;

    while( *cp )
    {
        s = cp;
        t = (char*)s2;

        while( (*s) && (*t) )
        {
            l = ( (*s >= 'A') && (*s <= 'Z') ) ?  *s + 'a' - 'A' : *s;
            r = ( (*t >= 'A') && (*t <= 'Z') ) ?  *t + 'a' - 'A' : *t;

            if( l != r )
            {
                break;
            }
        
            s++;
            t++;
        }

        if( (*t) == '\0' )
        {
            return cp;
        }

        cp++;
    }

    return 0;
}

#endif
