
/******************************************************************************
**
**  Copyright (C) 2005 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/*****************************************************************************
**
**    File:      osirisdb.h
**    Author:    Brian Wotring
**
**    Date:      May 14, 2002
**    Project:   osiris
**
*****************************************************************************/

#ifndef OSIRISDB_H
#define OSIRISDB_H


#define MAX_DB_NAME_LENGTH  		MAX_PATH_LENGTH
#define MAX_DB_RECORD_KEY_LENGTH	MAX_PATH_LENGTH

#define MAX_SYSTEM_RECORD_SIZE      1024          

#define OSI_DB_PERMISSIONS	    	0600
#define OSI_DB_TYPE			        DB_BTREE


/* database names, each osiris db file contains these three databases. */

#define OSI_DB_NAME_HEADER		"header"
#define OSI_DB_NAME_ERRORS		"errors"
#define OSI_DB_NAME_RECORDS		"records"
#define OSI_DB_NAME_SYSTEM      "system"

/* key to store error messages with. */

#define OSI_DB_ERROR_KEY		"error"

/* keys for header fields in the header database. */

#define OSI_DB_HEADER_ITEM_COMPLETE	    "complete"
#define OSI_DB_HEADER_ITEM_RECORD_TYPE	"record-type"
#define OSI_DB_HEADER_ITEM_SCAN_RESULTS	"scan-results"
#define OSI_DB_HEADER_ITEM_CONFIG_DATA	"config-data"
#define OSI_DB_HEADER_ITEM_CONFIG_NAME	"config-name"
#define OSI_DB_HEADER_ITEM_CONFIG_ID	"config-id"
#define OSI_DB_HEADER_ITEM_HOST		    "host"
#define OSI_DB_HEADER_ITEM_NAME         "name"
#define OSI_DB_HEADER_ITEM_NOTES        "notes"


#define OSI_DB_READ			    0x01
#define OSI_DB_WRITE			0x02

#define MAX_DB_PASSPHRASE_LENGTH    256


/* structure used for databases.  this is for scan databases */
/* as well as generic databases such as the auth db.         */

typedef struct OSI_DB
{
    DB_ENV *env;

    DB *header;
    DB *errors;
    DB *records;
    DB *system;

    DBC *r_cursor;
    DBC *e_cursor;
    DBC *s_cursor;
    
    osi_bool open;
    long error_id;

    char path[MAX_PATH_LENGTH];
    OSI_SCAN_CONFIG *cfg;

    char passphrase[MAX_DB_PASSPHRASE_LENGTH];
    
} OSI_DB;

typedef struct OSI_DB_HEADER
{
    osi_uint64 complete;
    osi_uint64 record_type;
    
    OSI_SCAN_RESULTS_1 scan_results;  
    char *config_data;
    
    char name[MAX_PATH_LENGTH];

    char config_name[MAX_CONFIG_NAME_LENGTH];
    char config_id[MAX_CONFIG_ID_LENGTH];
    char host[MAX_HOST_BRIEF_NAME_LENGTH];
    char notes[MAX_DB_NOTES_LENGTH];
    
} OSI_DB_HEADER;


/* generic database functions. */

int osi_db_create( OSI_DB *db );
int osi_db_open( OSI_DB *db, int mode );

int osi_db_close( OSI_DB *db );
int osi_db_delete( OSI_DB *db );

int osi_db_truncate( OSI_DB *db );
long osi_db_get_record_count( OSI_DB *db );

int osi_db_get_record_with_name( OSI_DB *db, void *record, int record_size,
                                 char *name );

int osi_db_store_record( OSI_DB *db, void *record, int record_size );

int osi_db_delete_record_with_name( OSI_DB *db, char *name );

int osi_db_get_first_record( OSI_DB *db, void *record, int record_size,
                             int *result_size );

int osi_db_get_next_record( OSI_DB *db, void *record, int record_size,
                            int *result_size );

int osi_db_store_data_with_key( DB *db, void *data, int data_size, char *key );

int osi_db_get_data_with_key( DB *db, void *data, int max_data,
                              int *result_size, char *key );

/* scan record related db functions. */

int osi_scan_db_create( OSI_DB *db );
int osi_scan_db_open( OSI_DB *db, int mode );

int osi_scan_db_close( OSI_DB *db );
int osi_scan_db_delete( OSI_DB *db );

int osi_scan_db_store_error( OSI_DB *db, OSI_ERROR *error );
int osi_scan_db_store_record( OSI_DB *db, void *record );
int osi_scan_db_store_system( OSI_DB *db, void *system );

int osi_scan_db_store_header_item( OSI_DB *db, char *item, void *data,
                                   int data_size );

int osi_scan_db_get_header_item( OSI_DB *db, char *item, void *data,
                                 int max_data, int *result_size );

int osi_scan_db_get_first_record( OSI_DB *db, void *record, int record_size );
int osi_scan_db_get_next_record( OSI_DB *db, void *record, int record_size );

int osi_scan_db_get_record_with_name( OSI_DB *db, void *record, int record_size,
                                      char *name );

int osi_scan_db_get_first_system( OSI_DB *db, void *system, int system_size );
int osi_scan_db_get_next_system( OSI_DB *db, void *system, int system_size );

int osi_scan_db_get_system_with_name( OSI_DB *db, void *system, int system_size,
                                      char *name );

int osi_scan_db_get_first_error( OSI_DB *db, void *error, int max_size,
                                 int *result_size );

int osi_scan_db_get_next_error( OSI_DB *db, void *error, int max_size,
                                int *result_size );

long osi_scan_db_get_error_count( OSI_DB *db );
long osi_scan_db_get_record_count( OSI_DB *db );
long osi_scan_db_get_system_count( OSI_DB *db );

int osi_scan_db_get_record_type( OSI_DB *db );

void osi_wrap_scan_db_header( OSI_DB_HEADER *header );
void osi_unwrap_scan_db_header( OSI_DB_HEADER *header );

void print_database_header( OSI_DB *db );
void print_database_errors( OSI_DB *db );
void print_database_file_names( OSI_DB *db );
void print_database_file_details( OSI_DB *db, const char *file_path );
void print_database_system_names( OSI_DB *db );

#endif
