
/******************************************************************************
**
**  Copyright (C) 2005 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/*****************************************************************************
**
**  File:    config_brief.c
**  Date:    August 18, 2002
**
**  Author:  Brian Wotring
**
**  Purpose: structure representing a scanning config that can be transported
**           in a message.
**
******************************************************************************/

#include "libosirism.h"

void wrap_config_brief( OSI_CONFIG_BRIEF *config )
{
    if( config != NULL )
    {
        config->valid = OSI_HTONLL( config->valid );

    }
}

void unwrap_config_brief( OSI_CONFIG_BRIEF *config )
{
    if( config != NULL )
    {
        config->valid = OSI_NTOHLL( config->valid );
    }
}
