
/******************************************************************************
**
**  Copyright (C) 2005 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/*****************************************************************************
**
**  File:    database_brief.c
**  Date:    August 18, 2002
**
**  Author:  Brian Wotring
**
**  Purpose: structure representing a db that can be transported in a message.
**
******************************************************************************/

#include "libosirism.h"

void wrap_database_brief( OSI_DATABASE_BRIEF *database )
{
    if( database != NULL )
    {
        database->complete     = OSI_HTONLL( database->complete );
        database->error_count  = OSI_HTONLL( database->error_count );
        database->record_count = OSI_HTONLL( database->record_count );

        wrap_scan_results( &(database->scan_results ) );
    }
}

void unwrap_database_brief( OSI_DATABASE_BRIEF *database )
{
    if( database != NULL )
    {
        database->complete     = OSI_NTOHLL( database->complete );
        database->error_count  = OSI_NTOHLL( database->error_count );
        database->record_count = OSI_NTOHLL( database->record_count );
        
        unwrap_scan_results( &(database->scan_results ) );
    }
}
