
/******************************************************************************
**
**  Copyright (C) 2005 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

#include "libosiris.h"
#include "logging.h"
#include "scanner.h"
#include "modules.h"

void execute_module( const char *module_name, SCANNER *scanner )
{
    int index;

    if( module_name == NULL )
    {
        log_error( "configuration block was null or invalid, skipping." );
        return;
    }

    for( index = 0; active_modules[index].name; index++ )
    {
        if( strcmp( module_name, active_modules[index].name ) == 0 )
        {
            if( active_modules[index].module_function != NULL )
            {
                log_info( "launching module: (%s)", module_name );
                active_modules[index].module_function( scanner );

                return;
            }

            else
            {
                log_error( "failed to execute module: (%s).",
                           module_name );
            }
        }
    }

    log_error( "agent does not support module: (%s).", module_name );
}
