## Copyright 2009 Intel Corporation
## SPDX-License-Identifier: Apache-2.0

set(COMPONENT_NAME ispc)

set(COMPONENT_PATH ${INSTALL_DIR_ABSOLUTE})
if (INSTALL_IN_SEPARATE_DIRECTORIES)
  set(COMPONENT_PATH ${INSTALL_DIR_ABSOLUTE}/${COMPONENT_NAME})
endif()

set(ISPCRT_LIBDIR "lib")
if (APPLE)
  set(ISPC_OSSUFFIX "macOS.${CMAKE_SYSTEM_PROCESSOR}.tar.gz")
elseif(WIN32)
  set(ISPC_OSSUFFIX "windows.zip")
else()
  if (${CMAKE_SYSTEM_PROCESSOR} MATCHES "arm64|aarch64")
    set(ISPC_OSSUFFIX "linux.aarch64.tar.gz")
  else()
    set(ISPC_OSSUFFIX "linux-oneapi.tar.gz")
    set(ISPCRT_LIBDIR "lib64")
  endif()
endif()

set(ISPC_URL "https://github.com/ispc/ispc/releases/download/v${ISPC_VERSION}/ispc-v${ISPC_VERSION}-${ISPC_OSSUFFIX}")

if (ISPC_HASH)
  set(ISPC_URL_HASH URL_HASH SHA256=${ISPC_HASH})
endif()

set(ISPC_PATH "${COMPONENT_PATH}/bin/ispc${CMAKE_EXECUTABLE_SUFFIX}")

if (BUILD_ISPCRT_FROM_SOURCE)
  set(ISPC_INSTALL copy_if_different <SOURCE_DIR>/bin/ispc${CMAKE_EXECUTABLE_SUFFIX} ${ISPC_PATH})
else()
  set(ISPC_INSTALL copy_directory <SOURCE_DIR>/ ${COMPONENT_PATH})
endif()

ExternalProject_Add(${COMPONENT_NAME}
  PREFIX ${COMPONENT_NAME}
  STAMP_DIR ${COMPONENT_NAME}/stamp
  SOURCE_DIR ${COMPONENT_NAME}/src
  BINARY_DIR ${COMPONENT_NAME}
  URL ${ISPC_URL}
  ${ISPC_URL_HASH}
  CONFIGURE_COMMAND ""
  BUILD_COMMAND ""
  INSTALL_COMMAND "${CMAKE_COMMAND}" -E ${ISPC_INSTALL}
  BUILD_ALWAYS OFF
)


if (BUILD_ISPCRT_FROM_SOURCE)
  set(COMPONENT_NAME ispcrt)
  string(REGEX REPLACE "(^[0-9]+\.[0-9]+\.[0-9]+$)" "v\\1" ISPCRT_ARCHIVE ${ISPC_VERSION})
  
  set(ISPCRT_BRANCH "${ISPCRT_ARCHIVE}" CACHE STRING "Which branch of ISPCRT to build" )
  set(ISPCRT_URL "https://github.com/ispc/ispc/archive/refs/tags/${ISPCRT_ARCHIVE}.zip"
    CACHE STRING "Location to clone ISPCRT source from")
  
  string(REGEX MATCH ".*\.zip$" ZIP_FILENAME ${ISPCRT_URL})
  if (ZIP_FILENAME)
    set(ISPCRT_CLONE_URL URL ${ISPCRT_URL})
    if (ISPC_SOURCE_HASH)
      set(ISPCRT_URL_HASH URL_HASH SHA256=${ISPC_SOURCE_HASH})
    endif()
  else()
    set(ISPCRT_CLONE_URL GIT_REPOSITORY ${ISPCRT_URL} GIT_TAG ${ISPCRT_BRANCH})
  endif()
  
  ExternalProject_Add(${COMPONENT_NAME}
    PREFIX ${COMPONENT_NAME}
    STAMP_DIR ${COMPONENT_NAME}/stamp
    SOURCE_DIR ${COMPONENT_NAME}/src
    BINARY_DIR ${COMPONENT_NAME}/build
    LIST_SEPARATOR |
    SOURCE_SUBDIR "ispcrt"
    ${ISPCRT_CLONE_URL}
    ${ISPCRT_URL_HASH}
    CMAKE_ARGS
      -DCMAKE_PREFIX_PATH=${CMAKE_PREFIX_PATH}
      -DCMAKE_CXX_COMPILER=${CMAKE_CXX_COMPILER}
      -DCMAKE_TOOLCHAIN_FILE=${CMAKE_TOOLCHAIN_FILE}
      -DCMAKE_INSTALL_PREFIX:PATH=${COMPONENT_PATH}
      -DCMAKE_INSTALL_INCLUDEDIR=${CMAKE_INSTALL_INCLUDEDIR}
      -DCMAKE_INSTALL_LIBDIR=${CMAKE_INSTALL_LIBDIR}
      -DCMAKE_INSTALL_DOCDIR=${CMAKE_INSTALL_DOCDIR}
      -DCMAKE_INSTALL_BINDIR=${CMAKE_INSTALL_BINDIR}
      -DCMAKE_BUILD_TYPE=${DEPENDENCIES_BUILD_TYPE}
      -DISPCRT_BUILD_TASKING=OFF
      -DISPCRT_BUILD_GPU=${BUILD_GPU_SUPPORT}
      -DISPCRT_BUILD_TESTS=OFF
      -DCMAKE_OSX_ARCHITECTURES=${CMAKE_OSX_ARCHITECTURES}
      -DCMAKE_OSX_DEPLOYMENT_TARGET=${CMAKE_OSX_DEPLOYMENT_TARGET}
    BUILD_COMMAND ${DEFAULT_BUILD_COMMAND}
    BUILD_ALWAYS ${ALWAYS_REBUILD}
  )
  
  set(ISPCRT_LIBDIR ${CMAKE_INSTALL_LIBDIR})
  add_dependencies(${COMPONENT_NAME} ispc)
  ExternalProject_Add_StepTargets(${COMPONENT_NAME} configure ispc)
endif()

set(ispcrt_DIR "${COMPONENT_PATH}/${ISPCRT_LIBDIR}/cmake/ispcrt-${ISPC_VERSION}")

list(APPEND CMAKE_PREFIX_PATH ${COMPONENT_PATH})
string(REPLACE ";" "|" CMAKE_PREFIX_PATH "${CMAKE_PREFIX_PATH}")
