/*
 * Purpose: Firmware download for Midiman MIDISport 1x1
 */
/*
 *
 * This file is part of Open Sound System.
 *
 * Copyright (C) 4Front Technologies 1996-2008.
 *
 * This this source file is released under GPL v2 license (no other versions).
 * See the COPYING file included in the main directory of this source
 * distribution for the license terms and conditions.
 *
 */
const struct setup_request midisport1x1_setupRequest[] = {
  {0x00, 0x05, 0x0002, 0x0000, 0x0000, 0x0000, ""},
  {0x40, 0xA0, 0x7F92, 0x0000, 0x0001, 0x0001, "\x01"},
  {0x40, 0xA0, 0x7F92, 0x0000, 0x0001, 0x0001, "\x01"},
  {0x40, 0xA0, 0x146C, 0x0000, 0x0010, 0x0010,
   "\xC2\x00\x90\x7F\xA5\xE0\x54\x18\xFF\x13\x13\x13\x54\x1F\x44\x50"},
  {0x40, 0xA0, 0x147C, 0x0000, 0x0010, 0x0010,
   "\xF5\x1C\x13\x92\x01\xD2\xE8\x90\x7F\xAB\x74\xFF\xF0\x90\x7F\xA9"},
  {0x40, 0xA0, 0x148C, 0x0000, 0x0010, 0x0010,
   "\xF0\x90\x7F\xAA\xF0\x53\x91\xEF\x90\x7F\x95\xE0\x44\xC0\xF0\x90"},
  {0x40, 0xA0, 0x149C, 0x0000, 0x0010, 0x0010,
   "\x7F\xAF\xE0\x44\x01\xF0\x90\x7F\xAE\xE0\x44\x05\xF0\xD2\xAF\x12"},
  {0x40, 0xA0, 0x14AC, 0x0000, 0x000D, 0x000D,
   "\x17\x5F\x30\x00\xFD\x12\x11\x00\xC2\x00\x80\xF6\x22"},
  {0x40, 0xA0, 0x1100, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xE9\xE0\x24\x5D\x60\x0D\x14\x70\x03\x02\x12\x44\x24\x02"},
  {0x40, 0xA0, 0x1110, 0x0000, 0x0010, 0x0010,
   "\x60\x03\x02\x12\x4A\x90\x7F\xEA\xE0\x75\x08\x00\xF5\x09\xA3\xE0"},
  {0x40, 0xA0, 0x1120, 0x0000, 0x0010, 0x0010,
   "\xFE\xE4\x25\x09\xF5\x09\xEE\x35\x08\xF5\x08\x90\x7F\xEE\xE0\x75"},
  {0x40, 0xA0, 0x1130, 0x0000, 0x0010, 0x0010,
   "\x0A\x00\xF5\x0B\xA3\xE0\xFE\xE4\x25\x0B\xF5\x0B\xEE\x35\x0A\xF5"},
  {0x40, 0xA0, 0x1140, 0x0000, 0x0010, 0x0010,
   "\x0A\x90\x7F\xE8\xE0\x64\xC0\x60\x03\x02\x11\xD4\xE5\x0B\x45\x0A"},
  {0x40, 0xA0, 0x1150, 0x0000, 0x0010, 0x0010,
   "\x70\x03\x02\x12\x4A\xC3\xE5\x0B\x94\x40\xE5\x0A\x94\x00\x50\x08"},
  {0x40, 0xA0, 0x1160, 0x0000, 0x0010, 0x0010,
   "\x85\x0A\x0C\x85\x0B\x0D\x80\x06\x75\x0C\x00\x75\x0D\x40\x90\x7F"},
  {0x40, 0xA0, 0x1170, 0x0000, 0x0010, 0x0010,
   "\xE9\xE0\xB4\xA3\x25\xAE\x0C\xAF\x0D\xAA\x08\xA9\x09\x7B\x01\xC0"},
  {0x40, 0xA0, 0x1180, 0x0000, 0x0010, 0x0010,
   "\x03\xC0\x02\xC0\x01\x7A\x7F\x79\x00\x78\x00\x7C\x7F\xAD\x03\xD0"},
  {0x40, 0xA0, 0x1190, 0x0000, 0x0010, 0x0010,
   "\x01\xD0\x02\xD0\x03\x12\x13\x56\x80\x0F\xAF\x09\xAE\x08\xAD\x0D"},
  {0x40, 0xA0, 0x11A0, 0x0000, 0x0010, 0x0010,
   "\x7A\x7F\x79\x00\x7B\x00\x12\x15\xA4\x90\x7F\xB5\xE5\x0D\xF0\xE5"},
  {0x40, 0xA0, 0x11B0, 0x0000, 0x0010, 0x0010,
   "\x0D\x25\x09\xF5\x09\xE5\x0C\x35\x08\xF5\x08\xC3\xE5\x0B\x95\x0D"},
  {0x40, 0xA0, 0x11C0, 0x0000, 0x0010, 0x0010,
   "\xF5\x0B\xE5\x0A\x95\x0C\xF5\x0A\x90\x7F\xB4\xE0\x20\xE2\x03\x02"},
  {0x40, 0xA0, 0x11D0, 0x0000, 0x0010, 0x0010,
   "\x11\x4C\x80\xF4\x90\x7F\xE8\xE0\x64\x40\x70\x6E\xE5\x0B\x45\x0A"},
  {0x40, 0xA0, 0x11E0, 0x0000, 0x0010, 0x0010,
   "\x60\x68\xE4\x90\x7F\xC5\xF0\x90\x7F\xB4\xE0\x20\xE3\xF9\x90\x7F"},
  {0x40, 0xA0, 0x11F0, 0x0000, 0x0010, 0x0010,
   "\xC5\xE0\x75\x0C\x00\xF5\x0D\x90\x7F\xE9\xE0\xB4\xA3\x15\xAE\x0C"},
  {0x40, 0xA0, 0x1200, 0x0000, 0x0010, 0x0010,
   "\xAF\x0D\xA8\x09\xAC\x08\x7D\x01\x7B\x01\x7A\x7E\x79\xC0\x12\x13"},
  {0x40, 0xA0, 0x1210, 0x0000, 0x0010, 0x0010,
   "\x56\x80\x0F\xAF\x09\xAE\x08\xAD\x0D\x7A\x7F\x79\x00\x7B\x00\x12"},
  {0x40, 0xA0, 0x1220, 0x0000, 0x0010, 0x0010,
   "\x14\xB9\xE5\x0D\x25\x09\xF5\x09\xE5\x0C\x35\x08\xF5\x08\xC3\xE5"},
  {0x40, 0xA0, 0x1230, 0x0000, 0x0010, 0x0010,
   "\x0B\x95\x0D\xF5\x0B\xE5\x0A\x95\x0C\xF5\x0A\x90\x7F\xB4\xE0\x44"},
  {0x40, 0xA0, 0x1240, 0x0000, 0x000A, 0x000A,
   "\x02\xF0\x80\x98\x90\x7F\xEA\xE0\xF5\x1C"},
  {0x40, 0xA0, 0x124A, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x1558, 0x0000, 0x0006, 0x0006, "\xAB\x07\xAA\x06\xAC\x05"},
  {0x40, 0xA0, 0x155E, 0x0000, 0x0010, 0x0010,
   "\xE4\xFD\x30\x01\x11\xEA\xFF\xAE\x05\x0D\xEE\x24\x00\xF5\x82\xE4"},
  {0x40, 0xA0, 0x156E, 0x0000, 0x0010, 0x0010,
   "\x34\xE0\xF5\x83\xEF\xF0\xEB\xAE\x05\x0D\x74\x00\x2E\xF5\x82\xE4"},
  {0x40, 0xA0, 0x157E, 0x0000, 0x0010, 0x0010,
   "\x34\xE0\xF5\x83\xEB\xF0\xAF\x05\x0D\x74\x00\x2F\xF5\x82\xE4\x34"},
  {0x40, 0xA0, 0x158E, 0x0000, 0x0010, 0x0010,
   "\xE0\xF5\x83\xEC\xF0\xAF\x1C\x7A\xE0\x7B\x00\x12\x17\x20\x7F\x0A"},
  {0x40, 0xA0, 0x159E, 0x0000, 0x0005, 0x0005, "\x7E\x00\x12\x17\x3C"},
  {0x40, 0xA0, 0x15A3, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x14B9, 0x0000, 0x000A, 0x000A,
   "\x8E\x0E\x8F\x0F\x8D\x10\x8A\x11\x8B\x12"},
  {0x40, 0xA0, 0x14C3, 0x0000, 0x0010, 0x0010,
   "\xE4\xF5\x13\xE5\x13\xC3\x95\x10\x50\x20\x05\x0F\xE5\x0F\xAE\x0E"},
  {0x40, 0xA0, 0x14D3, 0x0000, 0x0010, 0x0010,
   "\x70\x02\x05\x0E\x14\xFF\xE5\x12\x25\x13\xF5\x82\xE4\x35\x11\xF5"},
  {0x40, 0xA0, 0x14E3, 0x0000, 0x000A, 0x000A,
   "\x83\xE0\xFD\x12\x15\x58\x05\x13\x80\xD9"},
  {0x40, 0xA0, 0x14ED, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x15A4, 0x0000, 0x000A, 0x000A,
   "\x8E\x0E\x8F\x0F\x8D\x10\x8A\x11\x8B\x12"},
  {0x40, 0xA0, 0x15AE, 0x0000, 0x0010, 0x0010,
   "\xE4\xFD\x30\x01\x12\xE5\x0E\xFF\xAE\x05\x0D\xEE\x24\x03\xF5\x82"},
  {0x40, 0xA0, 0x15BE, 0x0000, 0x0010, 0x0010,
   "\xE4\x34\xE0\xF5\x83\xEF\xF0\xE5\x0F\xAE\x05\x0D\x74\x03\x2E\xF5"},
  {0x40, 0xA0, 0x15CE, 0x0000, 0x0010, 0x0010,
   "\x82\xE4\x34\xE0\xF5\x83\xE5\x0F\xF0\xAF\x1C\x7A\xE0\x7B\x03\x12"},
  {0x40, 0xA0, 0x15DE, 0x0000, 0x000D, 0x000D,
   "\x17\x20\xAF\x1C\xAD\x10\xAB\x12\xAA\x11\x12\x17\x04"},
  {0x40, 0xA0, 0x15EB, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x166E, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\xD2"},
  {0x40, 0xA0, 0x167E, 0x0000, 0x0010, 0x0010,
   "\x00\x53\x91\xEF\x90\x7F\xAB\x74\x01\xF0\xD0\x86\xD0\x84\xD0\x85"},
  {0x40, 0xA0, 0x168E, 0x0000, 0x0007, 0x0007,
   "\xD0\x82\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x1644, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\x90"},
  {0x40, 0xA0, 0x1654, 0x0000, 0x0010, 0x0010,
   "\x7F\xC4\xE4\xF0\x53\x91\xEF\x90\x7F\xAB\x74\x04\xF0\xD0\x86\xD0"},
  {0x40, 0xA0, 0x1664, 0x0000, 0x000A, 0x000A,
   "\x84\xD0\x85\xD0\x82\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x1695, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\x53"},
  {0x40, 0xA0, 0x16A5, 0x0000, 0x0010, 0x0010,
   "\x91\xEF\x90\x7F\xAB\x74\x02\xF0\xD0\x86\xD0\x84\xD0\x85\xD0\x82"},
  {0x40, 0xA0, 0x16B5, 0x0000, 0x0005, 0x0005, "\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x16BA, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\x53"},
  {0x40, 0xA0, 0x16CA, 0x0000, 0x0010, 0x0010,
   "\x91\xEF\x90\x7F\xAB\x74\x10\xF0\xD0\x86\xD0\x84\xD0\x85\xD0\x82"},
  {0x40, 0xA0, 0x16DA, 0x0000, 0x0005, 0x0005, "\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x14FF, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x16DF, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\x53"},
  {0x40, 0xA0, 0x16EF, 0x0000, 0x0010, 0x0010,
   "\x91\xEF\x90\x7F\xAB\x74\x08\xF0\xD0\x86\xD0\x84\xD0\x85\xD0\x82"},
  {0x40, 0xA0, 0x16FF, 0x0000, 0x0005, 0x0005, "\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x1767, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x1768, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x1769, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x176A, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x176B, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x176C, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x176D, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x176E, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x176F, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x1770, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x1771, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x1772, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x1773, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x1774, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x1775, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x1776, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0043, 0x0000, 0x0003, 0x0003, "\x02\x15\x00"},
  {0x40, 0xA0, 0x1500, 0x0000, 0x0010, 0x0010,
   "\x02\x16\x6E\x00\x02\x16\x95\x00\x02\x16\x44\x00\x02\x16\xDF\x00"},
  {0x40, 0xA0, 0x1510, 0x0000, 0x0010, 0x0010,
   "\x02\x16\xBA\x00\x02\x14\xFF\x00\x02\x17\x67\x00\x02\x17\x68\x00"},
  {0x40, 0xA0, 0x1520, 0x0000, 0x0010, 0x0010,
   "\x02\x17\x69\x00\x02\x17\x6A\x00\x02\x17\x6B\x00\x02\x17\x6C\x00"},
  {0x40, 0xA0, 0x1530, 0x0000, 0x0010, 0x0010,
   "\x02\x17\x6D\x00\x02\x17\x6E\x00\x02\x17\x6F\x00\x02\x17\x70\x00"},
  {0x40, 0xA0, 0x1540, 0x0000, 0x0010, 0x0010,
   "\x02\x17\x71\x00\x02\x17\x72\x00\x02\x17\x73\x00\x02\x17\x74\x00"},
  {0x40, 0xA0, 0x1550, 0x0000, 0x0008, 0x0008,
   "\x02\x17\x75\x00\x02\x17\x76\x00"},
  {0x40, 0xA0, 0x173C, 0x0000, 0x0010, 0x0010,
   "\x8E\x14\x8F\x15\xE5\x15\x15\x15\xAE\x14\x70\x02\x15\x14\x4E\x60"},
  {0x40, 0xA0, 0x174C, 0x0000, 0x0007, 0x0007,
   "\x05\x12\x14\xEE\x80\xEE\x22"},
  {0x40, 0xA0, 0x175F, 0x0000, 0x0008, 0x0008,
   "\xE4\xF5\x1B\xD2\xE9\xD2\xAF\x22"},
  {0x40, 0xA0, 0x1619, 0x0000, 0x0010, 0x0010,
   "\xA9\x07\xE5\x1B\x70\x23\x90\x7F\xA5\xE0\x44\x80\xF0\xE9\x25\xE0"},
  {0x40, 0xA0, 0x1629, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xA6\xF0\x8D\x16\xAF\x03\xA9\x07\x75\x17\x01\x8A\x18\x89"},
  {0x40, 0xA0, 0x1639, 0x0000, 0x000B, 0x000B,
   "\x19\xE4\xF5\x1A\x75\x1B\x01\xD3\x22\xC3\x22"},
  {0x40, 0xA0, 0x15EC, 0x0000, 0x0010, 0x0010,
   "\xA9\x07\xE5\x1B\x70\x25\x90\x7F\xA5\xE0\x44\x80\xF0\xE9\x25\xE0"},
  {0x40, 0xA0, 0x15FC, 0x0000, 0x0010, 0x0010,
   "\x44\x01\x90\x7F\xA6\xF0\x8D\x16\xAF\x03\xA9\x07\x75\x17\x01\x8A"},
  {0x40, 0xA0, 0x160C, 0x0000, 0x000D, 0x000D,
   "\x18\x89\x19\xE4\xF5\x1A\x75\x1B\x03\xD3\x22\xC3\x22"},
  {0x40, 0xA0, 0x004B, 0x0000, 0x0003, 0x0003, "\x02\x13\x7F"},
  {0x40, 0xA0, 0x137F, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\xC0"},
  {0x40, 0xA0, 0x138F, 0x0000, 0x0010, 0x0010,
   "\xD0\x75\xD0\x00\xC0\x00\xC0\x01\xC0\x02\xC0\x03\xC0\x06\xC0\x07"},
  {0x40, 0xA0, 0x139F, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xA5\xE0\x30\xE2\x06\x75\x1B\x06\x02\x14\x4E\x90\x7F\xA5"},
  {0x40, 0xA0, 0x13AF, 0x0000, 0x0010, 0x0010,
   "\xE0\x20\xE1\x0C\xE5\x1B\x64\x02\x60\x06\x75\x1B\x07\x02\x14\x4E"},
  {0x40, 0xA0, 0x13BF, 0x0000, 0x0010, 0x0010,
   "\xAF\x1B\xEF\x24\xFE\x60\x48\x14\x60\x2C\x24\xFE\x60\x77\x24\x04"},
  {0x40, 0xA0, 0x13CF, 0x0000, 0x0010, 0x0010,
   "\x60\x03\x02\x14\x4E\xAB\x17\xAA\x18\xA9\x19\xAF\x1A\x05\x1A\x8F"},
  {0x40, 0xA0, 0x13DF, 0x0000, 0x0010, 0x0010,
   "\x82\x75\x83\x00\x12\x12\x4B\x90\x7F\xA6\xF0\xE5\x1A\x65\x16\x70"},
  {0x40, 0xA0, 0x13EF, 0x0000, 0x0010, 0x0010,
   "\x5E\x75\x1B\x05\x80\x59\x90\x7F\xA6\xE0\xAB\x17\xAA\x18\xA9\x19"},
  {0x40, 0xA0, 0x13FF, 0x0000, 0x0010, 0x0010,
   "\xAE\x1A\x8E\x82\x75\x83\x00\x12\x12\x78\x75\x1B\x02\x80\x40\xE5"},
  {0x40, 0xA0, 0x140F, 0x0000, 0x0010, 0x0010,
   "\x16\x24\xFE\xB5\x1A\x07\x90\x7F\xA5\xE0\x44\x20\xF0\xE5\x16\x14"},
  {0x40, 0xA0, 0x141F, 0x0000, 0x0010, 0x0010,
   "\xB5\x1A\x0A\x90\x7F\xA5\xE0\x44\x40\xF0\x75\x1B\x00\x90\x7F\xA6"},
  {0x40, 0xA0, 0x142F, 0x0000, 0x0010, 0x0010,
   "\xE0\xAB\x17\xAA\x18\xA9\x19\xAE\x1A\x8E\x82\x75\x83\x00\x12\x12"},
  {0x40, 0xA0, 0x143F, 0x0000, 0x0010, 0x0010,
   "\x78\x05\x1A\x80\x0A\x90\x7F\xA5\xE0\x44\x40\xF0\x75\x1B\x00\x53"},
  {0x40, 0xA0, 0x144F, 0x0000, 0x0010, 0x0010,
   "\x91\xDF\xD0\x07\xD0\x06\xD0\x03\xD0\x02\xD0\x01\xD0\x00\xD0\xD0"},
  {0x40, 0xA0, 0x145F, 0x0000, 0x000D, 0x000D,
   "\xD0\x86\xD0\x84\xD0\x85\xD0\x82\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x1704, 0x0000, 0x0010, 0x0010,
   "\x12\x15\xEC\xE5\x1B\x24\xFA\x60\x0E\x14\x60\x06\x24\x07\x70\xF3"},
  {0x40, 0xA0, 0x1714, 0x0000, 0x000C, 0x000C,
   "\xD3\x22\xE4\xF5\x1B\xD3\x22\xE4\xF5\x1B\xD3\x22"},
  {0x40, 0xA0, 0x1720, 0x0000, 0x0010, 0x0010,
   "\x12\x16\x19\xE5\x1B\x24\xFA\x60\x0E\x14\x60\x06\x24\x07\x70\xF3"},
  {0x40, 0xA0, 0x1730, 0x0000, 0x000C, 0x000C,
   "\xD3\x22\xE4\xF5\x1B\xD3\x22\xE4\xF5\x1B\xD3\x22"},
  {0x40, 0xA0, 0x14EE, 0x0000, 0x0010, 0x0010,
   "\x74\x00\xF5\x86\x90\xFD\xA5\x7C\x05\xA3\xE5\x82\x45\x83\x70\xF9"},
  {0x40, 0xA0, 0x14FE, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x0000, 0x0000, 0x0003, 0x0003, "\x02\x17\x53"},
  {0x40, 0xA0, 0x1753, 0x0000, 0x000C, 0x000C,
   "\x78\x7F\xE4\xF6\xD8\xFD\x75\x81\x20\x02\x14\x6C"},
  {0x40, 0xA0, 0x124B, 0x0000, 0x0010, 0x0010,
   "\xBB\x01\x0C\xE5\x82\x29\xF5\x82\xE5\x83\x3A\xF5\x83\xE0\x22\x50"},
  {0x40, 0xA0, 0x125B, 0x0000, 0x0010, 0x0010,
   "\x06\xE9\x25\x82\xF8\xE6\x22\xBB\xFE\x06\xE9\x25\x82\xF8\xE2\x22"},
  {0x40, 0xA0, 0x126B, 0x0000, 0x000D, 0x000D,
   "\xE5\x82\x29\xF5\x82\xE5\x83\x3A\xF5\x83\xE4\x93\x22"},
  {0x40, 0xA0, 0x1278, 0x0000, 0x0010, 0x0010,
   "\xF8\xBB\x01\x0D\xE5\x82\x29\xF5\x82\xE5\x83\x3A\xF5\x83\xE8\xF0"},
  {0x40, 0xA0, 0x1288, 0x0000, 0x0010, 0x0010,
   "\x22\x50\x06\xE9\x25\x82\xC8\xF6\x22\xBB\xFE\x05\xE9\x25\x82\xC8"},
  {0x40, 0xA0, 0x1298, 0x0000, 0x0002, 0x0002, "\xF2\x22"},
  {0x40, 0xA0, 0x129A, 0x0000, 0x0010, 0x0010,
   "\xE7\x09\xF6\x08\xDF\xFA\x80\x46\xE7\x09\xF2\x08\xDF\xFA\x80\x3E"},
  {0x40, 0xA0, 0x12AA, 0x0000, 0x0010, 0x0010,
   "\x88\x82\x8C\x83\xE7\x09\xF0\xA3\xDF\xFA\x80\x32\xE3\x09\xF6\x08"},
  {0x40, 0xA0, 0x12BA, 0x0000, 0x0010, 0x0010,
   "\xDF\xFA\x80\x6E\xE3\x09\xF2\x08\xDF\xFA\x80\x66\x88\x82\x8C\x83"},
  {0x40, 0xA0, 0x12CA, 0x0000, 0x0010, 0x0010,
   "\xE3\x09\xF0\xA3\xDF\xFA\x80\x5A\x89\x82\x8A\x83\xE0\xA3\xF6\x08"},
  {0x40, 0xA0, 0x12DA, 0x0000, 0x0010, 0x0010,
   "\xDF\xFA\x80\x4E\x89\x82\x8A\x83\xE0\xA3\xF2\x08\xDF\xFA\x80\x42"},
  {0x40, 0xA0, 0x12EA, 0x0000, 0x0010, 0x0010,
   "\x80\xD2\x80\xFA\x80\xC6\x80\xD4\x80\x55\x80\xF2\x80\x29\x80\x10"},
  {0x40, 0xA0, 0x12FA, 0x0000, 0x0010, 0x0010,
   "\x80\xA6\x80\xEA\x80\x9A\x80\xA8\x80\xDA\x80\xE2\x80\xCA\x80\x29"},
  {0x40, 0xA0, 0x130A, 0x0000, 0x0010, 0x0010,
   "\x88\x84\x8C\x85\x89\x82\x8A\x83\xE4\x93\xA3\x05\x86\xF0\xA3\x05"},
  {0x40, 0xA0, 0x131A, 0x0000, 0x0010, 0x0010,
   "\x86\xDF\xF5\xDE\xF3\x80\x0B\x89\x82\x8A\x83\xE4\x93\xA3\xF6\x08"},
  {0x40, 0xA0, 0x132A, 0x0000, 0x0010, 0x0010,
   "\xDF\xF9\xEC\xFA\xA9\xF0\xED\xFB\x22\x88\x84\x8C\x85\x89\x82\x8A"},
  {0x40, 0xA0, 0x133A, 0x0000, 0x0010, 0x0010,
   "\x83\xE0\xA3\x05\x86\xF0\xA3\x05\x86\xDF\xF6\xDE\xF4\x80\xE3\x89"},
  {0x40, 0xA0, 0x134A, 0x0000, 0x0010, 0x0010,
   "\x82\x8A\x83\xE4\x93\xA3\xF2\x08\xDF\xF9\x80\xD6\x88\xF0\xED\x24"},
  {0x40, 0xA0, 0x135A, 0x0000, 0x0010, 0x0010,
   "\x02\xB4\x04\x00\x50\xCC\xF5\x82\xEB\x24\x02\xB4\x04\x00\x50\xC2"},
  {0x40, 0xA0, 0x136A, 0x0000, 0x0010, 0x0010,
   "\x23\x23\x45\x82\xF5\x82\xEF\x4E\x60\xB8\xEF\x60\x01\x0E\xE5\x82"},
  {0x40, 0xA0, 0x137A, 0x0000, 0x0005, 0x0005, "\x23\x90\x12\xEA\x73"},
  {0x40, 0xA0, 0x7F92, 0x0000, 0x0001, 0x0001, "\x00"},
  {0x40, 0xA0, 0x7F92, 0x0000, 0x0001, 0x0001, "\x01"},
  {0x40, 0xA0, 0x0100, 0x0000, 0x0010, 0x0010,
   "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"},
  {0x40, 0xA0, 0x0110, 0x0000, 0x0010, 0x0010,
   "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"},
  {0x40, 0xA0, 0x0120, 0x0000, 0x0010, 0x0010,
   "\x4D\x69\x64\x69\x6D\x61\x6E\x20\x55\x53\x42\x20\x4D\x69\x64\x69"},
  {0x40, 0xA0, 0x0130, 0x0000, 0x0010, 0x0010,
   "\x53\x70\x6F\x72\x74\x20\x31\x78\x31\x20\x20\x20\x20\x20\x20\x20"},
  {0x40, 0xA0, 0x0140, 0x0000, 0x0010, 0x0010,
   "\x46\x69\x72\x6D\x77\x61\x72\x65\x20\x52\x65\x6C\x65\x61\x73\x65"},
  {0x40, 0xA0, 0x0150, 0x0000, 0x0010, 0x0010,
   "\x20\x31\x2E\x32\x31\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"},
  {0x40, 0xA0, 0x0160, 0x0000, 0x0010, 0x0010,
   "\x28\x63\x29\x20\x32\x30\x30\x30\x2D\x32\x30\x30\x31\x2C\x20\x4D"},
  {0x40, 0xA0, 0x0170, 0x0000, 0x0010, 0x0010,
   "\x69\x64\x69\x6D\x61\x6E\x20\x49\x6E\x63\x2E\x20\x20\x20\x20\x20"},
  {0x40, 0xA0, 0x0180, 0x0000, 0x0010, 0x0010,
   "\x41\x6C\x6C\x20\x72\x69\x67\x68\x74\x73\x20\x72\x65\x73\x65\x72"},
  {0x40, 0xA0, 0x0190, 0x0000, 0x0010, 0x0010,
   "\x76\x65\x64\x2E\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"},
  {0x40, 0xA0, 0x01A0, 0x0000, 0x0010, 0x0010,
   "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"},
  {0x40, 0xA0, 0x01B0, 0x0000, 0x0010, 0x0010,
   "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"},
  {0x40, 0xA0, 0x08B2, 0x0000, 0x0003, 0x0003, "\x01\x1C\x00"},
  {0x40, 0xA0, 0x040D, 0x0000, 0x0010, 0x0010,
   "\xC2\x01\xC2\x00\xC2\x04\xC2\x03\x12\x09\xE1\xD2\xE8\x43\xD8\x20"},
  {0x40, 0xA0, 0x041D, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xAB\x74\xFF\xF0\x90\x7F\xA9\xF0\x90\x7F\xAA\xF0\x53\x91"},
  {0x40, 0xA0, 0x042D, 0x0000, 0x0010, 0x0010,
   "\xEF\x90\x7F\x95\xE0\x44\xC0\xF0\x90\x7F\xAF\xE0\x44\x01\xF0\x90"},
  {0x40, 0xA0, 0x043D, 0x0000, 0x0010, 0x0010,
   "\x7F\xAE\xE0\x44\x1D\xF0\x90\x7F\x92\xE0\x44\x02\xF0\x90\x7F\x95"},
  {0x40, 0xA0, 0x044D, 0x0000, 0x0010, 0x0010,
   "\xE0\x44\x01\xF0\x90\x7F\x9E\xE0\x54\xFE\xF0\x90\x7F\x95\xE0\x44"},
  {0x40, 0xA0, 0x045D, 0x0000, 0x0010, 0x0010,
   "\x02\xF0\x90\x7F\x9E\xE0\x44\x02\xF0\x90\x7F\x95\xE0\x54\x83\xF0"},
  {0x40, 0xA0, 0x046D, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\x9E\xE0\x44\x7C\xF0\x90\x7F\x94\xE0\x54\xFE\xF0\x90\x7F"},
  {0x40, 0xA0, 0x047D, 0x0000, 0x0010, 0x0010,
   "\x9D\xE0\x44\x01\xF0\x90\x7F\x9A\xE0\x44\x01\x90\x7F\x97\xF0\x43"},
  {0x40, 0xA0, 0x048D, 0x0000, 0x0010, 0x0010,
   "\x21\x20\x43\x21\x40\x43\x21\x10\x53\x89\xF0\xE4\xF5\x8C\xF5\x8A"},
  {0x40, 0xA0, 0x049D, 0x0000, 0x0010, 0x0010,
   "\xD2\x8C\xD2\xA9\x12\x0B\xAE\xD2\xAF\xE5\x89\x54\x0F\x24\x20\xF5"},
  {0x40, 0xA0, 0x04AD, 0x0000, 0x0010, 0x0010,
   "\x89\x75\x8D\xFE\x75\x8B\xFE\xD2\x8E\xC2\xAC\x75\x98\x50\xC2\x98"},
  {0x40, 0xA0, 0x04BD, 0x0000, 0x0010, 0x0010,
   "\xC2\x99\xD2\xAC\x53\x21\xDF\x53\x21\xBF\x53\x21\xEF\x90\x7F\x9A"},
  {0x40, 0xA0, 0x04CD, 0x0000, 0x0010, 0x0010,
   "\xE0\x54\xFE\x90\x7F\x97\xF0\x90\x7F\x98\xE5\x21\xF0\x75\x24\x3D"},
  {0x40, 0xA0, 0x04DD, 0x0000, 0x0010, 0x0010,
   "\xE5\x24\x70\xFC\x43\x21\x20\x43\x21\x40\x43\x21\x10\x90\x7F\x98"},
  {0x40, 0xA0, 0x04ED, 0x0000, 0x0010, 0x0010,
   "\xE5\x21\xF0\x20\x01\x3C\x75\x24\xF4\xE5\x24\x60\x03\x30\x01\xF9"},
  {0x40, 0xA0, 0x04FD, 0x0000, 0x0010, 0x0010,
   "\x75\x24\xF4\xE5\x24\x60\x03\x30\x01\xF9\x75\x24\xF4\xE5\x24\x60"},
  {0x40, 0xA0, 0x050D, 0x0000, 0x0010, 0x0010,
   "\x03\x30\x01\xF9\x75\x24\xF4\xE5\x24\x60\x03\x30\x01\xF9\x75\x24"},
  {0x40, 0xA0, 0x051D, 0x0000, 0x0010, 0x0010,
   "\xF4\xE5\x24\x60\x03\x30\x01\xF9\x20\x01\xC8\xD2\x06\x12\x0A\xE0"},
  {0x40, 0xA0, 0x052D, 0x0000, 0x0010, 0x0010,
   "\x80\xC1\x30\x01\x0C\x12\x01\xFF\xC2\x01\x90\x7F\xAE\xE0\x44\x02"},
  {0x40, 0xA0, 0x053D, 0x0000, 0x0010, 0x0010,
   "\xF0\x30\x04\x1A\x12\x0B\x91\x50\x13\x12\x0B\x05\x20\x03\x07\x90"},
  {0x40, 0xA0, 0x054D, 0x0000, 0x0010, 0x0010,
   "\x7F\xD6\xE0\x20\xE7\xF3\x12\x0B\x26\x12\x0B\xB2\xC2\x04\x05\x1C"},
  {0x40, 0xA0, 0x055D, 0x0000, 0x0010, 0x0010,
   "\xE5\x1C\xC3\x94\x06\x40\x03\xE4\xF5\x1C\xE5\x1C\x75\xF0\x03\xA4"},
  {0x40, 0xA0, 0x056D, 0x0000, 0x000E, 0x000E,
   "\x24\x0A\xF8\x08\xE6\xFA\x08\xE6\xF9\x12\x07\x11\x80\xB4"},
  {0x40, 0xA0, 0x057B, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x0033, 0x0000, 0x0003, 0x0003, "\x02\x0B\xAA"},
  {0x40, 0xA0, 0x0BAA, 0x0000, 0x0004, 0x0004, "\x53\xD8\xEF\x32"},
  {0x40, 0xA0, 0x0023, 0x0000, 0x0003, 0x0003, "\x02\x07\x17"},
  {0x40, 0xA0, 0x0717, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\xC0"},
  {0x40, 0xA0, 0x0727, 0x0000, 0x000C, 0x000C,
   "\xD0\x75\xD0\x00\xC0\x00\xC0\x05\xC0\x06\xC0\x07"},
  {0x40, 0xA0, 0x0733, 0x0000, 0x0010, 0x0010,
   "\x30\x99\x23\xC2\x99\xE5\x68\x60\x1B\xAF\x67\x05\x67\x74\x00\x2F"},
  {0x40, 0xA0, 0x0743, 0x0000, 0x0010, 0x0010,
   "\xF5\x82\xE4\x34\x0F\xF5\x83\xE0\xF5\x99\x15\x68\x53\x21\xBF\x75"},
  {0x40, 0xA0, 0x0753, 0x0000, 0x0010, 0x0010,
   "\x23\x0C\x80\x02\xD2\x02\x30\x98\x1E\xC2\x98\xAF\x99\xE5\x66\x04"},
  {0x40, 0xA0, 0x0763, 0x0000, 0x0010, 0x0010,
   "\x54\x3F\xFE\x65\x65\x60\x0A\xAD\x66\x74\x25\x2D\xF8\xA6\x07\x8E"},
  {0x40, 0xA0, 0x0773, 0x0000, 0x0007, 0x0007,
   "\x66\x53\x21\xDF\x75\x22\x0C"},
  {0x40, 0xA0, 0x077A, 0x0000, 0x0010, 0x0010,
   "\xD0\x07\xD0\x06\xD0\x05\xD0\x00\xD0\xD0\xD0\x86\xD0\x84\xD0\x85"},
  {0x40, 0xA0, 0x078A, 0x0000, 0x0007, 0x0007,
   "\xD0\x82\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x0A17, 0x0000, 0x0010, 0x0010,
   "\xA2\xAC\x92\x06\xC2\xAC\x30\x02\x0C\xC2\x02\x8F\x99\x53\x21\xBF"},
  {0x40, 0xA0, 0x0A27, 0x0000, 0x0010, 0x0010,
   "\x75\x23\x0C\x80\x12\xAE\x69\x05\x69\x74\x00\x2E\xF5\x82\xE4\x34"},
  {0x40, 0xA0, 0x0A37, 0x0000, 0x000B, 0x000B,
   "\x0F\xF5\x83\xEF\xF0\x05\x68\xA2\x06\x92\xAC"},
  {0x40, 0xA0, 0x0A42, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x01C0, 0x0000, 0x0010, 0x0010,
   "\x12\x01\x00\x01\x00\x00\x00\x40\x63\x07\x11\x10\x21\x01\x00\x00"},
  {0x40, 0xA0, 0x01D0, 0x0000, 0x0010, 0x0010,
   "\x00\x01\x09\x02\x27\x00\x01\x01\x00\xA0\x00\x09\x04\x00\x00\x03"},
  {0x40, 0xA0, 0x01E0, 0x0000, 0x0010, 0x0010,
   "\xFF\x00\x00\x00\x07\x05\x81\x03\x20\x00\x01\x07\x05\x82\x02\x20"},
  {0x40, 0xA0, 0x01F0, 0x0000, 0x000F, 0x000F,
   "\x00\x00\x07\x05\x02\x02\x20\x00\x00\x04\x03\x09\x04\x00\x00"},
  {0x40, 0xA0, 0x08B5, 0x0000, 0x0010, 0x0010,
   "\x01\x24\x00\xC1\x01\x01\x22\x00\x01\x21\xFF\x01\x23\x00\xC1\x82"},
  {0x40, 0xA0, 0x08C5, 0x0000, 0x000F, 0x000F,
   "\x01\x65\x00\x01\x66\x00\x01\x67\x00\x01\x69\x00\x01\x68\x00"},
  {0x40, 0xA0, 0x0043, 0x0000, 0x0003, 0x0003, "\x02\x09\x00"},
  {0x40, 0xA0, 0x0900, 0x0000, 0x0010, 0x0010,
   "\x02\x0A\x6D\x00\x02\x08\x03\x00\x02\x0A\x43\x00\x02\x0A\x94\x00"},
  {0x40, 0xA0, 0x0910, 0x0000, 0x0010, 0x0010,
   "\x02\x0A\xBB\x00\x02\x0B\xBE\x00\x02\x0B\xBF\x00\x02\x0B\xC0\x00"},
  {0x40, 0xA0, 0x0920, 0x0000, 0x0010, 0x0010,
   "\x02\x0B\xC1\x00\x02\x0B\xC2\x00\x02\x0B\xC3\x00\x02\x0B\xC4\x00"},
  {0x40, 0xA0, 0x0930, 0x0000, 0x0010, 0x0010,
   "\x02\x0B\xC5\x00\x02\x0B\xC6\x00\x02\x0B\xC7\x00\x02\x0B\xC8\x00"},
  {0x40, 0xA0, 0x0940, 0x0000, 0x0010, 0x0010,
   "\x02\x0B\xC9\x00\x02\x0B\xCA\x00\x02\x0B\xCB\x00\x02\x0B\xCC\x00"},
  {0x40, 0xA0, 0x0950, 0x0000, 0x0008, 0x0008,
   "\x02\x0B\xCD\x00\x02\x0B\xCE\x00"},
  {0x40, 0xA0, 0x08D4, 0x0000, 0x0010, 0x0010,
   "\x12\x0A\xFF\x07\x91\xFF\x06\x08\xFF\x09\x58\xFF\x07\x91\xFF\x06"},
  {0x40, 0xA0, 0x08E4, 0x0000, 0x000A, 0x000A,
   "\x08\xFF\x0B\x57\x01\x08\xFF\x01\x09\x00"},
  {0x40, 0xA0, 0x0791, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xB6\xE0\x20\xE1\x6A\x7A\x7E\x79\x80\x7E\x7E\x7F\x80\x74"},
  {0x40, 0xA0, 0x07A1, 0x0000, 0x0010, 0x0010,
   "\x7E\x90\x7F\xE3\xF0\x74\x80\x90\x7F\xE4\xF0\xE4\xFF\xE5\x66\x65"},
  {0x40, 0xA0, 0x07B1, 0x0000, 0x0010, 0x0010,
   "\x65\x60\x43\xEF\xC3\x94\x08\x50\x3D\xE4\xFD\xE5\x66\x65\x65\x60"},
  {0x40, 0xA0, 0x07C1, 0x0000, 0x0010, 0x0010,
   "\x1B\xED\xC3\x94\x03\x50\x15\x74\x25\x25\x65\xF8\xE6\x90\x7F\xE5"},
  {0x40, 0xA0, 0x07D1, 0x0000, 0x0010, 0x0010,
   "\xF0\x05\x65\xE5\x65\x54\x3F\xF5\x65\x0D\x80\xDF\xED\x60\xCE\xFE"},
  {0x40, 0xA0, 0x07E1, 0x0000, 0x0010, 0x0010,
   "\xEE\xC3\x94\x03\x50\x08\xE4\x90\x7F\xE5\xF0\x0E\x80\xF2\x90\x7F"},
  {0x40, 0xA0, 0x07F1, 0x0000, 0x0010, 0x0010,
   "\xE5\xED\xF0\x0F\x80\xB7\xEF\x60\x08\x25\xE0\x25\xE0\x90\x7F\xB7"},
  {0x40, 0xA0, 0x0801, 0x0000, 0x0001, 0x0001, "\xF0"},
  {0x40, 0xA0, 0x0802, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x0958, 0x0000, 0x0010, 0x0010,
   "\xE5\x08\x60\x16\x14\x60\x2A\x80\x00\x12\x08\xFD\xEF\x65\x09\x60"},
  {0x40, 0xA0, 0x0968, 0x0000, 0x0010, 0x0010,
   "\x36\x12\x08\xFD\x8F\x09\xE4\xF5\x08\x22\xE5\x22\x60\x10\xD5\x22"},
  {0x40, 0xA0, 0x0978, 0x0000, 0x0010, 0x0010,
   "\x0D\xA2\xAF\x92\x06\xC2\xAF\x43\x21\x20\xA2\x06\x92\xAF\x05\x08"},
  {0x40, 0xA0, 0x0988, 0x0000, 0x0010, 0x0010,
   "\x22\xE5\x23\x60\x10\xD5\x23\x0D\xA2\xAF\x92\x06\xC2\xAF\x43\x21"},
  {0x40, 0xA0, 0x0998, 0x0000, 0x0007, 0x0007,
   "\x40\xA2\x06\x92\xAF\x05\x08"},
  {0x40, 0xA0, 0x099F, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x0B57, 0x0000, 0x0010, 0x0010,
   "\xA2\xAF\x92\x06\xC2\xAF\x90\x7F\x98\xE5\x21\xF0\xA2\x06\x92\xAF"},
  {0x40, 0xA0, 0x0B67, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x0608, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xC8\xE0\x30\xE1\x03\x02\x06\x92\x90\x7F\xC9\xE0\xF5\x6A"},
  {0x40, 0xA0, 0x0618, 0x0000, 0x0010, 0x0010,
   "\xC3\xE4\x95\x68\xFF\x74\x01\x94\x00\xFE\xC3\xE5\x6A\x9F\xE4\x9E"},
  {0x40, 0xA0, 0x0628, 0x0000, 0x0010, 0x0010,
   "\x50\x68\xE4\xF5\x6B\xE5\x6B\xC3\x95\x6A\x50\x59\x74\xC3\x25\x6B"},
  {0x40, 0xA0, 0x0638, 0x0000, 0x0010, 0x0010,
   "\xF5\x82\xE4\x34\x7D\xF5\x83\xE0\x54\x0F\xFD\x60\x48\x74\xC0\x25"},
  {0x40, 0xA0, 0x0648, 0x0000, 0x0010, 0x0010,
   "\x6B\xF5\x82\xE4\x34\x7D\x90\x7F\xE3\xF0\x74\xC0\x25\x6B\xF5\x82"},
  {0x40, 0xA0, 0x0658, 0x0000, 0x0010, 0x0010,
   "\xE4\x34\x7D\xE5\x82\x90\x7F\xE4\xF0\xAF\x05\xED\x14\x60\x16\x14"},
  {0x40, 0xA0, 0x0668, 0x0000, 0x0010, 0x0010,
   "\x60\x0B\x14\x70\x18\x90\x7F\xE5\xE0\xFF\x12\x0A\x17\x90\x7F\xE5"},
  {0x40, 0xA0, 0x0678, 0x0000, 0x0010, 0x0010,
   "\xE0\xFF\x12\x0A\x17\x90\x7F\xE5\xE0\xFF\x12\x0A\x17\x74\x04\x25"},
  {0x40, 0xA0, 0x0688, 0x0000, 0x000A, 0x000A,
   "\x6B\xF5\x6B\x80\xA0\xE4\x90\x7F\xC9\xF0"},
  {0x40, 0xA0, 0x0692, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x08EE, 0x0000, 0x0003, 0x0003, "\x01\x1D\x00"},
  {0x40, 0xA0, 0x000B, 0x0000, 0x0003, 0x0003, "\x02\x0B\x84"},
  {0x40, 0xA0, 0x0B84, 0x0000, 0x000D, 0x000D,
   "\xC0\xE0\x05\x1D\xE5\x24\x60\x02\x15\x24\xD0\xE0\x32"},
  {0x40, 0xA0, 0x08FD, 0x0000, 0x0003, 0x0003, "\xAF\x1D\x22"},
  {0x40, 0xA0, 0x0BAE, 0x0000, 0x0004, 0x0004, "\xE4\xF5\x1D\x22"},
  {0x40, 0xA0, 0x08F1, 0x0000, 0x000B, 0x000B,
   "\x01\x72\x01\x01\x73\x01\xC1\x85\x01\x74\x02"},
  {0x40, 0xA0, 0x01FF, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xE9\xE0\x70\x03\x02\x02\xD4\x14\x70\x03\x02\x03\x4F\x24"},
  {0x40, 0xA0, 0x020F, 0x0000, 0x0010, 0x0010,
   "\xFE\x70\x03\x02\x03\xA8\x24\xFB\x70\x03\x02\x02\xCE\x14\x70\x03"},
  {0x40, 0xA0, 0x021F, 0x0000, 0x0010, 0x0010,
   "\x02\x02\xC8\x14\x70\x03\x02\x02\xBC\x14\x70\x03\x02\x02\xC2\x24"},
  {0x40, 0xA0, 0x022F, 0x0000, 0x0010, 0x0010,
   "\x05\x60\x03\x02\x03\xFA\x12\x0B\xB4\x40\x03\x02\x04\x05\x90\x7F"},
  {0x40, 0xA0, 0x023F, 0x0000, 0x0010, 0x0010,
   "\xEB\xE0\x24\xFE\x60\x16\x14\x60\x3F\x24\x02\x70\x67\x74\x01\x90"},
  {0x40, 0xA0, 0x024F, 0x0000, 0x0010, 0x0010,
   "\x7F\xD4\xF0\x74\xC0\x90\x7F\xD5\xF0\x02\x04\x05\x90\x7F\xEA\xE0"},
  {0x40, 0xA0, 0x025F, 0x0000, 0x0010, 0x0010,
   "\xFF\x12\x08\x63\x8B\x6A\x8A\x6B\x89\x6C\xEA\x49\x60\x11\xAE\x02"},
  {0x40, 0xA0, 0x026F, 0x0000, 0x0010, 0x0010,
   "\xEE\x90\x7F\xD4\xF0\xAF\x01\xEF\x90\x7F\xD5\xF0\x02\x04\x05\x90"},
  {0x40, 0xA0, 0x027F, 0x0000, 0x0010, 0x0010,
   "\x7F\xC4\x74\x01\xF0\x02\x04\x05\x90\x7F\xEA\xE0\xFF\x12\x09\xA0"},
  {0x40, 0xA0, 0x028F, 0x0000, 0x0010, 0x0010,
   "\x8B\x6A\x8A\x6B\x89\x6C\xEA\x49\x60\x11\xAE\x02\xEE\x90\x7F\xD4"},
  {0x40, 0xA0, 0x029F, 0x0000, 0x0010, 0x0010,
   "\xF0\xAF\x01\xEF\x90\x7F\xD5\xF0\x02\x04\x05\x90\x7F\xC4\x74\x01"},
  {0x40, 0xA0, 0x02AF, 0x0000, 0x0010, 0x0010,
   "\xF0\x02\x04\x05\x90\x7F\xC4\x74\x01\xF0\x02\x04\x05\x12\x0B\x76"},
  {0x40, 0xA0, 0x02BF, 0x0000, 0x0010, 0x0010,
   "\x02\x04\x05\x12\x0B\xA2\x02\x04\x05\x12\x0B\x9A\x02\x04\x05\x12"},
  {0x40, 0xA0, 0x02CF, 0x0000, 0x0010, 0x0010,
   "\x0B\x68\x02\x04\x05\x12\x0B\xB6\x40\x03\x02\x04\x05\x90\x7F\xE8"},
  {0x40, 0xA0, 0x02DF, 0x0000, 0x0010, 0x0010,
   "\xE0\x24\x7F\x60\x24\x14\x60\x31\x24\x02\x70\x5B\xA2\x03\xE4\x33"},
  {0x40, 0xA0, 0x02EF, 0x0000, 0x0010, 0x0010,
   "\xFF\x25\xE0\xFF\xA2\x00\xE4\x33\x4F\x90\x7F\x00\xF0\xE4\xA3\xF0"},
  {0x40, 0xA0, 0x02FF, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xB5\x74\x02\xF0\x02\x04\x05\xE4\x90\x7F\x00\xF0\xA3\xF0"},
  {0x40, 0xA0, 0x030F, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xB5\x74\x02\xF0\x02\x04\x05\x90\x7F\xEC\xE0\xF4\x54\x80"},
  {0x40, 0xA0, 0x031F, 0x0000, 0x0010, 0x0010,
   "\xFF\xC4\x54\x0F\xFF\xE0\x54\x07\x2F\x25\xE0\x24\xB4\xF5\x82\xE4"},
  {0x40, 0xA0, 0x032F, 0x0000, 0x0010, 0x0010,
   "\x34\x7F\xF5\x83\xE0\x54\xFD\x90\x7F\x00\xF0\xE4\xA3\xF0\x90\x7F"},
  {0x40, 0xA0, 0x033F, 0x0000, 0x0010, 0x0010,
   "\xB5\x74\x02\xF0\x02\x04\x05\x90\x7F\xC4\x74\x01\xF0\x02\x04\x05"},
  {0x40, 0xA0, 0x034F, 0x0000, 0x0010, 0x0010,
   "\x12\x0B\xB8\x40\x03\x02\x04\x05\x90\x7F\xE8\xE0\x24\xFE\x60\x1C"},
  {0x40, 0xA0, 0x035F, 0x0000, 0x0010, 0x0010,
   "\x24\x02\x60\x03\x02\x04\x05\x90\x7F\xEA\xE0\xB4\x01\x05\xC2\x03"},
  {0x40, 0xA0, 0x036F, 0x0000, 0x0010, 0x0010,
   "\x02\x04\x05\x90\x7F\xC4\x74\x01\xF0\x02\x04\x05\x90\x7F\xEA\xE0"},
  {0x40, 0xA0, 0x037F, 0x0000, 0x0010, 0x0010,
   "\x70\x1F\x90\x7F\xEC\xE0\xF4\x54\x80\xFF\xC4\x54\x0F\xFF\xE0\x54"},
  {0x40, 0xA0, 0x038F, 0x0000, 0x0010, 0x0010,
   "\x07\x2F\x25\xE0\x24\xB4\xF5\x82\xE4\x34\x7F\xF5\x83\xE4\xF0\x80"},
  {0x40, 0xA0, 0x039F, 0x0000, 0x0010, 0x0010,
   "\x65\x90\x7F\xC4\x74\x01\xF0\x80\x5D\x12\x0B\xBA\x50\x58\x90\x7F"},
  {0x40, 0xA0, 0x03AF, 0x0000, 0x0010, 0x0010,
   "\xE8\xE0\x24\xFE\x60\x17\x24\x02\x70\x4C\x90\x7F\xEA\xE0\xB4\x01"},
  {0x40, 0xA0, 0x03BF, 0x0000, 0x0010, 0x0010,
   "\x04\xD2\x03\x80\x41\x90\x7F\xC4\x74\x01\xF0\x80\x39\x90\x7F\xEA"},
  {0x40, 0xA0, 0x03CF, 0x0000, 0x0010, 0x0010,
   "\xE0\x70\x20\x90\x7F\xEC\xE0\xF4\x54\x80\xFF\xC4\x54\x0F\xFF\xE0"},
  {0x40, 0xA0, 0x03DF, 0x0000, 0x0010, 0x0010,
   "\x54\x07\x2F\x25\xE0\x24\xB4\xF5\x82\xE4\x34\x7F\xF5\x83\x74\x01"},
  {0x40, 0xA0, 0x03EF, 0x0000, 0x0010, 0x0010,
   "\xF0\x80\x13\x90\x7F\xC4\x74\x01\xF0\x80\x0B\x12\x0B\xBC\x50\x06"},
  {0x40, 0xA0, 0x03FF, 0x0000, 0x000D, 0x000D,
   "\x90\x7F\xC4\x74\x01\xF0\x90\x7F\xB4\xE0\x44\x02\xF0"},
  {0x40, 0xA0, 0x040C, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x09E1, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xDE\x74\x06\xF0\x90\x7F\xDF\x74\x04\xF0\x90\x7F\xDD\x74"},
  {0x40, 0xA0, 0x09F1, 0x0000, 0x0010, 0x0010,
   "\x18\xF0\x90\x7F\xB6\x74\x02\xF0\x90\x7F\xB8\xF0\x90\x7F\xBA\xF0"},
  {0x40, 0xA0, 0x0A01, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xBC\xF0\x90\x7F\xBE\xF0\x90\x7F\xC0\xF0\x90\x7F\xC2\xF0"},
  {0x40, 0xA0, 0x0A11, 0x0000, 0x0006, 0x0006, "\xE4\x90\x7F\xC9\xF0\x22"},
  {0x40, 0xA0, 0x0B91, 0x0000, 0x0009, 0x0009,
   "\x90\x7F\xAF\xE0\x44\x08\xF0\xD3\x22"},
  {0x40, 0xA0, 0x0BB2, 0x0000, 0x0002, 0x0002, "\xD3\x22"},
  {0x40, 0xA0, 0x0BB4, 0x0000, 0x0002, 0x0002, "\xD3\x22"},
  {0x40, 0xA0, 0x0B9A, 0x0000, 0x0008, 0x0008,
   "\x90\x7F\xEA\xE0\xF5\x76\xD3\x22"},
  {0x40, 0xA0, 0x0B68, 0x0000, 0x000E, 0x000E,
   "\x90\x7F\x00\xE5\x76\xF0\x90\x7F\xB5\x74\x01\xF0\xD3\x22"},
  {0x40, 0xA0, 0x0BA2, 0x0000, 0x0008, 0x0008,
   "\x90\x7F\xEA\xE0\xF5\x75\xD3\x22"},
  {0x40, 0xA0, 0x0B76, 0x0000, 0x000E, 0x000E,
   "\x90\x7F\x00\xE5\x75\xF0\x90\x7F\xB5\x74\x01\xF0\xD3\x22"},
  {0x40, 0xA0, 0x0BB6, 0x0000, 0x0002, 0x0002, "\xD3\x22"},
  {0x40, 0xA0, 0x0BB8, 0x0000, 0x0002, 0x0002, "\xD3\x22"},
  {0x40, 0xA0, 0x0BBA, 0x0000, 0x0002, 0x0002, "\xD3\x22"},
  {0x40, 0xA0, 0x0BBC, 0x0000, 0x0002, 0x0002, "\xD3\x22"},
  {0x40, 0xA0, 0x0A6D, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\xD2"},
  {0x40, 0xA0, 0x0A7D, 0x0000, 0x0010, 0x0010,
   "\x01\x53\x91\xEF\x90\x7F\xAB\x74\x01\xF0\xD0\x86\xD0\x84\xD0\x85"},
  {0x40, 0xA0, 0x0A8D, 0x0000, 0x0007, 0x0007,
   "\xD0\x82\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x0A43, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\x90"},
  {0x40, 0xA0, 0x0A53, 0x0000, 0x0010, 0x0010,
   "\x7F\xC4\xE4\xF0\x53\x91\xEF\x90\x7F\xAB\x74\x04\xF0\xD0\x86\xD0"},
  {0x40, 0xA0, 0x0A63, 0x0000, 0x000A, 0x000A,
   "\x84\xD0\x85\xD0\x82\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x0803, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\xC0"},
  {0x40, 0xA0, 0x0813, 0x0000, 0x0001, 0x0001, "\xD0"},
  {0x40, 0xA0, 0x0814, 0x0000, 0x0010, 0x0010,
   "\x53\x91\xEF\x90\x7F\xAB\x74\x02\xF0\x30\x05\x14\x15\x72\xE5\x72"},
  {0x40, 0xA0, 0x0824, 0x0000, 0x0010, 0x0010,
   "\x70\x2E\x43\x21\x10\xC2\x05\xC3\x74\x1E\x95\x74\xF5\x72\x80\x20"},
  {0x40, 0xA0, 0x0834, 0x0000, 0x0010, 0x0010,
   "\xD5\x72\x1D\x53\x21\xEF\xD2\x05\xE5\x73\x25\x74\xF5\x74\x64\x02"},
  {0x40, 0xA0, 0x0844, 0x0000, 0x0010, 0x0010,
   "\x60\x05\xE5\x74\xB4\x1C\x06\xE5\x73\xF4\x04\xF5\x73\x85\x74\x72"},
  {0x40, 0xA0, 0x0854, 0x0000, 0x000F, 0x000F,
   "\xD0\xD0\xD0\x86\xD0\x84\xD0\x85\xD0\x82\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x0ABB, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\x53"},
  {0x40, 0xA0, 0x0ACB, 0x0000, 0x0010, 0x0010,
   "\x91\xEF\x90\x7F\xAB\x74\x10\xF0\xD0\x86\xD0\x84\xD0\x85\xD0\x82"},
  {0x40, 0xA0, 0x0ADB, 0x0000, 0x0005, 0x0005, "\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x0BBE, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0A94, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\xD2"},
  {0x40, 0xA0, 0x0AA4, 0x0000, 0x0010, 0x0010,
   "\x04\x53\x91\xEF\x90\x7F\xAB\x74\x08\xF0\xD0\x86\xD0\x84\xD0\x85"},
  {0x40, 0xA0, 0x0AB4, 0x0000, 0x0007, 0x0007,
   "\xD0\x82\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x0BBF, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0BC0, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0BC1, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0BC2, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0BC3, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0BC4, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0BC5, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0BC6, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0BC7, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0BC8, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0BC9, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0BCA, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0BCB, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0BCC, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0BCD, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0BCE, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0B26, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xD6\xE0\x30\xE7\x12\xE0\x44\x01\xF0\x7F\x14\x7E\x00\x12"},
  {0x40, 0xA0, 0x0B36, 0x0000, 0x000A, 0x000A,
   "\x0B\x40\x90\x7F\xD6\xE0\x54\xFE\xF0\x22"},
  {0x40, 0xA0, 0x0B05, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xD6\xE0\x44\x80\xF0\x43\x87\x01\x00\x00\x00\x00\x00\x22"},
  {0x40, 0xA0, 0x0AE0, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xD6\xE0\x54\xFB\xF0\xE0\x44\x08\xF0\x30\x06\x04\xE0\x44"},
  {0x40, 0xA0, 0x0AF0, 0x0000, 0x0010, 0x0010,
   "\x02\xF0\x7F\xF4\x7E\x01\x12\x0B\x40\x90\x7F\xD6\xE0\x54\xF7\xF0"},
  {0x40, 0xA0, 0x0B00, 0x0000, 0x0005, 0x0005, "\xE0\x44\x04\xF0\x22"},
  {0x40, 0xA0, 0x09A0, 0x0000, 0x0002, 0x0002, "\x8F\x6D"},
  {0x40, 0xA0, 0x09A2, 0x0000, 0x0010, 0x0010,
   "\xE4\xF5\x6E\x75\x6F\xFF\x75\x70\x01\x75\x71\xF9\xAB\x6F\xAA\x70"},
  {0x40, 0xA0, 0x09B2, 0x0000, 0x0010, 0x0010,
   "\xA9\x71\x90\x00\x01\x12\x06\xAC\xB4\x03\x1D\xAF\x6E\x05\x6E\xEF"},
  {0x40, 0xA0, 0x09C2, 0x0000, 0x0010, 0x0010,
   "\xB5\x6D\x01\x22\x12\x06\x93\x7E\x00\x29\xFF\xEE\x3A\xA9\x07\x75"},
  {0x40, 0xA0, 0x09D2, 0x0000, 0x000E, 0x000E,
   "\x6F\xFF\xF5\x70\x89\x71\x80\xD4\x7B\x00\x7A\x00\x79\x00"},
  {0x40, 0xA0, 0x09E0, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x0863, 0x0000, 0x0010, 0x0010,
   "\xE4\xFE\x75\x6F\xFF\x75\x70\x01\x75\x71\xD2\xAB\x6F\xAA\x70\xA9"},
  {0x40, 0xA0, 0x0873, 0x0000, 0x0010, 0x0010,
   "\x71\x90\x00\x01\x12\x06\xAC\x64\x02\x70\x2D\xAD\x06\x0E\xED\xB5"},
  {0x40, 0xA0, 0x0883, 0x0000, 0x0010, 0x0010,
   "\x07\x01\x22\x90\x00\x02\x12\x06\xD9\x85\xF0\x6D\xF5\x6E\x62\x6D"},
  {0x40, 0xA0, 0x0893, 0x0000, 0x0010, 0x0010,
   "\xE5\x6D\x62\x6E\xE5\x6E\x62\x6D\x29\xFD\xE5\x6D\x3A\xA9\x05\x75"},
  {0x40, 0xA0, 0x08A3, 0x0000, 0x000E, 0x000E,
   "\x6F\xFF\xF5\x70\x89\x71\x80\xC3\x7B\x00\x7A\x00\x79\x00"},
  {0x40, 0xA0, 0x08B1, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x0B40, 0x0000, 0x0010, 0x0010,
   "\x8E\x6A\x8F\x6B\xE5\x6B\x15\x6B\xAE\x6A\x70\x02\x15\x6A\x4E\x60"},
  {0x40, 0xA0, 0x0B50, 0x0000, 0x0007, 0x0007,
   "\x05\x12\x0B\x15\x80\xEE\x22"},
  {0x40, 0xA0, 0x0B15, 0x0000, 0x0010, 0x0010,
   "\x74\x00\xF5\x86\x90\xFD\xA5\x7C\x05\xA3\xE5\x82\x45\x83\x70\xF9"},
  {0x40, 0xA0, 0x0B25, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x0000, 0x0000, 0x0003, 0x0003, "\x02\x05\x7C"},
  {0x40, 0xA0, 0x057C, 0x0000, 0x000C, 0x000C,
   "\x78\x7F\xE4\xF6\xD8\xFD\x75\x81\x76\x02\x05\xC3"},
  {0x40, 0xA0, 0x0693, 0x0000, 0x0010, 0x0010,
   "\xBB\x01\x06\x89\x82\x8A\x83\xE0\x22\x50\x02\xE7\x22\xBB\xFE\x02"},
  {0x40, 0xA0, 0x06A3, 0x0000, 0x0009, 0x0009,
   "\xE3\x22\x89\x82\x8A\x83\xE4\x93\x22"},
  {0x40, 0xA0, 0x06AC, 0x0000, 0x0010, 0x0010,
   "\xBB\x01\x0C\xE5\x82\x29\xF5\x82\xE5\x83\x3A\xF5\x83\xE0\x22\x50"},
  {0x40, 0xA0, 0x06BC, 0x0000, 0x0010, 0x0010,
   "\x06\xE9\x25\x82\xF8\xE6\x22\xBB\xFE\x06\xE9\x25\x82\xF8\xE2\x22"},
  {0x40, 0xA0, 0x06CC, 0x0000, 0x000D, 0x000D,
   "\xE5\x82\x29\xF5\x82\xE5\x83\x3A\xF5\x83\xE4\x93\x22"},
  {0x40, 0xA0, 0x06D9, 0x0000, 0x0010, 0x0010,
   "\xBB\x01\x10\xE5\x82\x29\xF5\x82\xE5\x83\x3A\xF5\x83\xE0\xF5\xF0"},
  {0x40, 0xA0, 0x06E9, 0x0000, 0x0010, 0x0010,
   "\xA3\xE0\x22\x50\x09\xE9\x25\x82\xF8\x86\xF0\x08\xE6\x22\xBB\xFE"},
  {0x40, 0xA0, 0x06F9, 0x0000, 0x0010, 0x0010,
   "\x0A\xE9\x25\x82\xF8\xE2\xF5\xF0\x08\xE2\x22\xE5\x83\x2A\xF5\x83"},
  {0x40, 0xA0, 0x0709, 0x0000, 0x0008, 0x0008,
   "\xE9\x93\xF5\xF0\xA3\xE9\x93\x22"},
  {0x40, 0xA0, 0x0711, 0x0000, 0x0006, 0x0006, "\x8A\x83\x89\x82\xE4\x73"},
  {0x40, 0xA0, 0x0588, 0x0000, 0x0010, 0x0010,
   "\x02\x04\x0D\xE4\x93\xA3\xF8\xE4\x93\xA3\x40\x03\xF6\x80\x01\xF2"},
  {0x40, 0xA0, 0x0598, 0x0000, 0x0010, 0x0010,
   "\x08\xDF\xF4\x80\x29\xE4\x93\xA3\xF8\x54\x07\x24\x0C\xC8\xC3\x33"},
  {0x40, 0xA0, 0x05A8, 0x0000, 0x0010, 0x0010,
   "\xC4\x54\x0F\x44\x20\xC8\x83\x40\x04\xF4\x56\x80\x01\x46\xF6\xDF"},
  {0x40, 0xA0, 0x05B8, 0x0000, 0x0010, 0x0010,
   "\xE4\x80\x0B\x01\x02\x04\x08\x10\x20\x40\x80\x90\x08\xB2\xE4\x7E"},
  {0x40, 0xA0, 0x05C8, 0x0000, 0x0010, 0x0010,
   "\x01\x93\x60\xBC\xA3\xFF\x54\x3F\x30\xE5\x09\x54\x1F\xFE\xE4\x93"},
  {0x40, 0xA0, 0x05D8, 0x0000, 0x0010, 0x0010,
   "\xA3\x60\x01\x0E\xCF\x54\xC0\x25\xE0\x60\xA8\x40\xB8\xE4\x93\xA3"},
  {0x40, 0xA0, 0x05E8, 0x0000, 0x0010, 0x0010,
   "\xFA\xE4\x93\xA3\xF8\xE4\x93\xA3\xC8\xC5\x82\xC8\xCA\xC5\x83\xCA"},
  {0x40, 0xA0, 0x05F8, 0x0000, 0x0010, 0x0010,
   "\xF0\xA3\xC8\xC5\x82\xC8\xCA\xC5\x83\xCA\xDF\xE9\xDE\xE7\x80\xBE"},
  {0x40, 0xA0, 0x08FC, 0x0000, 0x0001, 0x0001, "\x00"},
  {0x40, 0xA0, 0x7F92, 0x0000, 0x0001, 0x0001, "\x01"},
  {0x40, 0xA0, 0x7F92, 0x0000, 0x0001, 0x0001, "\x00"},
  {0x00, 0x05, 0x0002, 0x0000, 0x0000, 0x0000, ""},
  {0x00, 0x09, 0x0001, 0x0000, 0x0000, 0x0000, ""},
  {0x00, 0x00, 0x0000, 0x0000, 0x0000, 0x0000, NULL}
};
