/**
  @file btsdp-bt.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2006 Nokia Corporation. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/
#ifndef _BTSDP_BT_H_
#define _BTSDP_BT_H_

#include <stdint.h>
#include <glib.h>
#include "btsdp-dbus.h"

#define BT_DEV_ID 0

#define SDP_SERVICE_RFCOMM    ((int)'r')
#define SDP_SERVICE_L2CAP     ((int)'l')
#define SDP_SERVICE_ERROR     ((int)'E')

typedef struct {
    char     type;
    char    *service;
    uint8_t  channel;
    uint32_t ttl;
    char    *name;
} sdp_info_t;

void free_sdp_info(sdp_info_t *info, gpointer user_data);

gboolean get_services(const char *bda, GSList *l,
                      sdp_cb_data_t *data, GError **err);

#endif /* _BTSDP_BT_H_ */
